/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import java.io.IOException;
import org.eclipse.packager.rpm.build.FileInformation;
import org.eclipse.packager.rpm.build.FileInformationCustomizer;
import org.eclipse.packager.rpm.build.PayloadEntryType;
import org.eclipse.packager.rpm.build.SimpleFileInformationCustomizer;

@FunctionalInterface
public interface FileInformationProvider<T> {
    public FileInformation provide(String var1, T var2, PayloadEntryType var3) throws IOException;

    default public FileInformationProvider<T> customize(FileInformationCustomizer<T> customizer) {
        if (customizer == null) {
            return this;
        }
        return (targetName, object, type) -> {
            FileInformation information = this.provide(targetName, object, type);
            customizer.perform(object, information);
            return information;
        };
    }

    default public FileInformationProvider<T> customize(SimpleFileInformationCustomizer customizer) {
        if (customizer == null) {
            return this;
        }
        return (targetName, object, type) -> {
            FileInformation information = this.provide(targetName, object, type);
            customizer.perform(information);
            return information;
        };
    }
}

