/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jirareport;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jirareport.ArraysUtil;
import org.codehaus.swizzle.jirareport.CollectionsUtil;
import org.codehaus.swizzle.jirareport.DateUtil;
import org.codehaus.swizzle.jirareport.MissingParamsException;
import org.codehaus.swizzle.jirareport.Param;
import org.codehaus.swizzle.jirareport.ParamsUtil;
import org.codehaus.swizzle.jirareport.StringsUtil;

public class Main {
    static /* synthetic */ Class class$org$codehaus$swizzle$jirareport$FederatedResourceLoader;

    public static void main(String[] args) throws Throwable {
        ArrayList<String> newargs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-D")) {
                String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
                String val = arg.substring(arg.indexOf("=") + 1);
                System.setProperty(prop, val);
                continue;
            }
            newargs.add(arg);
        }
        args = newargs.toArray(new String[0]);
        if (args.length == 0 && System.getProperty("export") != null) {
            String template = System.getProperty("export");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = cl.getResourceAsStream(template);
            in = new BufferedInputStream(in);
            int i = in.read();
            while (i != -1) {
                System.out.write(i);
                i = in.read();
            }
            in.close();
            return;
        }
        if (args.length > 0) {
            System.setProperty("template", args[0]);
        }
        String templateName = System.getProperty("template", "report.vm");
        try {
            Main.generate(templateName, System.out);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (MethodInvocationException e) {
            Throwable wrappedThrowable = e.getWrappedThrowable();
            if (wrappedThrowable instanceof MissingParamsException) {
                MissingParamsException missingParamsException = (MissingParamsException)wrappedThrowable;
                Param[] missingArgs = missingParamsException.getParams();
                System.err.println("Invalid or missing arguments.");
                for (int i = 0; i < missingArgs.length; ++i) {
                    Param param = missingArgs[i];
                    System.err.print("  [");
                    System.err.print(param.getStatus());
                    System.err.print("]    ");
                    System.err.print(param.getName());
                    System.err.print("    : ");
                    System.err.print(param.getDescription());
                    System.err.print(". Must Match Pattern '");
                    System.err.print(param.getRegex());
                    System.err.println("'");
                }
                System.exit(1);
            }
            throw e;
        }
    }

    public static void generate(String templateName, PrintStream result) throws Exception {
        VelocityContext context = new VelocityContext();
        Main.generate(context, templateName, result);
    }

    public static void generate(VelocityContext context, String templateName, PrintStream result) throws Exception {
        List<Object> keys = Arrays.asList(context.getKeys());
        Iterator iterator = ((Hashtable)System.getProperties()).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (keys.contains(name)) continue;
            context.put(name, (Object)value);
        }
        context.put("rss", (Object)new Rss());
        context.put("xmlrpc", (Object)new Xmlrpc());
        context.put("arrays", (Object)new ArraysUtil());
        context.put("collections", (Object)new CollectionsUtil());
        context.put("strings", (Object)new StringsUtil());
        context.put("utils", (Object)new UtilsUtil());
        context.put("params", (Object)new ParamsUtil(context));
        context.put("date", (Object)new DateUtil(System.getProperty("dateFormat", "yyyy-MM-dd")));
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("resource.loader", (Object)"all");
        velocity.setProperty("all.resource.loader.class", (Object)(class$org$codehaus$swizzle$jirareport$FederatedResourceLoader == null ? (class$org$codehaus$swizzle$jirareport$FederatedResourceLoader = Main.class$("org.codehaus.swizzle.jirareport.FederatedResourceLoader")) : class$org$codehaus$swizzle$jirareport$FederatedResourceLoader).getName());
        velocity.init();
        Template template = velocity.getTemplate(templateName);
        PrintWriter writer = new PrintWriter(result);
        template.merge((Context)context, (Writer)writer);
        writer.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Xmlrpc {
        public Jira connect(String user, String url) throws Exception {
            String[] strings = user.split(":");
            Jira jira = new Jira(url);
            jira.login(strings[0], strings[1]);
            return jira;
        }
    }

    public static class Rss {
        public JiraRss fetch(String url) throws Exception {
            return new JiraRss(url);
        }
    }

    public static class UtilsUtil {
        public Object load(String classname) throws Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(classname);
            return clazz.newInstance();
        }
    }
}

