/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jirareport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.swizzle.jira.Attachment;
import org.codehaus.swizzle.jira.Project;

public class AttachmentsUtil {
    private File attachmentsDir;

    public File getAttachmentsDir() {
        return this.attachmentsDir;
    }

    public void setAttachmentsDir(File attachmentsDir) {
        this.attachmentsDir = attachmentsDir;
    }

    public File saveAttachment(File dir, Attachment attachment) throws IOException {
        File idDir = new File(dir, attachment.getId() + "");
        idDir.mkdir();
        File file = new File(idDir, attachment.getFileName());
        FileOutputStream out = new FileOutputStream(file);
        URL url = attachment.getUrl();
        InputStream in = url.openStream();
        try {
            in = new BufferedInputStream(in);
            int i = in.read();
            while (i != -1) {
                out.write(i);
                i = in.read();
            }
        }
        catch (IOException e) {
            out.close();
            in.close();
        }
        return file;
    }

    public File saveAttachment(Attachment attachment) throws IOException {
        return this.saveAttachment(this.getOrCreateAttachmentsDir("attachments"), attachment);
    }

    public File createAttachmentsTmpDir(Project project) throws IOException {
        return this.getOrCreateAttachmentsDir(project.getKey().toLowerCase() + "-attachments");
    }

    private File getOrCreateAttachmentsDir(String prefix) throws IOException {
        if (this.attachmentsDir != null) {
            return this.attachmentsDir;
        }
        File tempFile = File.createTempFile("foo", "bar");
        File tmpDir = tempFile.getParentFile();
        int suffix = 1;
        File dir = new File(tmpDir, prefix);
        while (dir.exists()) {
            dir = new File(tmpDir, prefix + suffix++);
        }
        if (!dir.mkdir()) {
            throw new IOException("Could not create tmp attachments dir " + dir.getName());
        }
        this.attachmentsDir = dir;
        return this.attachmentsDir;
    }
}

