/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Sonar;
import org.sonar.updatecenter.common.SonarUpdate;
import org.sonar.updatecenter.common.Version;
import org.sonar.updatecenter.common.exception.IncompatiblePluginVersionException;
import org.sonar.updatecenter.common.exception.PluginNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCenter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCenter.class);
    private PluginReferential updateCenterPluginReferential;
    private PluginReferential installedPluginReferential;
    private Version installedSonarVersion;
    private Date date;
    private Sonar sonar;

    private UpdateCenter(PluginReferential updateCenterPluginReferential, Sonar sonar) {
        this.updateCenterPluginReferential = updateCenterPluginReferential;
        this.sonar = sonar;
        this.installedPluginReferential = PluginReferential.createEmpty();
    }

    public static UpdateCenter create(PluginReferential updateCenterPluginReferential, Sonar sonar) {
        return new UpdateCenter(updateCenterPluginReferential, sonar);
    }

    public PluginReferential getUpdateCenterPluginReferential() {
        return this.updateCenterPluginReferential;
    }

    public UpdateCenter registerInstalledPlugins(PluginReferential installedPluginReferential) {
        this.installedPluginReferential = installedPluginReferential;
        return this;
    }

    public Sonar getSonar() {
        return this.sonar;
    }

    public UpdateCenter setInstalledSonarVersion(Version installedSonarVersion) {
        this.installedSonarVersion = installedSonarVersion;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public UpdateCenter setDate(Date date) {
        this.date = date;
        return this;
    }

    public List<PluginUpdate> findAvailablePlugins() {
        Version adjustedSonarVersion = this.getAdjustedSonarVersion();
        ArrayList availables = Lists.newArrayList();
        for (Plugin plugin : this.updateCenterPluginReferential.getPlugins()) {
            if (this.isInstalled(plugin)) continue;
            Release release = plugin.getLastCompatibleRelease(adjustedSonarVersion);
            if (release != null) {
                if (!release.isMaster()) continue;
                try {
                    PluginUpdate pluginUpdate = PluginUpdate.createWithStatus(release, PluginUpdate.Status.COMPATIBLE);
                    pluginUpdate.setDependencies(this.findInstallablePlugins(plugin.getKey(), release.getVersion()));
                    availables.add(pluginUpdate);
                }
                catch (IncompatiblePluginVersionException e) {
                    availables.add(PluginUpdate.createWithStatus(release, PluginUpdate.Status.DEPENDENCIES_REQUIRE_SONAR_UPGRADE));
                }
                continue;
            }
            release = plugin.getLastCompatibleReleaseIfUpgrade(adjustedSonarVersion);
            if (release == null || !release.isMaster()) continue;
            availables.add(PluginUpdate.createWithStatus(release, PluginUpdate.Status.REQUIRE_SONAR_UPGRADE));
        }
        return availables;
    }

    public List<PluginUpdate> findPluginUpdates() {
        ArrayList updates = Lists.newArrayList();
        for (Release installedRelease : this.getInstalledMasterReleases()) {
            try {
                Plugin plugin = this.findPlugin(installedRelease);
                for (Release nextRelease : plugin.getReleasesGreaterThan(installedRelease.getVersion())) {
                    PluginUpdate pluginUpdate = PluginUpdate.createForPluginRelease(nextRelease, this.getAdjustedSonarVersion());
                    try {
                        if (pluginUpdate.isCompatible()) {
                            pluginUpdate.setDependencies(this.findInstallablePlugins(plugin.getKey(), nextRelease.getVersion()));
                        }
                    }
                    catch (IncompatiblePluginVersionException e) {
                        pluginUpdate.setStatus(PluginUpdate.Status.DEPENDENCIES_REQUIRE_SONAR_UPGRADE);
                    }
                    updates.add(pluginUpdate);
                }
            }
            catch (NoSuchElementException e) {
            }
        }
        return updates;
    }

    public List<Release> findInstallablePlugins(String pluginKey, Version minimumVersion) {
        HashSet installablePlugins = Sets.newHashSet();
        HashSet checkedPlugins = Sets.newHashSet();
        this.addInstallablePlugins(pluginKey, minimumVersion, installablePlugins, checkedPlugins);
        return Lists.newArrayList((Iterable)installablePlugins);
    }

    private void addInstallablePlugins(String pluginKey, Version minimumVersion, Set<Release> installablePlugins, Set<Release> checkedPlugins) {
        try {
            Plugin plugin;
            Release pluginRelease;
            if (!this.contain(pluginKey, installablePlugins) && !this.contain(pluginKey, checkedPlugins) && (pluginRelease = (plugin = this.updateCenterPluginReferential.findPlugin(pluginKey)).getLastCompatibleRelease(this.getAdjustedSonarVersion())) != null) {
                if (pluginRelease.getVersion().compareTo(minimumVersion) < 0) {
                    throw new IncompatiblePluginVersionException("Plugin " + pluginKey + " is needed to be installed at version greater or equal " + minimumVersion);
                }
                this.addInstallableRelease(pluginRelease, installablePlugins, checkedPlugins);
            }
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException("Needed plugin '" + pluginKey + "' version " + minimumVersion + " not found.", e);
        }
    }

    private void addInstallableRelease(Release pluginRelease, Set<Release> installablePlugins, Set<Release> checkedPlugins) {
        this.addReleaseIfNotAlreadyInstalled(pluginRelease, installablePlugins);
        checkedPlugins.add(pluginRelease);
        for (Release child : pluginRelease.getChildren()) {
            this.addReleaseIfNotAlreadyInstalled(child, installablePlugins);
        }
        for (Release outgoingDependency : pluginRelease.getOutgoingDependencies()) {
            this.addInstallablePlugins(outgoingDependency.getArtifact().getKey(), outgoingDependency.getVersion(), installablePlugins, checkedPlugins);
        }
        for (Release incomingDependency : pluginRelease.getIncomingDependencies()) {
            String pluginKey = incomingDependency.getArtifact().getKey();
            if (!this.isInstalled(pluginKey)) continue;
            this.addInstallablePlugins(pluginKey, incomingDependency.getVersion(), installablePlugins, checkedPlugins);
        }
    }

    private boolean contain(final String pluginKey, Set<Release> installablePlugins) {
        return Iterables.any(installablePlugins, (Predicate)new Predicate<Release>(){

            public boolean apply(Release input) {
                return input.getKey().equals(pluginKey);
            }
        });
    }

    private void addReleaseIfNotAlreadyInstalled(Release release, Set<Release> installablePlugins) {
        if (!this.isInstalled(release)) {
            installablePlugins.add(release);
        }
    }

    public List<SonarUpdate> findSonarUpdates() {
        ArrayList updates = Lists.newArrayList();
        SortedSet<Release> releases = this.sonar.getReleasesGreaterThan(this.installedSonarVersion);
        for (Release release : releases) {
            updates.add(this.createSonarUpdate(release));
        }
        return updates;
    }

    private SonarUpdate createSonarUpdate(Release sonarRelease) {
        SonarUpdate update = new SonarUpdate(sonarRelease);
        for (Release installedRelease : this.getInstalledMasterReleases()) {
            try {
                Plugin plugin = this.findPlugin(installedRelease);
                Release release = plugin.getRelease(installedRelease.getAdjustedVersion());
                if (release.supportSonarVersion(sonarRelease.getVersion())) {
                    update.addCompatiblePlugin(plugin);
                    continue;
                }
                boolean ok = false;
                Release compatibleRelease = null;
                for (Release greaterPluginRelease : plugin.getReleasesGreaterThan(installedRelease.getVersion())) {
                    if (!greaterPluginRelease.supportSonarVersion(sonarRelease.getVersion())) continue;
                    compatibleRelease = greaterPluginRelease;
                    ok = true;
                }
                if (ok) {
                    update.addPluginToUpgrade(compatibleRelease);
                    continue;
                }
                update.addIncompatiblePlugin(plugin);
            }
            catch (NoSuchElementException e) {
                LOG.info("The plugin '" + installedRelease.getArtifact().getKey() + "' version : " + installedRelease.getVersion().getName() + " has not been found on the update center.");
            }
        }
        return update;
    }

    @VisibleForTesting
    PluginReferential getInstalledPluginReferential() {
        return this.installedPluginReferential;
    }

    private Version getAdjustedSonarVersion() {
        return Version.createRelease(this.installedSonarVersion.toString());
    }

    private boolean isInstalled(Release releaseToFind) {
        return this.installedPluginReferential.doesContainRelease(releaseToFind.getArtifact().getKey(), releaseToFind.getVersion());
    }

    private boolean isInstalled(Plugin plugin) {
        return this.isInstalled(plugin.getKey());
    }

    private boolean isInstalled(String pluginKey) {
        return this.installedPluginReferential.doesContainPlugin(pluginKey);
    }

    private Plugin findPlugin(Release release) {
        String key = release.getArtifact().getKey();
        return this.updateCenterPluginReferential.findPlugin(key);
    }

    private List<Release> getInstalledMasterReleases() {
        return this.installedPluginReferential.getLastMasterReleases();
    }
}

