/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.gleaner.QDoxComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.SourceComponentGleaner;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private SourceComponentGleaner gleaner;

    public SourceComponentDescriptorExtractor() {
    }

    public SourceComponentDescriptorExtractor(SourceComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    @Override
    public List<ComponentDescriptor<?>> extract(MetadataGenerationRequest configuration, ComponentDescriptor<?>[] roleDefaults) throws Exception {
        if (this.gleaner == null) {
            this.gleaner = new QDoxComponentGleaner();
        }
        return this.extract(configuration.sourceDirectories, configuration.sourceEncoding, this.getDefaultsByRole(roleDefaults));
    }

    private List<ComponentDescriptor<?>> extract(List<String> sourceDirectories, String sourceEncoding, Map<String, ComponentDescriptor<?>> defaultsByRole) throws Exception {
        assert (sourceDirectories != null);
        assert (defaultsByRole != null);
        ArrayList descriptors = new ArrayList();
        JavaDocBuilder builder = new JavaDocBuilder();
        if (StringUtils.isNotEmpty((String)sourceEncoding)) {
            builder.setEncoding(sourceEncoding);
        }
        for (String sourceDirectory : sourceDirectories) {
            File dir = new File(sourceDirectory);
            builder.addSourceTree(dir);
        }
        JavaClass[] classes = builder.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            ComponentDescriptor<?> descriptor = this.gleaner.glean(builder, classes[i]);
            if (descriptor == null) continue;
            this.applyDefaults(descriptor, defaultsByRole);
            descriptors.add(descriptor);
        }
        return descriptors;
    }
}

