/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.Pack200Tool;
import org.codehaus.mojo.webstart.sign.SignConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractBaseJnlpMojo
extends AbstractMojo {
    private static final String DEFAULT_RESOURCES_DIR = "src/main/jnlp/resources";
    private static final String UNPROCESSED_PREFIX = "unprocessed_";
    public static final String JAR_SUFFIX = ".jar";
    private ArtifactResolver artifactResolver;
    private SignTool signTool;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File workDirectory;
    protected String libPath;
    private File resourcesDirectory;
    private File templateDirectory;
    private boolean pack200;
    private SignConfig sign;
    private boolean verifyjar;
    private boolean gzip;
    private boolean verbose;
    private boolean excludeTransitive;
    private boolean makeArchive;
    private boolean attachArchive;
    private String codebase;
    private String encoding;
    private final List modifiedJnlpArtifacts = new ArrayList();
    private final FileFilter unprocessedJarFileFilter;
    private final FileFilter processedJarFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(AbstractBaseJnlpMojo.JAR_SUFFIX) && !pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX);
        }
    };
    private final FileFilter unprocessedPack200FileFilter;
    private boolean unsignAlreadySignedJars;
    private boolean canUnsign;
    private List pack200Tools;

    public AbstractBaseJnlpMojo() {
        this.unprocessedJarFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && pathname.getName().endsWith(AbstractBaseJnlpMojo.JAR_SUFFIX);
            }
        };
        this.unprocessedPack200FileFilter = new UnprocessedPack200FileFilter();
    }

    public abstract MavenProject getProject();

    public String getLibPath() {
        if (this.libPath == null || this.libPath.trim().length() == 0) {
            return null;
        }
        return this.libPath;
    }

    public boolean isPack200() {
        return this.pack200;
    }

    protected void makeWorkingDirIfNecessary() throws MojoExecutionException {
        if (!this.getWorkDirectory().exists() && !this.getWorkDirectory().mkdirs()) {
            throw new MojoExecutionException("Failed to create: " + this.getWorkDirectory().getAbsolutePath());
        }
        if (!this.getLibDirectory().exists() && !this.getLibDirectory().mkdirs()) {
            throw new MojoExecutionException("Failed to create: " + this.getLibDirectory().getAbsolutePath());
        }
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected File getLibDirectory() {
        if (this.getLibPath() != null) {
            return new File(this.getWorkDirectory(), this.getLibPath());
        }
        return this.getWorkDirectory();
    }

    protected File getResourcesDirectory() {
        if (this.resourcesDirectory == null) {
            this.resourcesDirectory = new File(this.getProject().getBasedir(), DEFAULT_RESOURCES_DIR);
        }
        return this.resourcesDirectory;
    }

    protected File getTemplateDirectory() {
        return this.templateDirectory;
    }

    protected ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    protected ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    protected SignConfig getSign() {
        return this.sign;
    }

    protected String getCodebase() {
        return this.codebase;
    }

    protected boolean isGzip() {
        return this.gzip;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isVerifyjar() {
        return this.verifyjar;
    }

    protected boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    protected boolean isMakeArchive() {
        return this.makeArchive;
    }

    protected boolean isAttachArchive() {
        return this.attachArchive;
    }

    protected boolean isCanUnsign() {
        return this.canUnsign;
    }

    protected List getModifiedJnlpArtifacts() {
        return this.modifiedJnlpArtifacts;
    }

    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = "utf-8";
            this.getLog().warn((CharSequence)("No encoding defined, will use the default one : " + this.encoding));
        }
        return this.encoding;
    }

    protected void checkPack200() throws MojoExecutionException {
        if (!this.isPack200()) {
            return;
        }
        float javaVersion5 = 1.5f;
        if (SystemUtils.JAVA_VERSION_FLOAT < 1.5f) {
            throw new MojoExecutionException("Configuration error: Pack200 compression is only available on SDK 5.0 or above.");
        }
        if (this.pack200Tools.isEmpty()) {
            throw new MojoExecutionException("Configuration error: No Pack200Tool found.");
        }
    }

    protected void copyResources(File resourcesDir, File workDirectory) throws IOException {
        if (!resourcesDir.exists() && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("No resources found in " + resourcesDir.getAbsolutePath()));
        } else if (!resourcesDir.isDirectory()) {
            this.getLog().debug((CharSequence)("Not a directory: " + resourcesDir.getAbsolutePath()));
        } else {
            this.getLog().debug((CharSequence)("Copying resources from " + resourcesDir.getAbsolutePath()));
            String excludes = AbstractBaseJnlpMojo.concat(DirectoryScanner.DEFAULTEXCLUDES, ", ");
            this.copyDirectoryStructure(resourcesDir, workDirectory, "**", excludes);
        }
    }

    protected boolean copyFileToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws IOException {
        boolean shouldCopy;
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        File targetFile = new File(targetDirectory, sourceFile.getName());
        boolean bl = shouldCopy = !targetFile.exists() || targetFile.lastModified() < sourceFile.lastModified();
        if (shouldCopy) {
            FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDirectory);
        } else {
            this.getLog().debug((CharSequence)("Source file hasn't changed. Do not overwrite " + targetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    protected boolean copyJarAsUnprocessedToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws IOException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        File signedTargetFile = new File(targetDirectory, sourceFile.getName());
        File unsignedTargetFile = new File(targetDirectory, UNPROCESSED_PREFIX + sourceFile.getName());
        boolean shouldCopy = !signedTargetFile.exists() || signedTargetFile.lastModified() < sourceFile.lastModified();
        boolean bl = shouldCopy = shouldCopy && (!unsignedTargetFile.exists() || unsignedTargetFile.lastModified() < sourceFile.lastModified());
        if (shouldCopy) {
            FileUtils.copyFile((File)sourceFile, (File)unsignedTargetFile);
        } else {
            this.getLog().debug((CharSequence)("Source file hasn't changed. Do not reprocess " + signedTargetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    protected void signOrRenameJars() throws MojoExecutionException {
        if (this.getSign() != null) {
            int signedJars;
            this.getSign().init(this.getWorkDirectory(), this.isVerbose(), this.signTool);
            if (this.unsignAlreadySignedJars()) {
                this.removeExistingSignatures(this.getLibDirectory(), this.unprocessedJarFileFilter);
            }
            if (this.isPack200()) {
                this.getPack200Tool().packJars(this.getLibDirectory(), this.unprocessedJarFileFilter, this.isGzip());
                this.getPack200Tool().unpackJars(this.getLibDirectory(), this.unprocessedPack200FileFilter);
                this.deleteFiles(this.getLibDirectory(), this.unprocessedPack200FileFilter);
            }
            if ((signedJars = this.signJars(this.getLibDirectory(), this.unprocessedJarFileFilter)) != this.getModifiedJnlpArtifacts().size()) {
                throw new IllegalStateException("The number of signed artifacts (" + signedJars + ") differ from the number of modified " + "artifacts (" + this.getModifiedJnlpArtifacts().size() + "). Implementation error");
            }
        } else {
            this.makeUnprocessedFilesFinal(this.getLibDirectory(), this.unprocessedJarFileFilter);
        }
    }

    protected URL findDefaultJnlpTemplateURL() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("default-jnlp-template.vm");
    }

    protected URL findDefaultJnlpExtensionTemplateURL() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("default-jnlp-extension-template.vm");
    }

    protected URL getWebstartJarURL() {
        String url = this.findDefaultJnlpTemplateURL().toString();
        try {
            return new URL(url.substring("jar:".length(), url.indexOf("!")));
        }
        catch (Exception e) {
            IllegalStateException iae = new IllegalStateException("Failure to find webstart Jar URL: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    protected String getWebstartJarURLForVelocity() {
        String url = this.findDefaultJnlpTemplateURL().toString();
        return url.substring(0, url.indexOf("!") + 2);
    }

    protected boolean isJarSigned(File jarFile) throws MojoExecutionException {
        return this.signTool.isJarSigned(this.getSign(), jarFile);
    }

    protected void packJars() {
        if (this.isPack200()) {
            this.getLog().debug((CharSequence)"packing jars");
            this.getPack200Tool().packJars(this.getLibDirectory(), this.processedJarFileFilter, this.isGzip());
        }
    }

    protected boolean artifactContainsClass(Artifact artifact, String mainClass) throws MalformedURLException {
        boolean containsClass = true;
        URLClassLoader cl = new URLClassLoader(new URL[]{artifact.getFile().toURI().toURL()});
        Class<?> c = null;
        try {
            c = Class.forName(mainClass, false, cl);
        }
        catch (ClassNotFoundException e) {
            this.getLog().debug((CharSequence)("artifact " + artifact + " doesn't contain the main class: " + mainClass));
            containsClass = false;
        }
        catch (Throwable t) {
            this.getLog().info((CharSequence)("artifact " + artifact + " seems to contain the main class: " + mainClass + " but the jar doesn't seem to contain all dependencies " + t.getMessage()));
        }
        if (c != null) {
            this.getLog().debug((CharSequence)"Checking if the loaded class contains a main method.");
            try {
                c.getMethod("main", String;.class);
            }
            catch (NoSuchMethodException e) {
                this.getLog().warn((CharSequence)("The specified main class (" + mainClass + ") doesn't seem to contain a main method... " + "Please check your configuration." + e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                this.getLog().warn((CharSequence)("Something failed while checking if the main class contains the main() method. This is probably due to the limited classpath we have provided to the class loader. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method... " + e.getMessage()));
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)("Unknown error: Couldn't check if the main class has a main method. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method..."), t);
            }
        }
        return containsClass;
    }

    protected boolean unsignAlreadySignedJars() {
        return this.unsignAlreadySignedJars;
    }

    protected Pack200Tool getPack200Tool() {
        return (Pack200Tool)this.pack200Tools.get(0);
    }

    protected void verboseLog(String msg) {
        this.infoOrDebug(this.isVerbose() || this.getLog().isInfoEnabled(), msg);
    }

    private static String concat(String[] array, String delim) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            String s = array[i];
            buffer.append(s).append(delim);
        }
        return buffer.toString();
    }

    private void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List files = FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destinationDirectory));
            String path = file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length() + 1);
            File destDir = new File(destinationDirectory, path);
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destDir));
            if (file.isDirectory()) {
                destDir.mkdirs();
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir.getParentFile());
        }
    }

    private int makeUnprocessedFilesFinal(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("makeUnprocessedFilesFinal in " + directory + " found " + jarFiles.length + " file(s) to rename"));
        }
        if (jarFiles.length == 0) {
            return 0;
        }
        for (int i = 0; i < jarFiles.length; ++i) {
            boolean deleted;
            String unprocessedJarFileName = jarFiles[i].getName();
            if (!unprocessedJarFileName.startsWith(UNPROCESSED_PREFIX)) {
                throw new IllegalStateException("We are about to sign an non unprocessed_ file with path: " + jarFiles[i].getAbsolutePath());
            }
            File finalJar = new File(jarFiles[i].getParent(), unprocessedJarFileName.substring(UNPROCESSED_PREFIX.length()));
            if (finalJar.exists() && !(deleted = finalJar.delete())) {
                throw new IllegalStateException("Couldn't delete obsolete final jar: " + finalJar.getAbsolutePath());
            }
            boolean renamed = jarFiles[i].renameTo(finalJar);
            if (renamed) continue;
            throw new IllegalStateException("Couldn't rename into final jar: " + finalJar.getAbsolutePath());
        }
        return jarFiles.length;
    }

    private int deleteFiles(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] files = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("deleteFiles in " + directory + " found " + files.length + " file(s) to delete"));
        }
        if (files.length == 0) {
            return 0;
        }
        for (int i = 0; i < files.length; ++i) {
            boolean deleted = files[i].delete();
            if (deleted) continue;
            throw new IllegalStateException("Couldn't delete file: " + files[i].getAbsolutePath());
        }
        return files.length;
    }

    private int signJars(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(fileFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("signJars in " + directory + " found " + jarFiles.length + " jar(s) to sign"));
        }
        if (jarFiles.length == 0) {
            return 0;
        }
        for (int i = 0; i < jarFiles.length; ++i) {
            String unprocessedJarFileName = jarFiles[i].getName();
            if (!unprocessedJarFileName.startsWith(UNPROCESSED_PREFIX)) {
                throw new IllegalStateException("We are about to sign an non unprocessed_ file with path: " + jarFiles[i].getAbsolutePath());
            }
            File signedJar = new File(jarFiles[i].getParent(), unprocessedJarFileName.substring(UNPROCESSED_PREFIX.length()));
            if (signedJar.exists() && !signedJar.delete()) {
                throw new IllegalStateException("Couldn't delete obsolete signed jar: " + signedJar.getAbsolutePath());
            }
            this.signTool.sign(this.getSign(), jarFiles[i], signedJar);
            this.getLog().debug((CharSequence)("lastModified signedJar:" + signedJar.lastModified() + " unprocessed signed Jar:" + jarFiles[i].lastModified()));
            if (jarFiles[i].delete()) continue;
            throw new IllegalStateException("Couldn't delete obsolete unprocessed jar: " + jarFiles[i].getAbsolutePath());
        }
        return jarFiles.length;
    }

    private int removeExistingSignatures(File workDirectory, FileFilter updatedJarFileFilter) throws MojoExecutionException {
        this.verboseLog("Start removing existing signatures");
        File tempDir = new File(workDirectory, "temp_extracted_jars");
        this.removeDirectory(tempDir);
        if (!tempDir.mkdirs()) {
            throw new MojoExecutionException("Error creating temporary directory: " + tempDir);
        }
        File[] jarFiles = workDirectory.listFiles(updatedJarFileFilter);
        boolean canUnsign = this.isCanUnsign();
        for (int i = 0; i < jarFiles.length; ++i) {
            if (this.isJarSigned(jarFiles[i])) {
                if (!canUnsign) {
                    throw new MojoExecutionException("neverUnsignAlreadySignedJar is set to true and a jar file [" + jarFiles[i] + " was asked to be unsign,\n please prefer use in this case an extension for " + "signed jars or not set to true the neverUnsignAlreadySignedJar parameter, Make " + "your choice:)");
                }
                this.verboseLog("remove signature from : " + jarFiles[i]);
                this.unsignJarFile(jarFiles[i], tempDir);
                continue;
            }
            this.verboseLog("not signed : " + jarFiles[i]);
        }
        this.removeDirectory(tempDir);
        return jarFiles.length;
    }

    private void unsignJarFile(File jarFile, File tempDir) throws MojoExecutionException {
        this.signTool.unsign(jarFile, tempDir, this.isVerbose());
    }

    private void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            this.getLog().info((CharSequence)("Deleting directory " + dir.getAbsolutePath()));
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not delete directory " + dir, (Exception)e);
            }
        }
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLog().info((CharSequence)msg);
        } else {
            this.getLog().debug((CharSequence)msg);
        }
    }

    private static class UnprocessedPack200FileFilter
    implements FileFilter {
        private UnprocessedPack200FileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && (pathname.getName().endsWith(".jar.pack.gz") || pathname.getName().endsWith(".jar.pack"));
        }
    }
}

