/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Arrays;
import java.util.Locale;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.mojo.versions.reporting.util.ReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class VersionsReportRendererBase
extends AbstractMavenReportRenderer
implements ReportRenderer {
    protected final I18N i18n;
    private final boolean allowSnapshots;
    protected Locale locale;
    protected String bundleName;

    protected VersionsReportRendererBase(Sink sink, I18N i18n, Locale locale, String bundleName, boolean allowSnapshots) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.bundleName = bundleName;
        this.allowSnapshots = allowSnapshots;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    @Override
    public boolean isAllowSnapshots() {
        return this.allowSnapshots;
    }

    public String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figureGraphics("images/icon_warning_sml.gif");
    }

    protected void renderSuccessIcon() {
        this.sink.figureGraphics("images/icon_success_sml.gif");
    }

    protected boolean equals(ArtifactVersion v1, ArtifactVersion v2) {
        return v1 == v2 || v1 != null && v1.equals((Object)v2) || v1 != null && v2 != null && v1.toString().equals(v2.toString());
    }

    protected void renderTableHeaderCells(String ... keys) {
        VersionsReportRendererBase versionsReportRendererBase = this;
        Arrays.stream(keys).map(this::getText).forEachOrdered(x$0 -> versionsReportRendererBase.tableHeaderCell((String)x$0));
    }

    protected void renderBoldCell(Object object) {
        this.renderBoldCell(true, object);
    }

    protected void renderCell(Object object) {
        this.renderBoldCell(false, object);
    }

    protected void renderCells(Object ... objects) {
        for (Object object : objects) {
            this.renderBoldCell(false, object);
        }
    }

    protected void renderBoldCell(boolean bold, Object object) {
        this.sink.tableCell();
        this.renderBoldText(bold, object);
        this.sink.tableCell_();
    }

    protected void renderBoldText(boolean bold, Object object) {
        String text;
        if (object != null && !(text = object.toString()).isEmpty()) {
            if (bold) {
                this.sink.bold();
            }
            this.sink.text(text);
            if (bold) {
                this.sink.bold_();
            }
        }
    }
}

