/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;

public class SystemCommand {
    private File basedir;
    private String command;
    private List arguments = new ArrayList();
    private List environment;
    private boolean debug;
    private InputStreamHandler stderrHandler;
    private InputStreamHandler stdoutHandler;

    public SystemCommand setCommand(String command) {
        this.command = command;
        return this;
    }

    public SystemCommand setBasedir(File basedir) {
        this.basedir = basedir;
        return this;
    }

    public SystemCommand addArgument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    public SystemCommand addArgumentIf(boolean b, String argument) {
        if (!b) {
            return this;
        }
        this.arguments.add(argument);
        return this;
    }

    public SystemCommand addArgumentIfNotEmpty(String argument) {
        if (argument == null || argument.trim().length() == 0) {
            return this;
        }
        this.arguments.add(argument);
        return this;
    }

    public SystemCommand addEnviroment(String variable) {
        if (this.environment == null) {
            this.environment = new ArrayList();
        }
        this.environment.add(variable);
        return this;
    }

    public SystemCommand dumpCommandIf(boolean debug) {
        this.debug = debug;
        return this;
    }

    public SystemCommand dumpOutputIf(boolean dump) {
        if (!dump) {
            return this;
        }
        return this.withStderrConsumer(System.err).withStdoutConsumer(System.out);
    }

    public SystemCommand withStderrConsumer(OutputStream consumer) {
        if (this.stderrHandler != null) {
            throw new RuntimeException("There can only be one consumer.");
        }
        this.stderrHandler = new OutputStreamInputStreamHandler(consumer);
        return this;
    }

    public SystemCommand withStderrConsumer(LineConsumer lineConsumer) {
        if (this.stderrHandler != null) {
            throw new RuntimeException("There can only be one consumer.");
        }
        this.stderrHandler = new LineConsumerInputStreamHandler(lineConsumer);
        return this;
    }

    public SystemCommand withStdoutConsumer(OutputStream consumer) {
        if (this.stdoutHandler != null) {
            throw new RuntimeException("There can only be one consumer.");
        }
        this.stdoutHandler = new OutputStreamInputStreamHandler(consumer);
        return this;
    }

    public SystemCommand withStdoutConsumer(LineConsumer consumer) {
        if (this.stdoutHandler != null) {
            throw new RuntimeException("There can only be one consumer.");
        }
        this.stdoutHandler = new LineConsumerInputStreamHandler(consumer);
        return this;
    }

    public ExecutionResult execute() throws IOException {
        if (this.basedir == null) {
            this.basedir = new File("/").getAbsoluteFile();
        }
        if (this.command == null) {
            throw new IOException("Missing field 'command'");
        }
        if (this.debug) {
            System.err.println("Executing '" + this.command + "' with arguments (one argument per line):");
            Iterator it = this.arguments.iterator();
            while (it.hasNext()) {
                System.err.println(it.next().toString());
            }
            System.err.println("Executing command in directory: " + this.basedir);
        }
        if (!this.basedir.isDirectory()) {
            throw new IOException("The basedir must be a directory: '" + this.basedir + "'.");
        }
        this.arguments.add(0, this.command);
        return new Execution(this.command, this.arguments, this.environment, this.basedir, this.stderrHandler, this.stdoutHandler).run();
    }

    public static boolean available(String command) {
        try {
            ToStringLineConsumer stdout = new ToStringLineConsumer();
            new SystemCommand().setCommand("which").addArgument(command).withStdoutConsumer(stdout).execute().assertSuccess();
            return new File(stdout.toString()).canRead();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static class Pumper
    extends Thread {
        private InputStream inputStream;
        private InputStreamHandler handler;

        public Pumper(String threadName, InputStream inputStream, InputStreamHandler handler) {
            super(threadName);
            this.inputStream = inputStream;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.handler.handle(this.inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtil.close((InputStream)this.inputStream);
            }
        }
    }

    private static class LineConsumerInputStreamHandler
    implements InputStreamHandler {
        private LineConsumer lineConsumer;

        public LineConsumerInputStreamHandler(LineConsumer lineConsumer) {
            this.lineConsumer = lineConsumer;
        }

        public void handle(InputStream inputStream) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                this.lineConsumer.onLine(line);
                line = reader.readLine();
            }
        }
    }

    private static class OutputStreamInputStreamHandler
    implements InputStreamHandler {
        private OutputStream outputStream;

        private OutputStreamInputStreamHandler(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void handle(InputStream inputStream) throws IOException {
            IOUtil.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            this.outputStream.flush();
        }
    }

    private static interface InputStreamHandler {
        public void handle(InputStream var1) throws IOException;
    }

    private static class Execution {
        private final String command;
        private final List arguments;
        private final List environment;
        private final File basedir;
        private InputStreamHandler stderrHandler;
        private InputStreamHandler stdoutHandler;
        public Pumper stderrPumper;
        public Pumper stdoutPumper;
        public Process process;

        private Execution(String command, List arguments, List environment, File basedir, InputStreamHandler stderrHandler, InputStreamHandler stdoutHandler) {
            this.command = command;
            this.arguments = arguments;
            this.environment = environment;
            this.basedir = basedir;
            this.stderrHandler = stderrHandler;
            this.stdoutHandler = stdoutHandler;
        }

        public ExecutionResult run() throws IOException {
            String[] args = this.arguments.toArray(new String[this.arguments.size()]);
            String[] env = null;
            if (this.environment != null) {
                env = this.environment.toArray(new String[this.environment.size()]);
            }
            this.process = Runtime.getRuntime().exec(args, env, this.basedir);
            this.process.getOutputStream().close();
            this.setUpStdErrConsumer();
            this.setUpStdOutConsumer();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                IOException ex = new IOException("Interrupted while waiting for process");
                ex.initCause(e);
                throw ex;
            }
            if (this.stderrPumper != null) {
                try {
                    this.stderrPumper.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.stdoutPumper != null) {
                try {
                    this.stdoutPumper.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return new ExecutionResult(this.process.exitValue(), this.command);
        }

        private void setUpStdErrConsumer() throws IOException {
            if (this.stderrHandler == null) {
                return;
            }
            this.stderrPumper = new Pumper(this.command + ": stderr-pumper", this.process.getErrorStream(), this.stderrHandler);
            this.stderrPumper.start();
        }

        private void setUpStdOutConsumer() throws IOException {
            if (this.stdoutHandler == null) {
                return;
            }
            this.stdoutPumper = new Pumper(this.command + ": stdout-pumper", this.process.getInputStream(), this.stdoutHandler);
            this.stdoutPumper.start();
        }
    }

    public static class ExecutionResult {
        public final int exitCode;
        private final String command;

        ExecutionResult(int exitCode, String command) {
            this.exitCode = exitCode;
            this.command = command;
        }

        public ExecutionResult assertSuccess() throws IOException {
            if (this.exitCode != 0) {
                throw new IOException("Command '" + this.command + "' returned a non-null exit code: " + this.exitCode);
            }
            return this;
        }

        public ExecutionResult assertSuccess(String exceptionMessage) throws IOException {
            if (this.exitCode != 0) {
                throw new IOException(exceptionMessage);
            }
            return this;
        }
    }

    public static class ToStringLineConsumer
    implements LineConsumer {
        private StringBuffer buffer;

        public ToStringLineConsumer() {
            this(1024);
        }

        public ToStringLineConsumer(int size) {
            this.buffer = new StringBuffer(size);
        }

        public void onLine(String line) throws IOException {
            this.buffer.append(line);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    public static interface LineConsumer {
        public void onLine(String var1) throws IOException;
    }
}

