/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.utils.MojoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseMap
extends TreeMap<String, SortedSet<MavenProject>> {
    private static final long serialVersionUID = 864199843545688069L;
    public static final String UNKNOWN_LICENSE_MESSAGE = "Unknown license";
    private final Comparator<MavenProject> projectComparator = MojoHelper.newMavenProjectComparator();

    @Override
    public SortedSet<MavenProject> put(String key, MavenProject value) {
        TreeSet<MavenProject> valueList = (TreeSet<MavenProject>)this.get(key);
        if (valueList == null) {
            valueList = new TreeSet<MavenProject>(this.projectComparator);
        }
        valueList.add(value);
        return this.put(key, valueList);
    }

    public SortedMap<MavenProject, String[]> toDependencyMap() {
        TreeMap<MavenProject, HashSet<String>> tmp = new TreeMap<MavenProject, HashSet<String>>(this.projectComparator);
        for (Map.Entry entry : this.entrySet()) {
            String license = (String)entry.getKey();
            SortedSet set = (SortedSet)entry.getValue();
            for (MavenProject p : set) {
                HashSet<String> list = (HashSet<String>)tmp.get(p);
                if (list == null) {
                    list = new HashSet<String>();
                    tmp.put(p, list);
                }
                list.add(license);
            }
        }
        TreeMap<MavenProject, String[]> result = new TreeMap<MavenProject, String[]>(this.projectComparator);
        for (Map.Entry entry : tmp.entrySet()) {
            ArrayList value = new ArrayList((Collection)entry.getValue());
            Collections.sort(value);
            result.put((MavenProject)entry.getKey(), value.toArray(new String[value.size()]));
        }
        tmp.clear();
        return result;
    }

    public LicenseMap toLicenseMapOrderByName() {
        LicenseMap result = new LicenseMap();
        Comparator<MavenProject> mavenProjectComparator = MojoHelper.newMavenProjectComparatorByName();
        for (Map.Entry entry : this.entrySet()) {
            String licenseKey = (String)entry.getKey();
            TreeSet<MavenProject> projects = new TreeSet<MavenProject>(mavenProjectComparator);
            projects.addAll((Collection)entry.getValue());
            result.put(licenseKey, projects);
        }
        return result;
    }
}

