/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderTransformer.class, hint="xml")
public class XmlFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    public XmlFileHeaderTransformer() {
        super("xml", "header transformer with xml comment style", "<!--", "  -->", "  ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"pom", "xml", "xhtml", "mxlm", "dtd", "fml", "xsl", "html", "htm", "jaxx", "kml", "gsp", "tml"};
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("<?xml");
        if (startProlog > -1 && (endProlog = content.indexOf("?>", startProlog)) > -1) {
            prolog = content.substring(0, endProlog + 2);
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + '\n' + header, content);
        }
        return result;
    }
}

