/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.MavenProjectDependenciesLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactHelper {
    protected static Comparator<MavenProject> projectComparator;
    public static final String INVALIDE_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";

    public static SortedMap<String, MavenProject> loadProjectDependencies(MavenProjectDependenciesLoader mojo, Log log, SortedMap<String, MavenProject> cache) {
        boolean haveNoIncludedGroups = StringUtils.isEmpty((String)mojo.getIncludedGroups());
        boolean haveNoIncludedArtifacts = StringUtils.isEmpty((String)mojo.getIncludedArtifacts());
        boolean haveExcludedGroups = StringUtils.isNotEmpty((String)mojo.getExcludedGroups());
        boolean haveExcludedArtifacts = StringUtils.isNotEmpty((String)mojo.getExcludedArtifacts());
        boolean haveExclusions = haveExcludedGroups || haveExcludedArtifacts;
        Pattern includedGroupPattern = null;
        Pattern includedArtifactPattern = null;
        Pattern excludedGroupPattern = null;
        Pattern excludedArtifactPattern = null;
        if (!haveNoIncludedGroups) {
            includedGroupPattern = Pattern.compile(mojo.getIncludedGroups());
        }
        if (!haveNoIncludedArtifacts) {
            includedArtifactPattern = Pattern.compile(mojo.getIncludedArtifacts());
        }
        if (haveExcludedGroups) {
            excludedGroupPattern = Pattern.compile(mojo.getExcludedGroups());
        }
        if (haveExcludedArtifacts) {
            excludedArtifactPattern = Pattern.compile(mojo.getExcludedArtifacts());
        }
        MavenProject project = mojo.getProject();
        Set depArtifacts = mojo.isIncludeTransitiveDependencies() ? project.getArtifacts() : project.getDependencyArtifacts();
        ArtifactRepository localRepository = mojo.getLocalRepository();
        List remoteRepositories = mojo.getRemoteRepositories();
        MavenProjectBuilder projectBuilder = mojo.getMavenProjectBuilder();
        List<String> excludeScopes = mojo.getExcludeScopes();
        boolean verbose = mojo.isVerbose();
        TreeMap<String, MavenProject> result = new TreeMap<String, MavenProject>();
        for (Object o : depArtifacts) {
            boolean isToExclude;
            Artifact artifact = (Artifact)o;
            if (excludeScopes.contains(artifact.getScope())) continue;
            String id = ArtifactHelper.getArtifactId(artifact);
            if (verbose) {
                log.info((CharSequence)("detected artifact " + id));
            }
            boolean isToInclude = haveNoIncludedArtifacts && haveNoIncludedGroups || ArtifactHelper.isIncludable(log, artifact, includedGroupPattern, includedArtifactPattern);
            boolean bl = isToExclude = isToInclude && haveExclusions && ArtifactHelper.isExcludable(log, artifact, excludedGroupPattern, excludedArtifactPattern);
            if (!isToInclude || isToExclude) {
                if (!verbose) continue;
                log.info((CharSequence)("skip artifact " + id));
                continue;
            }
            MavenProject depMavenProject = null;
            if (cache != null) {
                depMavenProject = (MavenProject)cache.get(id);
            }
            if (depMavenProject != null) {
                if (verbose) {
                    log.info((CharSequence)("add dependency [" + id + "] (from cache)"));
                }
            } else {
                try {
                    depMavenProject = projectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, true);
                }
                catch (ProjectBuildingException e) {
                    log.warn((CharSequence)("Unable to obtain POM for artifact : " + artifact));
                    log.warn((Throwable)e);
                    continue;
                }
                if (verbose) {
                    log.info((CharSequence)("add dependency [" + id + "]"));
                }
                if (cache != null) {
                    cache.put(id, depMavenProject);
                }
            }
            result.put(id, depMavenProject);
        }
        return result;
    }

    public static String getArtifactId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append("--");
        sb.append(artifact.getArtifactId());
        sb.append("--");
        sb.append(artifact.getVersion());
        String type = artifact.getType();
        if (!StringUtils.isEmpty((String)type) && !"pom".equals(type)) {
            sb.append("--");
            sb.append(artifact.getType());
        }
        if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
            sb.append("--");
            sb.append(artifact.getClassifier());
        }
        return sb.toString();
    }

    public static String getArtifactName(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        if (project.getName().startsWith("Unnamed -")) {
            sb.append(project.getArtifactId());
        } else {
            sb.append(project.getName());
        }
        sb.append(" (");
        sb.append(project.getGroupId());
        sb.append(":");
        sb.append(project.getArtifactId());
        sb.append(":");
        sb.append(project.getVersion());
        sb.append(" - ");
        String url = project.getUrl();
        sb.append(url == null ? "no url defined" : url);
        sb.append(")");
        return sb.toString();
    }

    public static Comparator<MavenProject> getProjectComparator() {
        if (projectComparator == null) {
            projectComparator = new Comparator<MavenProject>(){

                @Override
                public int compare(MavenProject o1, MavenProject o2) {
                    String id1 = ArtifactHelper.getArtifactId(o1.getArtifact());
                    String id2 = ArtifactHelper.getArtifactId(o2.getArtifact());
                    return id1.compareTo(id2);
                }
            };
        }
        return projectComparator;
    }

    protected static boolean isIncludable(Log log, Artifact project, Pattern includedGroupPattern, Pattern includedArtifactPattern) {
        Matcher matchGroupId;
        if (includedGroupPattern != null) {
            try {
                matchGroupId = includedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Include " + project.getGroupId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn((CharSequence)String.format(INVALIDE_PATTERN_MESSAGE, includedGroupPattern.pattern()));
            }
        }
        if (includedArtifactPattern != null) {
            try {
                matchGroupId = includedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Include " + project.getArtifactId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn((CharSequence)String.format(INVALIDE_PATTERN_MESSAGE, includedArtifactPattern.pattern()));
            }
        }
        return false;
    }

    protected static boolean isExcludable(Log log, Artifact project, Pattern excludedGroupPattern, Pattern excludedArtifactPattern) {
        Matcher matchGroupId;
        if (excludedGroupPattern != null) {
            try {
                matchGroupId = excludedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Exclude " + project.getGroupId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn((CharSequence)String.format(INVALIDE_PATTERN_MESSAGE, excludedGroupPattern.pattern()));
            }
        }
        if (excludedArtifactPattern != null) {
            try {
                matchGroupId = excludedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Exclude " + project.getArtifactId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn((CharSequence)String.format(INVALIDE_PATTERN_MESSAGE, excludedArtifactPattern.pattern()));
            }
        }
        return false;
    }
}

