/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jdepend;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import jdepend.xmlui.JDepend;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.jdepend.JDependXMLReportParser;
import org.codehaus.mojo.jdepend.ReportGenerator;

public class JDependMojo
extends AbstractMavenReport {
    private MavenProject project;
    private String outputDirectory;
    private String projectDirectory;
    private String classDirectory;
    private String argument;
    private String reportFile;
    private SiteRenderer siteRenderer;
    JDependXMLReportParser xmlParser;

    public void executeReport(Locale locale) throws MavenReportException {
        try {
            boolean success;
            File outputDirFile = new File(this.outputDirectory);
            if (!outputDirFile.exists() && !(success = outputDirFile.mkdirs())) {
                throw new MavenReportException("Could not create directory " + this.outputDirectory);
            }
            JDepend.main((String[])this.getArgumentList(this.getArgument(), this.getReportFile(), this.getClassDirectory()));
            this.xmlParser = new JDependXMLReportParser(new File(this.getReportFile()));
            this.generateReport(locale);
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to execute JDepend", e);
        }
    }

    public boolean canGenerateReport() {
        File srcDir = new File(this.classDirectory);
        return srcDir.exists();
    }

    private String[] getArgumentList(String argument, String reportFile, String classDir) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(argument);
        argList.add(reportFile);
        argList.add(classDir);
        return argList.toArray(new String[argList.size()]);
    }

    public void generateReport(Locale locale) throws MavenReportException {
        ReportGenerator report = new ReportGenerator();
        try {
            Sink sink = this.getSink();
            report.doGenerateReport(this.getBundle(locale), sink, this.xmlParser);
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to generate JDepend report", e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jdepend.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jdepend.name");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org.codehaus.mojo.jdepend.jdepend-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getOutputName() {
        return "jdepend-report";
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void setSiteRenderer(SiteRenderer siteRenderer) {
        this.siteRenderer = siteRenderer;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(String projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public String getClassDirectory() {
        return this.classDirectory;
    }

    public void setClassDirectory(String classDirectory) {
        this.classDirectory = classDirectory;
    }
}

