/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.OutputStream;
import org.codehaus.mojo.exec.Invokable;

class LineRedirectOutputStream
extends OutputStream {
    private StringBuilder currentLine = new StringBuilder();
    private final Invokable<String> linePrinter;

    public LineRedirectOutputStream(Invokable<String> linePrinter) {
        this.linePrinter = linePrinter;
    }

    @Override
    public void write(int b) {
        if ((char)b == '\n') {
            this.printAndReset();
            return;
        }
        this.currentLine.append((char)b);
    }

    @Override
    public void flush() {
        if (this.currentLine.length() > 0) {
            this.printAndReset();
        }
    }

    private void printAndReset() {
        this.linePrinter.accept(this.currentLine.toString());
        this.currentLine = new StringBuilder();
    }
}

