/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:exec-maven-plugin:1.1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Exec Maven Plugin 1.1.1", 0);
        this.append(sb, "A plugin to allow execution of system and Java programs", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "exec".equals(this.goal)) {
            this.append(sb, "exec:exec", 0);
            this.append(sb, "A Plugin for executing external programs.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Can be of type <argument> or <classpath> Can be overriden using 'exec.args' env. variable", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathScope (Default: compile)", 2);
                this.append(sb, "Defines the scope of the classpath passed to the plugin. Set to compile,test,runtime or system depending on your needs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commandlineArgs", 2);
                this.append(sb, "Arguments for the executed program", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentVariables", 2);
                this.append(sb, "Environment variables to pass to the executed program.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable", 2);
                this.append(sb, "The executable. Can be a full path or a the name executable. In the latter case, the executable must be in the PATH for the execution to work.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "Program standard and error output will be redirected to the file specified by this optional field. If not specified the standard maven logging is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceRoot", 2);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled. Use this if your plugin generates source code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "successCodes", 2);
                this.append(sb, "Exit codes to be resolved as successful execution for non-compliant applications (applications not returning 0 for success).", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceRoot", 2);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled for testing. Use this if your plugin generates test source code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The current working directory. Optional. If not specified, basedir will be used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "exec:help", 0);
            this.append(sb, "Display help information on exec-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0exec:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "java".equals(this.goal)) {
            this.append(sb, "exec:java", 0);
            this.append(sb, "Executes the supplied java class in the current VM with the enclosing project's dependencies as classpath.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "The class arguments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathScope (Default: compile)", 2);
                this.append(sb, "Defines the scope of the classpath passed to the plugin. Set to compile,test,runtime or system depending on your needs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanupDaemonThreads", 2);
                this.append(sb, "Wether to interrupt/join and possibly stop the daemon threads upon quitting.\nIf this is false, maven does nothing about the daemon threads. When maven has no more work to do, the VM will normally terminate any remaining daemon threads.\nIn certain cases (in particular if maven is embedded), you might need to keep this enabled to make sure threads are properly cleaned up to ensure they don't interfere with subsequent activity. In that case, see daemonThreadJoinTimeout and stopUnresponsiveDaemonThreads for further tuning.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "commandlineArgs", 2);
                this.append(sb, "Arguments for the executed program", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemonThreadJoinTimeout (Default: 15000)", 2);
                this.append(sb, "This defines the number of milliseconds to wait for daemon threads to quit following their interruption.\nThis is only taken into account if cleanupDaemonThreads is true. A value <=0 means to not timeout (i.e. wait indefinitely for threads to finish). Following a timeout, a warning will be logged.\nNote: properly coded threads should terminate upon interruption but some threads may prove problematic: as the VM does interrupt daemon threads, some code may not have been written to handle interruption properly. For example java.util.Timer is known to not handle interruptions in JDK <= 1.6. So it is not possible for us to infinitely wait by default otherwise maven could hang. A sensible default value has been chosen, but this default value may change in the future based on user feedback.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "executableDependency", 2);
                this.append(sb, "If provided the ExecutableDependency identifies which of the plugin dependencies contains the executable class. This will have the affect of only including plugin dependencies required by the identified ExecutableDependency.\nIf includeProjectDependencies is set to true, all of the project dependencies will be included on the executable's classpath. Whether a particular project dependency is a dependency of the identified ExecutableDependency will be irrelevant to its inclusion in the classpath.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includePluginDependencies (Default: false)", 2);
                this.append(sb, "Indicates if this plugin's dependencies should be used when executing the main class.\nThis is useful when project dependencies are not appropriate. Using only the plugin dependencies can be particularly useful when the project is not a java project. For example a mvn project using the csharp plugins only expects to see dotnet libraries as dependencies.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeProjectDependencies (Default: true)", 2);
                this.append(sb, "Indicates if the project dependencies should be used when executing the main class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepAlive (Default: false)", 2);
                this.append(sb, "Indicates if mojo should be kept running after the mainclass terminates. Usefull for serverlike apps with deamonthreads.", 3);
                this.append(sb, "", 0);
                this.append(sb, "killAfter (Default: -1)", 2);
                this.append(sb, "Deprecated this is not needed anymore.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainClass", 2);
                this.append(sb, "The main class to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceRoot", 2);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled. Use this if your plugin generates source code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopUnresponsiveDaemonThreads", 2);
                this.append(sb, "Wether to call Thread.stop() following a timing out of waiting for an interrupted thread to finish. This is only taken into account if cleanupDaemonThreads is true and the daemonThreadJoinTimeout threshold has been reached for an uncooperative thread. If this is false, or if Thread.stop() fails to get the thread to stop, then a warning is logged and Maven will continue on while the affected threads (and related objects in memory) linger on. Consider setting this to true if you are invoking problematic code that you can't fix. An example is Timer which doesn't respond to interruption. To have Timer fixed, vote for this bug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "A list of system properties to be passed. Note: as the execution is not forked, some system properties required by the JVM cannot be passed here. Use MAVEN_OPTS or the exec:exec instead. See the user guide for more information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceRoot", 2);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled for testing. Use this if your plugin generates test source code.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

