/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

class CoverageResult {
    public static final int UNKNOWN_RATE = -1;
    private int blockRate = -1;
    private int classRate = -1;
    private int lineRate = -1;
    private int methodRate = -1;
    private final String name;
    private final Type type;

    public CoverageResult() {
        this.type = Type.ALL;
        this.name = "(all classes)";
    }

    public CoverageResult(Type type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type is required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is required");
        }
        this.type = type;
        this.name = name;
    }

    public int getBlockRate() {
        return this.blockRate;
    }

    public int getClassRate() {
        return this.classRate;
    }

    public int getLineRate() {
        return this.lineRate;
    }

    public int getMethodRate() {
        return this.methodRate;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setBlockRate(int blockRate) {
        this.blockRate = blockRate;
    }

    public void setClassRate(int classRate) {
        this.classRate = classRate;
    }

    public void setLineRate(int lineRate) {
        this.lineRate = lineRate;
    }

    public void setMethodRate(int methodRate) {
        this.methodRate = methodRate;
    }

    public String toString() {
        return this.type + " " + this.name + "[classRate=" + this.classRate + ", methodRate=" + this.methodRate + ", blockRate=" + this.blockRate + ", lineRate=" + this.lineRate + "]";
    }

    public static class Type {
        public static final Type ALL = new Type(0);
        public static final Type CLASS = new Type(2);
        public static final Type METHOD = new Type(3);
        public static final Type PACKAGE = new Type(1);
        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Type)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return this.id == ((Type)obj).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "all";
                }
                case 1: {
                    return "package";
                }
                case 2: {
                    return "class";
                }
                case 3: {
                    return "method";
                }
            }
            return "(unknown type)";
        }
    }
}

