/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.apt.AptUtils;
import org.codehaus.mojo.apt.LogUtils;
import org.codehaus.mojo.apt.MavenProjectUtils;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAptMojo
extends AbstractMojo {
    private MavenProject project;
    private List pluginArtifacts;
    private File workingDirectory;
    private boolean fork;
    private String executable;
    private String meminitial;
    private String maxmem;
    private boolean showWarnings;
    private String encoding;
    private boolean verbose;
    private String[] options;
    private String factory;
    private List additionalSourceRoots;
    private String resourceTargetPath;
    private boolean resourceFiltering;
    private boolean force;
    private Set outputFiles;
    private Set outputFileEndings;
    private int staleMillis;
    private boolean skip;
    private Set includes;
    private Set excludes;

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping apt");
        } else {
            this.executeImpl();
        }
    }

    protected void executeImpl() throws MojoExecutionException {
        this.includes = AbstractAptMojo.defaultSet(this.getIncludes(), Collections.singleton("**/*.java"));
        this.excludes = AbstractAptMojo.defaultSet(this.getExcludes());
        List staleSourceFiles = this.getSourceFiles(this.getStaleScanner(), "stale sources");
        if (staleSourceFiles.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all processor-generated files are up to date");
        } else {
            this.executeApt();
        }
        this.getCompileSourceRoots().add(this.getOutputDirectory().getPath());
        Resource resource = new Resource();
        resource.setDirectory(this.getOutputDirectory().getPath());
        resource.addExclude("**/*.java");
        resource.setFiltering(this.resourceFiltering);
        if (this.resourceTargetPath != null) {
            resource.setTargetPath(this.resourceTargetPath);
        }
        this.getResources().add(resource);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String[] getOptions() {
        return this.options;
    }

    protected abstract List getCompileSourceRoots();

    protected abstract List getResources();

    protected abstract List getClasspathElements();

    protected abstract Set getIncludes();

    protected abstract Set getExcludes();

    protected abstract File getOutputDirectory();

    private void executeApt() throws MojoExecutionException {
        List sourceFiles = this.getSourceFiles(this.getSourceScanner(), "sources");
        if (this.getLog().isInfoEnabled()) {
            int count = sourceFiles.size();
            this.getLog().info((CharSequence)("Processing " + count + " source file" + (count == 1 ? "" : "s") + " to " + this.getOutputDirectory().getAbsolutePath()));
        }
        List args = this.createArgs(sourceFiles);
        boolean success = this.fork ? AptUtils.invokeForked(this.getLog(), this.workingDirectory, this.executable, this.meminitial, this.maxmem, args) : AptUtils.invoke(this.getLog(), args);
        if (!success) {
            throw new MojoExecutionException("Apt failed");
        }
    }

    private List createArgs(List sourceFiles) throws MojoExecutionException {
        List sourcePaths;
        ArrayList<String> args = new ArrayList<String>();
        LinkedHashSet classpathElements = new LinkedHashSet();
        classpathElements.addAll(this.getPluginClasspathElements());
        classpathElements.addAll(this.getClasspathElements());
        if (!classpathElements.isEmpty()) {
            args.add("-classpath");
            args.add(AbstractAptMojo.toPath(classpathElements));
        }
        if (!(sourcePaths = this.getSourcePaths()).isEmpty()) {
            args.add("-sourcepath");
            args.add(AbstractAptMojo.toPath(sourcePaths));
        }
        if (!this.showWarnings) {
            args.add("-nowarn");
        }
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        args.add("-s");
        args.add(this.getOutputDirectory().getAbsolutePath());
        args.add("-nocompile");
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                args.add("-A" + this.options[i].trim());
            }
        }
        if (StringUtils.isNotEmpty((String)this.factory)) {
            args.add("-factory");
            args.add(this.factory);
        }
        Iterator iterator = sourceFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            args.add(file.getAbsolutePath());
        }
        return args;
    }

    private static String toPath(Collection paths) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            buffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(File.pathSeparator);
        }
        return buffer.toString();
    }

    private List getPluginClasspathElements() throws MojoExecutionException {
        try {
            return MavenProjectUtils.getClasspathElements(this.project, this.pluginArtifacts);
        }
        catch (DependencyResolutionRequiredException exception) {
            throw new MojoExecutionException("Cannot get plugin classpath elements", (Exception)((Object)exception));
        }
    }

    private List getSourcePaths() {
        ArrayList sourcePaths = new ArrayList();
        sourcePaths.addAll(this.getCompileSourceRoots());
        if (this.additionalSourceRoots != null) {
            sourcePaths.addAll(this.additionalSourceRoots);
        }
        return sourcePaths;
    }

    private List getSourceFiles(SourceInclusionScanner scanner, String name) throws MojoExecutionException {
        ArrayList sourceFiles = new ArrayList();
        Iterator iterator = this.getSourcePaths().iterator();
        while (iterator.hasNext()) {
            File sourceDir = new File((String)iterator.next());
            sourceFiles.addAll(this.getSourceFiles(scanner, name, sourceDir));
        }
        return sourceFiles;
    }

    private Set getSourceFiles(SourceInclusionScanner scanner, String name, File sourceDir) throws MojoExecutionException {
        Set sources;
        if (sourceDir.isDirectory()) {
            try {
                sources = scanner.getIncludedSources(sourceDir, this.getOutputDirectory());
            }
            catch (InclusionScanException exception) {
                throw new MojoExecutionException("Error scanning source directory: " + sourceDir, (Exception)((Object)exception));
            }
        } else {
            sources = Collections.EMPTY_SET;
        }
        if (this.getLog().isDebugEnabled()) {
            if (sources.isEmpty()) {
                this.getLog().debug((CharSequence)("No " + name + " found in " + sourceDir));
            } else {
                this.getLog().debug((CharSequence)(StringUtils.capitalizeFirstLetter((String)name) + " found in " + sourceDir + ":"));
                LogUtils.log(this.getLog(), 0, sources, (CharSequence)"  ");
            }
        }
        return sources;
    }

    private SourceInclusionScanner getStaleScanner() {
        StaleSourceScanner scanner;
        if (this.force) {
            if (!AbstractAptMojo.isEmpty(this.outputFiles) || !AbstractAptMojo.isEmpty(this.outputFileEndings)) {
                this.getLog().warn((CharSequence)"Not using staleness checking - ignoring outputFiles and outputFileEndings");
            }
            this.getLog().debug((CharSequence)"Processing all source files");
            scanner = this.createSimpleScanner();
        } else {
            scanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
            if (!AbstractAptMojo.isEmpty(this.outputFiles)) {
                if (!AbstractAptMojo.isEmpty(this.outputFileEndings)) {
                    this.getLog().warn((CharSequence)"Both outputFiles and outputFileEndings specified - using outputFiles");
                }
                this.getLog().debug((CharSequence)("Computing stale sources against target files " + this.outputFiles));
                Iterator iterator = this.outputFiles.iterator();
                while (iterator.hasNext()) {
                    String file = (String)iterator.next();
                    scanner.addSourceMapping((SourceMapping)new SingleTargetSourceMapping(".java", file));
                }
            } else {
                Set suffixes = AbstractAptMojo.defaultSet(this.outputFileEndings, Collections.singleton(".java"));
                this.getLog().debug((CharSequence)("Computing stale sources against target file endings " + suffixes));
                scanner.addSourceMapping((SourceMapping)new SuffixMapping(".java", suffixes));
            }
        }
        return scanner;
    }

    private SourceInclusionScanner getSourceScanner() {
        SourceInclusionScanner scanner = this.force || AbstractAptMojo.isEmpty(this.outputFiles) ? this.getStaleScanner() : this.createSimpleScanner();
        return scanner;
    }

    private SourceInclusionScanner createSimpleScanner() {
        SimpleSourceInclusionScanner scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("", ""));
        return scanner;
    }

    private static Set defaultSet(Set set) {
        return AbstractAptMojo.defaultSet(set, Collections.EMPTY_SET);
    }

    private static Set defaultSet(Set set, Set defaultSet) {
        return AbstractAptMojo.isEmpty(set) ? defaultSet : set;
    }

    private static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

