/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import org.apache.fop.fonts.Font;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFTextUtil {
    private static final int DEC = 8;
    public static final int TR_FILL = 0;
    public static final int TR_STROKE = 1;
    public static final int TR_FILL_STROKE = 2;
    public static final int TR_INVISIBLE = 3;
    public static final int TR_FILL_CLIP = 4;
    public static final int TR_STROKE_CLIP = 5;
    public static final int TR_FILL_STROKE_CLIP = 6;
    public static final int TR_CLIP = 7;
    private PDFGraphics2D g2d;
    private boolean inTextObject = false;
    private Font[] fonts;
    private Font font;
    private String startText;
    private String endText;
    private boolean useMultiByte;
    private StringBuffer bufTJ;
    private int textRenderingMode = 0;

    public PDFTextUtil(PDFGraphics2D g2d) {
        this.g2d = g2d;
    }

    private void writeAffineTransform(AffineTransform at, StringBuffer sb) {
        double[] lt = new double[6];
        at.getMatrix(lt);
        sb.append(PDFNumber.doubleOut(lt[0], 8)).append(" ");
        sb.append(PDFNumber.doubleOut(lt[1], 8)).append(" ");
        sb.append(PDFNumber.doubleOut(lt[2], 8)).append(" ");
        sb.append(PDFNumber.doubleOut(lt[3], 8)).append(" ");
        sb.append(PDFNumber.doubleOut(lt[4], 8)).append(" ");
        sb.append(PDFNumber.doubleOut(lt[5], 8));
    }

    private void writeChar(char ch, StringBuffer sb) {
        if (!this.useMultiByte) {
            if (ch > '\u007f') {
                sb.append("\\").append(Integer.toOctalString(ch));
            } else {
                switch (ch) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                }
                sb.append(ch);
            }
        } else {
            sb.append(PDFText.toUnicodeHex(ch));
        }
    }

    private void checkInTextObject() {
        if (!this.inTextObject) {
            throw new IllegalStateException("Not in text object");
        }
    }

    public void beginTextObject() {
        if (this.inTextObject) {
            throw new IllegalStateException("Already in text object");
        }
        this.g2d.currentStream.write("BT\n");
        this.inTextObject = true;
    }

    public void endTextObject() {
        this.checkInTextObject();
        this.g2d.currentStream.write("ET\n");
        this.inTextObject = false;
        this.initValues();
    }

    private void initValues() {
        this.font = null;
        this.textRenderingMode = 0;
    }

    public void saveGraphicsState() {
        this.g2d.currentStream.write("q\n");
    }

    public void restoreGraphicsState() {
        this.g2d.currentStream.write("Q\n");
    }

    public void concatMatrixCurrentTransform() {
        StringBuffer sb = new StringBuffer();
        if (!this.g2d.getTransform().isIdentity()) {
            this.writeAffineTransform(this.g2d.getTransform(), sb);
            sb.append(" cm\n");
        }
        this.g2d.currentStream.write(sb.toString());
    }

    public void setFonts(Font[] fonts) {
        this.fonts = fonts;
    }

    public void setFont(Font font) {
        this.setFonts(new Font[]{font});
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public void setCurrentFont(Font f) {
        this.font = f;
    }

    public void writeTf(Font f) {
        this.checkInTextObject();
        String fontName = f.getFontName();
        float fontSize = (float)f.getFontSize() / 1000.0f;
        this.g2d.currentStream.write("/" + fontName + " " + PDFNumber.doubleOut(fontSize) + " Tf\n");
        this.useMultiByte = this.g2d.isMultiByteFont(fontName);
        this.startText = this.useMultiByte ? "<" : "(";
        this.endText = this.useMultiByte ? ">" : ")";
    }

    public void setTextRenderingMode(int mode) {
        if (mode < 0 || mode > 7) {
            throw new IllegalArgumentException("Illegal value for text rendering mode. Expected: 0-7");
        }
        if (mode != this.textRenderingMode) {
            this.textRenderingMode = mode;
            this.g2d.currentStream.write(this.textRenderingMode + " Tr\n");
        }
    }

    public void setTextRenderingMode(boolean fill, boolean stroke, boolean addToClip) {
        int mode;
        if (fill) {
            mode = stroke ? 2 : 0;
        } else {
            int n = mode = stroke ? 1 : 3;
        }
        if (addToClip) {
            mode += 4;
        }
        this.setTextRenderingMode(mode);
    }

    public void writeTextMatrix(AffineTransform localTransform) {
        StringBuffer sb = new StringBuffer();
        this.writeAffineTransform(localTransform, sb);
        sb.append(" Tm\n");
        this.g2d.currentStream.write(sb.toString());
    }

    public Font selectFontForChar(char ch) {
        int c = this.fonts.length;
        for (int i = 0; i < c; ++i) {
            if (!this.fonts[i].hasChar(ch)) continue;
            return this.fonts[i];
        }
        return this.fonts[0];
    }

    public void writeTJChar(char ch) {
        if (this.bufTJ == null) {
            this.bufTJ = new StringBuffer();
        }
        if (this.bufTJ.length() == 0) {
            this.bufTJ.append("[").append(this.startText);
        }
        char mappedChar = this.font.mapChar(ch);
        this.writeChar(mappedChar, this.bufTJ);
    }

    public void adjustGlyphTJ(double adjust) {
        this.bufTJ.append(this.endText).append(" ");
        this.bufTJ.append(PDFNumber.doubleOut(adjust, 4));
        this.bufTJ.append(" ");
        this.bufTJ.append(this.startText);
    }

    public void writeTJ() {
        if (this.bufTJ != null && this.bufTJ.length() > 0) {
            this.bufTJ.append(this.endText).append("] TJ\n");
            this.g2d.currentStream.write(this.bufTJ.toString());
            this.bufTJ.setLength(0);
        }
    }
}

