/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public class AjaxIndicatorAppender
extends Behavior {
    private Component component;
    private static final long serialVersionUID = 1L;

    public void renderHead(Component component, IHeaderResponse response) {
        if (AjaxRequestTarget.get() != null) {
            String javascript = "var e = Wicket.$('" + this.getMarkupId() + "'); if (e != null && typeof(e.parentNode) != 'undefined') e.parentNode.removeChild(e);";
            response.renderOnDomReadyJavaScript(javascript);
        }
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        Response r = component.getResponse();
        r.write((CharSequence)"<span style=\"display:none;\" class=\"");
        r.write((CharSequence)this.getSpanClass());
        r.write((CharSequence)"\" ");
        r.write((CharSequence)"id=\"");
        r.write((CharSequence)this.getMarkupId());
        r.write((CharSequence)"\">");
        r.write((CharSequence)"<img src=\"");
        r.write(this.getIndicatorUrl());
        r.write((CharSequence)"\" alt=\"\"/></span>");
    }

    protected CharSequence getIndicatorUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        return RequestCycle.get().urlFor((IRequestHandler)handler);
    }

    protected String getSpanClass() {
        return "wicket-ajax-indicator";
    }

    public String getMarkupId() {
        return this.component.getMarkupId() + "--ajax-indicator";
    }

    public final void bind(Component component) {
        this.component = component;
    }
}

