/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private String relaxedPathChars = null;
    private String relaxedQueryChars = null;
    private boolean allowHostHeaderMismatch = true;
    private boolean rejectIllegalHeaderName = false;
    private int socketBuffer = 9000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String compressibleMimeTypes = "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript";
    private int compressionMinSize = 2048;
    private String restrictedUserAgents = null;
    private String server;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private int upgradeAsyncWriteBufferSize = 8192;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    public String getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(String relaxedPathChars) {
        this.relaxedPathChars = relaxedPathChars;
    }

    public String getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(String relaxedQueryChars) {
        this.relaxedQueryChars = relaxedQueryChars;
    }

    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    public void setAllowHostHeaderMismatch(boolean allowHostHeaderMismatch) {
        this.allowHostHeaderMismatch = allowHostHeaderMismatch;
    }

    public boolean getRejectIllegalHeaderName() {
        return this.rejectIllegalHeaderName;
    }

    public void setRejectIllegalHeaderName(boolean rejectIllegalHeaderName) {
        this.rejectIllegalHeaderName = rejectIllegalHeaderName;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int i) {
        this.connectionUploadTimeout = i;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    @Deprecated
    public String getCompressableMimeType() {
        return this.getCompressibleMimeType();
    }

    @Deprecated
    public void setCompressableMimeType(String valueS) {
        this.setCompressibleMimeType(valueS);
    }

    @Deprecated
    public String getCompressableMimeTypes() {
        return this.getCompressibleMimeType();
    }

    @Deprecated
    public void setCompressableMimeTypes(String valueS) {
        this.setCompressibleMimeType(valueS);
    }

    public String getCompressibleMimeType() {
        return this.compressibleMimeTypes;
    }

    public void setCompressibleMimeType(String valueS) {
        this.compressibleMimeTypes = valueS;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int maxExtensionSize) {
        this.maxExtensionSize = maxExtensionSize;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int maxSwallowSize) {
        this.maxSwallowSize = maxSwallowSize;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public int getUpgradeAsyncWriteBufferSize() {
        return this.upgradeAsyncWriteBufferSize;
    }

    public void setUpgradeAsyncWriteBufferSize(int upgradeAsyncWriteBufferSize) {
        this.upgradeAsyncWriteBufferSize = upgradeAsyncWriteBufferSize;
    }

    public void setAllowedTrailerHeaders(String commaSeparatedHeaders) {
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.addAll(this.allowedTrailerHeaders);
        if (commaSeparatedHeaders != null) {
            String[] headers;
            for (String header : headers = commaSeparatedHeaders.split(",")) {
                String trimmedHeader = header.trim().toLowerCase(Locale.ENGLISH);
                if (toRemove.contains(trimmedHeader)) {
                    toRemove.remove(trimmedHeader);
                    continue;
                }
                this.allowedTrailerHeaders.add(trimmedHeader);
            }
            this.allowedTrailerHeaders.removeAll(toRemove);
        }
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> copy = new ArrayList<String>(this.allowedTrailerHeaders.size());
        copy.addAll(this.allowedTrailerHeaders);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String header : copy) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(header);
        }
        return result.toString();
    }

    public void addAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.add(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.remove(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    protected Set<String> getAllowedTrailerHeadersAsSet() {
        return this.allowedTrailerHeaders;
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public int getMaxKeepAliveRequests() {
        return this.endpoint.getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.endpoint.setMaxKeepAliveRequests(mkar);
    }

    protected void configureProcessor(AbstractHttp11Processor<S> processor) {
        processor.setAdapter(this.getAdapter());
        processor.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        processor.setKeepAliveTimeout(this.getKeepAliveTimeout());
        processor.setConnectionUploadTimeout(this.getConnectionUploadTimeout());
        processor.setDisableUploadTimeout(this.getDisableUploadTimeout());
        processor.setCompressionMinSize(this.getCompressionMinSize());
        processor.setCompression(this.getCompression());
        processor.setNoCompressionUserAgents(this.getNoCompressionUserAgents());
        processor.setCompressibleMimeTypes(this.getCompressibleMimeType());
        processor.setRestrictedUserAgents(this.getRestrictedUserAgents());
        processor.setSocketBuffer(this.getSocketBuffer());
        processor.setMaxSavePostSize(this.getMaxSavePostSize());
        processor.setServer(this.getServer());
        processor.setMaxCookieCount(this.getMaxCookieCount());
        processor.setAllowHostHeaderMismatch(this.getAllowHostHeaderMismatch());
    }
}

