/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmAccessor;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmLzxcResetTable;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;

public class ChmAssert {
    public static final void assertChmBlockSegment(byte[] data, ChmLzxcResetTable resetTable, int blockNumber, int lzxcBlockOffset, int lzxcBlockLength) throws TikaException {
        if (data == null) {
            throw new TikaException("data[] is null");
        }
        if (data.length <= 0) {
            throw new TikaException("data[] length should be greater than zero");
        }
        if (resetTable == null) {
            throw new TikaException("resetTable is null");
        }
        if (resetTable.getBlockAddress().length <= 1) {
            throw new TikaException("resetTable.getBlockAddress().length should be greater than zero");
        }
        if (blockNumber < 0) {
            throw new TikaException("blockNumber should be positive number");
        }
        if (lzxcBlockOffset < 0) {
            throw new TikaException("lzxcBlockOffset should be positive number");
        }
        if (lzxcBlockLength < 0) {
            throw new TikaException("lzxcBlockLength should be positive number");
        }
    }

    public static final void assertInputStreamNotNull(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("input sream is null");
        }
    }

    public static final void assertChmAccessorParameters(byte[] data, ChmAccessor<?> chmAccessor, int count) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(data);
        ChmAssert.assertChmAccessorNotNull(chmAccessor);
    }

    public static final void assertByteArrayNotNull(byte[] data) throws ChmParsingException {
        if (data == null) {
            throw new ChmParsingException("byte[] data is null");
        }
    }

    public static final void assertChmAccessorNotNull(ChmAccessor<?> chmAccessor) throws ChmParsingException {
        if (chmAccessor == null) {
            throw new ChmParsingException("chm header is null");
        }
    }

    public static final void assertDirectoryListingEntry(int name_length, String name, ChmCommons.EntryType entryType, int offset, int length) throws ChmParsingException {
        if (name_length < 0) {
            throw new ChmParsingException("invalid name length");
        }
        if (name == null) {
            throw new ChmParsingException("invalid name");
        }
        if (entryType != ChmCommons.EntryType.COMPRESSED && entryType != ChmCommons.EntryType.UNCOMPRESSED) {
            throw new ChmParsingException("invalid compressed type, should be EntryType.COMPRESSED | EntryType.UNCOMPRESSED");
        }
        if (offset < 0) {
            throw new ChmParsingException("invalid offset");
        }
        if (length < 0) {
            throw new ChmParsingException("invalid length");
        }
    }

    public static void assertCopyingDataIndex(int index, int dataLength) throws ChmParsingException {
        if (index >= dataLength) {
            throw new ChmParsingException("cannot parse chm file index > data.length");
        }
    }

    public static void assertPositiveInt(int param) throws ChmParsingException {
        if (param <= 0) {
            throw new ChmParsingException("resetTable.getBlockAddress().length should be greater than zero");
        }
    }
}

