/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.batch.BatchStatementExecutor;
import org.apache.shardingsphere.driver.executor.callback.ExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.ExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.impl.StatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.mysql.type.MySQLDatabaseType;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.kernel.syntax.EmptySQLException;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.raw.RawExecutionRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;
import org.apache.shardingsphere.traffic.engine.TrafficEngine;
import org.apache.shardingsphere.traffic.exception.EmptyTrafficExecutionUnitException;
import org.apache.shardingsphere.traffic.executor.TrafficExecutorCallback;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.transaction.implicit.ImplicitTransactionCallback;
import org.apache.shardingsphere.transaction.util.AutoCommitUtils;

public final class ShardingSphereStatement
extends AbstractStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final List<Statement> statements;
    private final StatementOption statementOption;
    private final DriverExecutor executor;
    private final KernelProcessor kernelProcessor;
    private final TrafficRule trafficRule;
    private final StatementManager statementManager;
    private final BatchStatementExecutor batchStatementExecutor;
    private boolean returnGeneratedKeys;
    private ExecutionContext executionContext;
    private ResultSet currentResultSet;
    private String trafficInstanceId;
    private boolean useFederation;
    private String databaseName;

    public ShardingSphereStatement(ShardingSphereConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.statements = new LinkedList<Statement>();
        this.statementOption = new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        this.kernelProcessor = new KernelProcessor();
        this.trafficRule = (TrafficRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(TrafficRule.class);
        this.statementManager = new StatementManager();
        this.batchStatementExecutor = new BatchStatementExecutor(this);
        this.databaseName = connection.getDatabaseName();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingSphereResultSet result;
        if (Strings.isNullOrEmpty((String)sql)) {
            throw new EmptySQLException().toSQLException();
        }
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.handleAutoCommit(queryContext);
            this.databaseName = queryContext.getDatabaseNameFromSQLStatement().orElse(this.connection.getDatabaseName());
            this.connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabase(this.databaseName);
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                ResultSet resultSet = (ResultSet)this.executor.getTrafficExecutor().execute(executionUnit, Statement::executeQuery);
                return resultSet;
            }
            this.useFederation = this.decide(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getGlobalRuleMetaData());
            if (this.useFederation) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                return resultSet;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            result = this.doExecuteQuery(this.executionContext);
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    private ShardingSphereResultSet doExecuteQuery(ExecutionContext executionContext) throws SQLException {
        List<QueryResult> queryResults = this.executeQuery0(executionContext);
        MergedResult mergedResult = this.mergeQuery(queryResults, executionContext.getSqlStatementContext());
        boolean selectContainsEnhancedTable = executionContext.getSqlStatementContext() instanceof SelectStatementContext && ((SelectStatementContext)executionContext.getSqlStatementContext()).isContainsEnhancedTable();
        return new ShardingSphereResultSet(this.getResultSets(), mergedResult, this, selectContainsEnhancedTable, executionContext);
    }

    private boolean decide(QueryContext queryContext, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        return this.executor.getSqlFederationEngine().decide(queryContext.getSqlStatementContext(), queryContext.getParameters(), database, globalRuleMetaData);
    }

    private Optional<String> getInstanceIdAndSet(QueryContext queryContext) {
        Optional<String> result = this.connection.getDatabaseConnectionManager().getConnectionContext().getTrafficInstanceId();
        if (!result.isPresent()) {
            result = this.getInstanceId(queryContext);
        }
        if (this.connection.isHoldTransaction() && result.isPresent()) {
            this.connection.getDatabaseConnectionManager().getConnectionContext().setTrafficInstanceId(result.get());
        }
        return result;
    }

    private Optional<String> getInstanceId(QueryContext queryContext) {
        InstanceContext instanceContext = this.connection.getContextManager().getInstanceContext();
        return null != this.trafficRule && !this.trafficRule.getStrategyRules().isEmpty() ? new TrafficEngine(this.trafficRule, instanceContext).dispatch(queryContext, this.connection.isHoldTransaction()) : Optional.empty();
    }

    private List<QueryResult> executeQuery0(ExecutionContext executionContext) throws SQLException {
        if (!this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty()) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionContext(executionContext), executionContext.getQueryContext(), new RawSQLExecutorCallback()).stream().map(QueryResult.class::cast).collect(Collectors.toList());
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), executionContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown());
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, executionContext.getQueryContext(), callback);
    }

    private ResultSet executeFederationQuery(QueryContext queryContext) {
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), queryContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown());
        SQLFederationContext context = new SQLFederationContext(false, queryContext, this.metaDataContexts.getMetaData(), this.connection.getProcessId());
        return this.executor.getSqlFederationEngine().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connection.getDatabaseConnectionManager(), (ExecutorStatementManager)this.statementManager, (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData().getStorageUnits());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.executeUpdate0(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL), (TrafficExecutorCallback<Integer>)((TrafficExecutorCallback)Statement::executeUpdate));
            return n;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            int n = this.executeUpdate0(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, autoGeneratedKeys), (TrafficExecutorCallback<Integer>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.executeUpdate(actualSQL, autoGeneratedKeys)));
            return n;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.executeUpdate0(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnIndexes), (TrafficExecutorCallback<Integer>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.executeUpdate(actualSQL, columnIndexes)));
            return n;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.executeUpdate0(sql, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnNames), (TrafficExecutorCallback<Integer>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.executeUpdate(actualSQL, columnNames)));
            return n;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private int executeUpdate(ExecuteUpdateCallback updateCallback, SQLStatementContext sqlStatementContext, ExecutionContext executionContext) throws SQLException {
        return this.isNeedImplicitCommitTransaction(this.connection, executionContext.getSqlStatementContext().getSqlStatement(), executionContext.getExecutionUnits().size() > 1) ? this.executeUpdateWithImplicitCommitTransaction((ImplicitTransactionCallback<Integer>)((ImplicitTransactionCallback)() -> this.useDriverToExecuteUpdate(updateCallback, sqlStatementContext, executionContext))) : this.useDriverToExecuteUpdate(updateCallback, sqlStatementContext, executionContext);
    }

    private int executeUpdate0(String sql, ExecuteUpdateCallback updateCallback, TrafficExecutorCallback<Integer> trafficCallback) throws SQLException {
        QueryContext queryContext = this.createQueryContext(sql);
        this.handleAutoCommit(queryContext);
        this.databaseName = queryContext.getDatabaseNameFromSQLStatement().orElse(this.connection.getDatabaseName());
        this.connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabase(this.databaseName);
        this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
        if (null != this.trafficInstanceId) {
            JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
            return (Integer)this.executor.getTrafficExecutor().execute(executionUnit, trafficCallback);
        }
        this.executionContext = this.createExecutionContext(queryContext);
        if (!this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty()) {
            List results = this.executor.getRawExecutor().execute(this.createRawExecutionContext(this.executionContext), this.executionContext.getQueryContext(), new RawSQLExecutorCallback());
            return this.accumulate(results);
        }
        return this.executeUpdate(updateCallback, queryContext.getSqlStatementContext(), this.executionContext);
    }

    private int executeUpdateWithImplicitCommitTransaction(ImplicitTransactionCallback<Integer> callback) throws SQLException {
        int result;
        try {
            this.connection.setAutoCommit(false);
            result = (Integer)callback.execute();
            this.connection.commit();
        }
        catch (RuntimeException ex) {
            this.connection.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.connection.setAutoCommit(true);
        }
        return result;
    }

    private int useDriverToExecuteUpdate(ExecuteUpdateCallback updateCallback, SQLStatementContext sqlStatementContext, ExecutionContext executionContext) throws SQLException {
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        JDBCExecutorCallback<Integer> callback = this.createExecuteUpdateCallback(updateCallback, sqlStatementContext);
        return this.executor.getRegularExecutor().executeUpdate(executionGroupContext, executionContext.getQueryContext(), executionContext.getRouteContext().getRouteUnits(), callback);
    }

    private JDBCExecutorCallback<Integer> createExecuteUpdateCallback(final ExecuteUpdateCallback updateCallback, SQLStatementContext sqlStatementContext) {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), sqlStatementContext.getSqlStatement(), isExceptionThrown){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return updateCallback.executeUpdate(sql, statement);
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL), (TrafficExecutorCallback<Boolean>)((TrafficExecutorCallback)Statement::execute));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (1 == autoGeneratedKeys) {
                this.returnGeneratedKeys = true;
            }
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, autoGeneratedKeys), (TrafficExecutorCallback<Boolean>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.execute(actualSQL, autoGeneratedKeys)));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnIndexes), (TrafficExecutorCallback<Boolean>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.execute(actualSQL, columnIndexes)));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.returnGeneratedKeys = true;
            return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnNames), (TrafficExecutorCallback<Boolean>)((TrafficExecutorCallback)(statement, actualSQL) -> statement.execute(actualSQL, columnNames)));
        }
        catch (SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaDataContexts);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute0(String sql, ExecuteCallback executeCallback, TrafficExecutorCallback<Boolean> trafficCallback) throws SQLException {
        try {
            QueryContext queryContext = this.createQueryContext(sql);
            this.handleAutoCommit(queryContext);
            this.databaseName = queryContext.getDatabaseNameFromSQLStatement().orElse(this.connection.getDatabaseName());
            this.connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabase(this.databaseName);
            this.trafficInstanceId = this.getInstanceIdAndSet(queryContext).orElse(null);
            if (null != this.trafficInstanceId) {
                JDBCExecutionUnit executionUnit = this.createTrafficExecutionUnit(this.trafficInstanceId, queryContext);
                boolean bl = (Boolean)this.executor.getTrafficExecutor().execute(executionUnit, trafficCallback);
                return bl;
            }
            this.useFederation = this.decide(queryContext, this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getGlobalRuleMetaData());
            if (this.useFederation) {
                ResultSet resultSet = this.executeFederationQuery(queryContext);
                boolean bl = null != resultSet;
                return bl;
            }
            this.executionContext = this.createExecutionContext(queryContext);
            if (!this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(RawExecutionRuleAttribute.class).isEmpty()) {
                List results = this.executor.getRawExecutor().execute(this.createRawExecutionContext(this.executionContext), this.executionContext.getQueryContext(), new RawSQLExecutorCallback());
                boolean bl = results.iterator().next() instanceof QueryResult;
                return bl;
            }
            boolean bl = this.executeWithExecutionContext(executeCallback, this.executionContext);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private void handleAutoCommit(QueryContext queryContext) throws SQLException {
        if (AutoCommitUtils.needOpenTransaction((SQLStatement)queryContext.getSqlStatementContext().getSqlStatement())) {
            this.connection.handleAutoCommit();
        }
    }

    private JDBCExecutionUnit createTrafficExecutionUnit(String trafficInstanceId, QueryContext queryContext) throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        ExecutionUnit executionUnit = new ExecutionUnit(trafficInstanceId, new SQLUnit(queryContext.getSql(), queryContext.getParameters()));
        ExecutionGroupContext context = prepareEngine.prepare(new RouteContext(), Collections.singletonList(executionUnit), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
        return (JDBCExecutionUnit)context.getInputGroups().stream().flatMap(each -> each.getInputs().stream()).findFirst().orElseThrow(EmptyTrafficExecutionUnitException::new);
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.statements) {
            each.close();
        }
        this.statements.clear();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batchStatementExecutor.addBatch(sql);
    }

    @Override
    public void clearBatch() {
        this.batchStatementExecutor.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.batchStatementExecutor.executeBatch();
    }

    private QueryContext createQueryContext(String originSQL) {
        SQLParserRule sqlParserRule = (SQLParserRule)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        String sql = SQLHintUtils.removeHint((String)originSQL);
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType()).parse(sql, false);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(this.metaDataContexts.getMetaData(), this.databaseName, hintValueContext).bind(sqlStatement, Collections.emptyList());
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList(), hintValueContext);
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) throws SQLException {
        this.clearStatements();
        RuleMetaData globalRuleMetaData = this.metaDataContexts.getMetaData().getGlobalRuleMetaData();
        ShardingSphereDatabase currentDatabase = this.metaDataContexts.getMetaData().getDatabase(this.databaseName);
        SQLAuditEngine.audit((SQLStatementContext)queryContext.getSqlStatementContext(), (List)queryContext.getParameters(), (RuleMetaData)globalRuleMetaData, (ShardingSphereDatabase)currentDatabase, null, (HintValueContext)queryContext.getHintValueContext());
        return this.kernelProcessor.generateExecutionContext(queryContext, currentDatabase, globalRuleMetaData, this.metaDataContexts.getMetaData().getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionGroupContext(ExecutionContext executionContext) throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionContext(ExecutionContext executionContext) throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules()).prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), this.databaseName, new Grantee("", "")));
    }

    private boolean executeWithExecutionContext(ExecuteCallback executeCallback, ExecutionContext executionContext) throws SQLException {
        return this.isNeedImplicitCommitTransaction(this.connection, executionContext.getSqlStatementContext().getSqlStatement(), executionContext.getExecutionUnits().size() > 1) ? this.executeWithImplicitCommitTransaction((ImplicitTransactionCallback<Boolean>)((ImplicitTransactionCallback)() -> this.useDriverToExecute(executeCallback, executionContext))) : this.useDriverToExecute(executeCallback, executionContext);
    }

    private boolean executeWithImplicitCommitTransaction(ImplicitTransactionCallback<Boolean> callback) throws SQLException {
        boolean result;
        try {
            this.connection.setAutoCommit(false);
            result = (Boolean)callback.execute();
            this.connection.commit();
        }
        catch (Exception ex) {
            this.connection.rollback();
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType());
        }
        finally {
            this.connection.setAutoCommit(true);
        }
        return result;
    }

    private boolean useDriverToExecute(ExecuteCallback callback, ExecutionContext executionContext) throws SQLException {
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext(executionContext);
        this.cacheStatements(executionGroupContext.getInputGroups());
        JDBCExecutorCallback<Boolean> jdbcExecutorCallback = this.createExecuteCallback(callback, executionContext.getSqlStatementContext().getSqlStatement());
        return this.executor.getRegularExecutor().execute(executionGroupContext, executionContext.getQueryContext(), executionContext.getRouteContext().getRouteUnits(), jdbcExecutorCallback);
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) throws SQLException {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            this.statements.addAll(each.getInputs().stream().map(JDBCExecutionUnit::getStorageResource).collect(Collectors.toList()));
        }
        this.replay();
    }

    private JDBCExecutorCallback<Boolean> createExecuteCallback(final ExecuteCallback executeCallback, SQLStatement sqlStatement) {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType(), this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData(), sqlStatement, isExceptionThrown){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return executeCallback.execute(sql, statement);
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement1, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    private void replay() throws SQLException {
        for (Statement each : this.statements) {
            this.getMethodInvocationRecorder().replay(each);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (null != this.trafficInstanceId) {
            return this.executor.getTrafficExecutor().getResultSet();
        }
        if (this.useFederation) {
            return this.executor.getSqlFederationEngine().getResultSet();
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            if (resultSets.isEmpty()) {
                return this.currentResultSet;
            }
            SQLStatementContext sqlStatementContext = this.executionContext.getSqlStatementContext();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets), sqlStatementContext);
            boolean selectContainsEnhancedTable = sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsEnhancedTable();
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, selectContainsEnhancedTable, this.executionContext);
        }
        return this.currentResultSet;
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement each : this.statements) {
            if (null == each.getResultSet()) continue;
            result.add(each.getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.metaDataContexts.getMetaData().getDatabase(this.databaseName), this.metaDataContexts.getMetaData().getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        for (DataNodeRuleAttribute each : this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getAttributes(DataNodeRuleAttribute.class)) {
            if (!each.isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent() && !generatedKey.get().getGeneratedValues().isEmpty()) {
            return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(generatedKey.get().getColumnName()), generatedKey.get().getGeneratedValues().iterator(), this);
        }
        LinkedList<Comparable> generatedValues = new LinkedList<Comparable>();
        for (Statement each : this.statements) {
            ResultSet resultSet = each.getGeneratedKeys();
            while (resultSet.next()) {
                generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(columnName), generatedValues.iterator(), this);
    }

    private Optional<GeneratedKeyContext> findGeneratedKey() {
        return this.executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)this.executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    private String getGeneratedKeysColumnName(String columnName) {
        return this.metaDataContexts.getMetaData().getDatabase(this.databaseName).getProtocolType() instanceof MySQLDatabaseType ? "GENERATED_KEY" : columnName;
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }
}

