/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.spi.PortletURLProvider;

public class PortletURLProviderImpl
implements PortletURLProvider {
    private PortalURL url;
    private String window;

    public PortletURLProviderImpl(HttpServletRequest request, PortletWindow internalPortletWindow) {
        PortalRequestContext ctx = (PortalRequestContext)request.getAttribute(PortalRequestContext.REQUEST_KEY);
        this.url = ctx.createPortalURL();
        this.window = internalPortletWindow.getId().getStringId();
    }

    public void setPortletMode(PortletMode mode) {
        this.url.setPortletMode(this.window, mode);
    }

    public void setWindowState(WindowState state) {
        this.url.setWindowState(this.window, state);
    }

    public void setAction(boolean action) {
        if (action) {
            this.url.setActionWindow(this.window);
        } else {
            this.url.setActionWindow(null);
        }
    }

    public void setSecure() throws PortletSecurityException {
        throw new PortletSecurityException("No Supported");
    }

    public boolean isSecureSupported() {
        return false;
    }

    public void clearParameters() {
        this.url.clearParameters(this.window);
    }

    public void setParameters(Map parameters) {
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PortalURLParameter param = new PortalURLParameter(this.window, (String)entry.getKey(), (String[])entry.getValue());
            this.url.addParameter(param);
        }
    }

    public String toString() {
        return this.url.toString();
    }
}

