/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.List;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;

@ThreadSafe
public class ThreadSafeLemmatizerME
implements Lemmatizer,
AutoCloseable {
    private final LemmatizerModel model;
    private final ThreadLocal<LemmatizerME> threadLocal = new ThreadLocal();

    public ThreadSafeLemmatizerME(LemmatizerModel model) {
        this.model = model;
    }

    private LemmatizerME getLemmatizer() {
        LemmatizerME tagger = this.threadLocal.get();
        if (tagger == null) {
            tagger = new LemmatizerME(this.model);
            this.threadLocal.set(tagger);
        }
        return tagger;
    }

    @Override
    public String[] lemmatize(String[] toks, String[] tags) {
        return this.getLemmatizer().lemmatize(toks, tags);
    }

    @Override
    public List<List<String>> lemmatize(List<String> toks, List<String> tags) {
        return this.getLemmatizer().lemmatize(toks, tags);
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

