/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;

public class ServiceDaemon
implements ServerService {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, ServiceDaemon.class);
    private ServerService next;
    private SocketListener socketListener;
    private int timeout = 1000;
    private InetAddress address;
    private int port;
    private String name;
    boolean stop = true;
    private int backlog;
    private String ip;
    private boolean secure;
    private StringTemplate discoveryUriFormat;
    private URI uri;
    private Properties props;

    public ServiceDaemon(ServerService next) {
        this.next = next;
    }

    public ServiceDaemon(ServerService next, int port, String ip) {
        this.port = port;
        this.ip = ip;
        this.address = ServiceDaemon.getAddress(ip);
        this.next = next;
    }

    public static InetAddress getAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(host);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.socketListener != null) {
            this.socketListener.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws IOException {
        if (this.socketListener == null) {
            return 0;
        }
        return this.socketListener.getSoTimeout();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void init(Properties props) throws Exception {
        this.props = props;
        String formatString = props.getProperty("discovery");
        if (formatString != null) {
            this.discoveryUriFormat = new StringTemplate(formatString);
        }
        this.ip = props.getProperty("bind");
        this.address = ServiceDaemon.getAddress(this.ip);
        Options options = new Options(props);
        this.port = options.get("port", 0);
        int threads = options.get("threads", 100);
        this.backlog = options.get("backlog", threads);
        this.secure = options.get("secure", false);
        this.timeout = options.get("timeout", this.timeout);
        this.next.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            ServerSocket serverSocket;
            if (this.socketListener != null) {
                return;
            }
            this.next.start();
            try {
                if (this.secure) {
                    ServerSocketFactory factory = SSLServerSocketFactory.getDefault();
                    serverSocket = factory.createServerSocket(this.port, this.backlog, this.address);
                    String[] enabledCipherSuites = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
                    ((SSLServerSocket)serverSocket).setEnabledCipherSuites(enabledCipherSuites);
                } else {
                    serverSocket = new ServerSocket(this.port, this.backlog, this.address);
                }
                this.port = serverSocket.getLocalPort();
                serverSocket.setSoTimeout(this.timeout);
            }
            catch (Exception e) {
                throw new ServiceException("Service failed to open socket", e);
            }
            this.socketListener = new SocketListener(this.next, serverSocket);
            Thread thread = new Thread(this.socketListener);
            thread.setName("service." + this.name + "@" + this.socketListener.hashCode());
            thread.setDaemon(true);
            thread.start();
            DiscoveryAgent agent = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
            if (agent != null && this.discoveryUriFormat != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                    map.put(entry.getKey().toString(), entry.getValue().toString());
                }
                map.put("port", Integer.toString(this.port));
                String address = this.ip;
                if ("0.0.0.0".equals(address)) {
                    try {
                        address = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        log.error("Failed to resolve 0.0.0.0 to a routable address", (Throwable)e);
                    }
                }
                map.put("host", address);
                map.put("bind", address);
                String uriString = this.discoveryUriFormat.apply(map);
                try {
                    this.uri = new URI(uriString);
                    agent.registerService(this.uri);
                }
                catch (Exception e) {
                    log.error("Cannot register service '" + this.getName() + "' with DiscoveryAgent.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            DiscoveryAgent agent = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
            if (agent != null && this.discoveryUriFormat != null && this.uri != null) {
                try {
                    agent.unregisterService(this.uri);
                }
                catch (IOException e) {
                    log.error("Cannot unregister service '" + this.getName() + "' with DiscoveryAgent.", (Throwable)e);
                }
            }
            this.next.stop();
            if (this.socketListener != null) {
                this.socketListener.stop();
                this.socketListener = null;
            }
        }
    }

    @Override
    public String getIP() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    @Override
    public String getName() {
        return this.next.getName();
    }

    private static class SocketListener
    implements Runnable {
        private final ServerService serverService;
        private final ServerSocket serverSocket;
        private AtomicBoolean stop = new AtomicBoolean();
        private Lock lock = new ReentrantLock();

        public SocketListener(ServerService serverService, ServerSocket serverSocket) {
            this.serverService = serverService;
            this.serverSocket = serverSocket;
        }

        public void stop() {
            this.stop.set(true);
            try {
                if (this.lock.tryLock(10L, TimeUnit.SECONDS)) {
                    this.serverSocket.close();
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop.get()) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    socket.setTcpNoDelay(true);
                    if (this.stop.get()) continue;
                    try {
                        this.lock.lock();
                        this.serverService.service(socket);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (SocketTimeoutException e) {
                }
                catch (SocketException e) {
                    if (this.stop.get()) continue;
                    log.error("Socket error", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error("Unexpected error", e);
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException ioException) {
                log.debug("Error cleaning up socked", (Throwable)ioException);
            }
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        public int getSoTimeout() throws IOException {
            return this.serverSocket.getSoTimeout();
        }
    }
}

