/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Database database;
    int rowIdSequence = 0;

    public RowStoreAVLMemory(PersistentStoreCollection persistentStoreCollection, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        persistentStoreCollection.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(int n) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    @Override
    public CachedObject get(int n, boolean bl) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        return cachedObject;
    }

    @Override
    public int getStorageSize(int n) {
        return 0;
    }

    @Override
    public void add(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        return null;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        int n;
        Object object2 = this;
        synchronized (object2) {
            n = this.rowIdSequence++;
        }
        object2 = new RowAVL(this.table, (Object[])object, n, this);
        if (bl) {
            RowAction rowAction;
            ((Row)object2).rowAction = rowAction = new RowAction(session, this.table, 1, (Row)object2, null);
        }
        return object2;
    }

    @Override
    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void removePersistence(int n) {
    }

    @Override
    public void release(int n) {
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
    }

    @Override
    public void release() {
        this.setTimestamp(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, int n) {
    }
}

