/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public RowStoreAVLHybridExtended(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase, boolean bl) {
        super(session, persistentStoreCollection, tableBase, bl);
    }

    private RowStoreAVLHybridExtended(Session session, TableBase tableBase) {
        super(session, tableBase);
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        if (this.indexList != this.table.getIndexList()) {
            this.resetAccessorKeys(this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, bl);
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (n != this.indexList.length) {
            this.resetAccessorKeys(this.table.getIndexList());
            ((RowAVL)row).setNewNodes(this);
        }
        super.indexRow(session, row);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length || this.indexList[n] != index) {
            this.resetAccessorKeys(this.table.getIndexList());
            return this.getAccessor(index);
        }
        return this.accessorList[n];
    }

    @Override
    public synchronized void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached();
        }
        super.resetAccessorKeys(indexArray);
    }

    private void resetAccessorKeysForCached() {
        RowStoreAVLHybridExtended rowStoreAVLHybridExtended = new RowStoreAVLHybridExtended(this.session, this.table);
        RowIterator rowIterator = this.table.rowIterator(this);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            Row row2 = (Row)((RowStoreAVLHybrid)rowStoreAVLHybridExtended).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVL)rowStoreAVLHybridExtended).indexRow(this.session, row2);
        }
        this.indexList = rowStoreAVLHybridExtended.indexList;
        this.accessorList = rowStoreAVLHybridExtended.accessorList;
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    void lockIndexes() {
        for (int i = 0; i < this.indexList.length; ++i) {
        }
    }

    void unlockIndexes(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
        }
    }
}

