/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

final class DataFileDefrag {
    RandomAccessInterface randomAccessOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex pointerLookup;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.dataFileName = string;
    }

    void process() {
        Object object;
        int n;
        boolean bl = false;
        this.database.logger.logDetailEvent("Defrag process begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        this.database.logger.logDetailEvent("transaction count " + this.transactionRowLookup.size());
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        this.rootsList = new int[hsqlArrayList.size()][];
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        for (n = 0; n < n3; ++n) {
            int n4;
            Table table = (Table)hsqlArrayList.get(n);
            if (table.getTableType() != 5 || (n4 = (object = this.database.persistentStoreCollection.getStore(table)).elementCount()) <= n2) continue;
            n2 = n4;
        }
        try {
            this.pointerLookup = new DoubleIntIndex(n2, false);
            n = this.database.logger.isStoredFileAccess() ? 3 : 0;
            this.randomAccessOut = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".new", false, n);
            this.randomAccessOut.write(new byte[this.cache.initialFreePos], 0, this.cache.initialFreePos);
            this.fileOffset = this.cache.initialFreePos;
            int n5 = hsqlArrayList.size();
            for (n3 = 0; n3 < n5; ++n3) {
                object = (Table)hsqlArrayList.get(n3);
                if (((TableBase)object).getTableType() == 5) {
                    int[] nArray = this.writeTableToDataFile((Table)object);
                    this.rootsList[n3] = nArray;
                    this.randomAccessOut.synch();
                } else {
                    this.rootsList[n3] = null;
                }
                this.database.logger.logDetailEvent("table complete " + ((Table)object).getName().name);
            }
            this.randomAccessOut.seek(12L);
            this.randomAccessOut.writeLong(this.fileOffset);
            n3 = 0;
            if (this.database.logger.propIncrementBackup) {
                n3 = BitMap.set(n3, 1);
            }
            n3 = BitMap.set(n3, 4);
            n3 = BitMap.set(n3, 2);
            this.randomAccessOut.seek(28L);
            this.randomAccessOut.writeInt(n3);
            this.randomAccessOut.synch();
            this.randomAccessOut.close();
            this.randomAccessOut = null;
            for (int[] nArray : this.rootsList) {
                if (nArray == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList(nArray, ",", ""));
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.database.logger.logSevereEvent("defrag failed - out of memory - required: " + n2 * 8, null);
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable) {
            throw Error.error(458, throwable);
        }
        finally {
            try {
                if (this.randomAccessOut != null) {
                    this.randomAccessOut.close();
                }
            }
            catch (Throwable throwable) {
                bl = false;
            }
            if (!bl) {
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
        }
        this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
    }

    void updateTableIndexRoots() {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 5) continue;
            int[] nArray = this.rootsList[i];
            table.setIndexRoots(nArray);
        }
    }

    void updateTransactionRowIDs() {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore persistentStore = table.getRowStore(session);
        RowOutputInterface rowOutputInterface = this.cache.rowOut.duplicate();
        int[] nArray = table.getIndexRootsArray();
        long l = this.fileOffset;
        int n = 0;
        this.pointerLookup.removeAll();
        this.pointerLookup.setKeysSearchTarget();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().name + " " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIteratorClustered(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            this.pointerLookup.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n != 0 && n % 100000 == 0) {
                this.database.logger.logDetailEvent("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        this.database.logger.logDetailEvent("table read " + table.getName().name + " " + this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIteratorClustered(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            rowOutputInterface.reset();
            row.write(rowOutputInterface, this.pointerLookup);
            this.randomAccessOut.write(rowOutputInterface.getOutputStream().getBuffer(), 0, rowOutputInterface.size());
            this.fileOffset += (long)row.getStorageSize();
            if (n != 0 && n % 100000 == 0) {
                this.database.logger.logDetailEvent("rows count " + n + " " + this.stopw.elapsedTime());
            }
            ++n;
        }
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (nArray[i] == -1) continue;
            int n2 = this.pointerLookup.findFirstEqualKeyIndex(nArray[i]);
            if (n2 == -1) {
                throw Error.error(466);
            }
            nArray[i] = this.pointerLookup.getValue(n2);
        }
        this.setTransactionRowLookups(this.pointerLookup);
        this.database.logger.logDetailEvent("table written " + table.getName().name);
        return nArray;
    }

    public int[][] getIndexRoots() {
        return this.rootsList;
    }

    void setTransactionRowLookups(DoubleIntIndex doubleIntIndex) {
        int n = this.transactionRowLookup.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.transactionRowLookup.getKey(i);
            int n3 = doubleIntIndex.findFirstEqualKeyIndex(n2);
            if (n3 == -1) continue;
            this.transactionRowLookup.setValue(i, doubleIntIndex.getValue(n3));
        }
    }

    static boolean checkAllTables(Database database) {
        Session session = database.getSessionManager().getSysSession();
        HsqlArrayList hsqlArrayList = database.schemaManager.getAllTables(true);
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            int n2 = 0;
            if (table.getTableType() != 5) continue;
            RowIterator rowIterator = table.rowIterator(session);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                ++n2;
            }
            System.out.println("table " + table.getName().name + " " + n2);
        }
        return true;
    }
}

