/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trigger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public class TriggerDef
implements Runnable,
SchemaObject {
    static final int OLD_ROW = 0;
    static final int NEW_ROW = 1;
    static final int RANGE_COUNT = 2;
    static final int OLD_TABLE = 2;
    static final int NEW_TABLE = 3;
    static final int BEFORE = 4;
    static final int AFTER = 5;
    static final int INSTEAD = 6;
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 9;
    static final TriggerDef[] emptyArray = new TriggerDef[0];
    Table[] transitions;
    RangeVariable[] rangeVars;
    Expression condition;
    boolean hasTransitionTables;
    boolean hasTransitionRanges;
    String conditionSQL;
    Routine routine;
    int[] updateColumns;
    private HsqlNameManager.HsqlName name;
    long changeTimestamp;
    int actionTiming;
    int operationType;
    boolean isSystem;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    Table table;
    Trigger trigger;
    String triggerClassName;
    int triggerType;
    Thread thread;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid = true;
    protected volatile boolean keepGoing = true;

    TriggerDef() {
    }

    public TriggerDef(HsqlNameManager.HsqlName hsqlName, int n, int n2, boolean bl, Table table, Table[] tableArray, RangeVariable[] rangeVariableArray, Expression expression, String string, int[] nArray, String string2, boolean bl2, int n3) {
        this(hsqlName, n, n2, bl, table, tableArray, rangeVariableArray, expression, string, nArray);
        this.triggerClassName = string2;
        this.nowait = bl2;
        this.maxRowsQueued = n3;
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (clazz == null) {
            this.valid = false;
            this.trigger = new DefaultTrigger();
        } else {
            try {
                this.trigger = (Trigger)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.valid = false;
                this.trigger = new DefaultTrigger();
            }
        }
    }

    public TriggerDef(HsqlNameManager.HsqlName hsqlName, int n, int n2, boolean bl, Table table, Table[] tableArray, RangeVariable[] rangeVariableArray, Expression expression, String string, int[] nArray) {
        this.name = hsqlName;
        this.actionTiming = n;
        this.operationType = n2;
        this.forEachRow = bl;
        this.table = table;
        this.transitions = tableArray;
        this.rangeVars = rangeVariableArray;
        this.condition = expression == null ? Expression.EXPR_TRUE : expression;
        this.updateColumns = nArray;
        this.conditionSQL = string;
        this.hasTransitionRanges = rangeVariableArray[0] != null || rangeVariableArray[1] != null;
        this.hasTransitionTables = tableArray[2] != null || tableArray[3] != null;
        this.setUpIndexesAndTypes();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = this.getSQLMain();
        if (this.maxRowsQueued != 0) {
            stringBuffer.append("QUEUE").append(' ');
            stringBuffer.append(this.maxRowsQueued).append(' ');
            if (this.nowait) {
                stringBuffer.append("NOWAIT").append(' ');
            }
        }
        stringBuffer.append("CALL").append(' ');
        stringBuffer.append(StringConverter.toQuotedString(this.triggerClassName, '\"', false));
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public StringBuffer getSQLMain() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("TRIGGER").append(' ');
        stringBuffer.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        stringBuffer.append(this.getActionTimingString()).append(' ');
        stringBuffer.append(this.getEventTypeString()).append(' ');
        if (this.updateColumns != null) {
            stringBuffer.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(',');
                }
                HsqlNameManager.HsqlName hsqlName = this.table.getColumn(this.updateColumns[i]).getName();
                stringBuffer.append(hsqlName.statementName);
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append("ON").append(' ');
        stringBuffer.append(this.table.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ');
        if (this.hasTransitionRanges || this.hasTransitionTables) {
            stringBuffer.append("REFERENCING").append(' ');
            if (this.rangeVars[0] != null) {
                stringBuffer.append("OLD").append(' ').append("ROW");
                stringBuffer.append(' ').append("AS").append(' ');
                stringBuffer.append(this.rangeVars[0].getTableAliasName().getStatementName());
                stringBuffer.append(' ');
            }
            if (this.rangeVars[1] != null) {
                stringBuffer.append("NEW").append(' ').append("ROW");
                stringBuffer.append(' ').append("AS").append(' ');
                stringBuffer.append(this.rangeVars[1].getTableAliasName().getStatementName());
                stringBuffer.append(' ');
            }
            if (this.transitions[2] != null) {
                stringBuffer.append("OLD").append(' ').append("TABLE");
                stringBuffer.append(' ').append("AS").append(' ');
                stringBuffer.append(this.transitions[2].getName().statementName);
                stringBuffer.append(' ');
            }
            if (this.transitions[3] != null) {
                stringBuffer.append("OLD").append(' ').append("TABLE");
                stringBuffer.append(' ').append("AS").append(' ');
                stringBuffer.append(this.transitions[3].getName().statementName);
                stringBuffer.append(' ');
            }
        }
        if (this.forEachRow) {
            stringBuffer.append("FOR").append(' ');
            stringBuffer.append("EACH").append(' ');
            stringBuffer.append("ROW").append(' ');
        }
        if (this.condition != Expression.EXPR_TRUE) {
            stringBuffer.append("WHEN").append(' ');
            stringBuffer.append("(").append(this.conditionSQL);
            stringBuffer.append(")").append(' ');
        }
        return stringBuffer;
    }

    public String getClassName() {
        return this.trigger.getClass().getName();
    }

    public String getActionTimingString() {
        switch (this.actionTiming) {
            case 4: {
                return "BEFORE";
            }
            case 5: {
                return "AFTER";
            }
            case 6: {
                return "INSTEAD OF";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public String getEventTypeString() {
        switch (this.operationType) {
            case 50: {
                return "INSERT";
            }
            case 19: {
                return "DELETE";
            }
            case 82: {
                return "UPDATE";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public String getConditionSQL() {
        return this.conditionSQL;
    }

    public String getProcedureSQL() {
        return this.routine == null ? null : this.routine.getSQLBodyDefinition();
    }

    public int[] getUpdateColumnIndexes() {
        return this.updateColumns;
    }

    public boolean hasOldTable() {
        return false;
    }

    public boolean hasNewTable() {
        return false;
    }

    public String getOldTransitionRowName() {
        return this.rangeVars[0] == null ? null : this.rangeVars[0].getTableAlias();
    }

    public String getNewTransitionRowName() {
        return this.rangeVars[1] == null ? null : this.rangeVars[1].getTableAlias();
    }

    public String getOldTransitionTableName() {
        return this.transitions[2] == null ? null : this.transitions[2].getName().name;
    }

    public String getNewTransitionTableName() {
        return this.transitions[3] == null ? null : this.transitions[3].getName().name;
    }

    void setUpIndexesAndTypes() {
        this.triggerType = 0;
        switch (this.operationType) {
            case 50: {
                this.triggerType = 0;
                break;
            }
            case 19: {
                this.triggerType = 1;
                break;
            }
            case 82: {
                this.triggerType = 2;
                break;
            }
            default: {
                throw Error.runtimeError(201, "TriggerDef");
            }
        }
        if (this.forEachRow) {
            this.triggerType += 3;
        }
        if (this.actionTiming == 4 || this.actionTiming == 6) {
            this.triggerType += 3;
        }
    }

    static int getOperationType(int n) {
        switch (n) {
            case 135: {
                return 50;
            }
            case 79: {
                return 19;
            }
            case 303: {
                return 82;
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    static int getTiming(int n) {
        switch (n) {
            case 343: {
                return 4;
            }
            case 336: {
                return 5;
            }
            case 422: {
                return 6;
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public int getStatementType() {
        return this.operationType;
    }

    @Override
    public void run() {
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, triggerData.oldRow, triggerData.newRow);
        }
        try {
            this.thread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pushPair(Session session, Object[] objectArray, Object[] objectArray2) {
        if (this.maxRowsQueued == 0) {
            session.getInternalConnection();
            try {
                this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, objectArray, objectArray2);
            }
            finally {
                session.releaseInternalConnection();
            }
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, objectArray, objectArray2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public Table getTable() {
        return this.table;
    }

    public String getActionOrientationString() {
        return this.forEachRow ? "ROW" : "STATEMENT";
    }

    static class DefaultTrigger
    implements Trigger {
        DefaultTrigger() {
        }

        @Override
        public void fire(int n, String string, String string2, Object[] objectArray, Object[] objectArray2) {
        }
    }

    static class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] objectArray, Object[] objectArray2) {
            this.oldRow = objectArray;
            this.newRow = objectArray2;
            this.username = session.getUsername();
        }
    }
}

