/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.failover.FailOverBag;

public class FailOverBagWrapper
implements Serializable,
Externalizable,
HttpSessionActivationListener {
    protected final WebBeansLogger logger = WebBeansLogger.getLogger(FailOverBagWrapper.class);
    private transient FailOverService failoverService;
    protected FailOverBag bag;
    protected String sessionId;
    protected boolean isSessionInUse;

    public FailOverBagWrapper() {
        this.failoverService = WebBeansContext.getInstance().getService(FailOverService.class);
    }

    public FailOverBagWrapper(HttpSession session, FailOverService service) {
        this.failoverService = service;
        this.isSessionInUse = false;
        this.sessionId = session.getId();
        this.bag = new FailOverBag(session, service);
    }

    public void updateOwbFailOverBag(HttpSession session, FailOverService service) {
        this.isSessionInUse = false;
        this.bag.updateOwbFailOverBag(session, service);
    }

    public void restore() {
        if (!this.isSessionInUse) {
            this.bag.restore();
            if (this.logger.wblWillLogDebug()) {
                this.logger.debug(this.sessionId + " from " + this.bag.getJVMId() + "is restored successfully.");
            }
        } else if (this.logger.wblWillLogDebug()) {
            this.logger.debug("restore is skipped because isSessionInUse is true for session " + this.sessionId);
        }
    }

    public synchronized void sessionIsInUse() {
        this.isSessionInUse = true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isSessionInUse = in.readBoolean();
        this.sessionId = (String)in.readObject();
        if (!this.isSessionInUse) {
            byte[] buf = (byte[])in.readObject();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = this.failoverService.getObjectInputStream(bais);
            this.bag = (FailOverBag)ois.readObject();
            ois.close();
        }
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isSessionInUse);
        out.writeObject(this.sessionId);
        if (this.isSessionInUse) {
            if (this.logger.wblWillLogDebug()) {
                this.logger.debug("writeExternal skip writing because session is in use for sessionid" + this.sessionId);
            }
            return;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        byte[] buf = null;
        baos = new ByteArrayOutputStream();
        oos = this.failoverService.getObjectOutputStream(baos);
        oos.writeObject(this.bag);
        oos.flush();
        buf = baos.toByteArray();
        oos.close();
        baos.close();
        out.writeObject(buf);
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.failoverService != null && this.failoverService.isSupportPassivation()) {
            HttpSession session = event.getSession();
            this.failoverService.sessionWillPassivate(session);
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (this.failoverService != null && (this.failoverService.isSupportFailOver() || this.failoverService.isSupportPassivation())) {
            HttpSession session = event.getSession();
            this.failoverService.restoreBeans(session);
        }
    }
}

