/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebBeansConfigurationFilter
implements Filter {
    private static final String CALL_COUNT_ATTRIBUTE_NAME = WebBeansConfigurationFilter.class.getName();
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansConfigurationFilter.class);
    protected ContainerLifecycle lifeCycle = null;
    protected FailOverService failoverService = null;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();
    private ServletContext servletContext;

    public WebBeansConfigurationFilter() {
        this.failoverService = this.webBeansContext.getService(FailOverService.class);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.lifeCycle = this.webBeansContext.getService(ContainerLifecycle.class);
        try {
            this.servletContext = filterConfig.getServletContext();
            this.lifeCycle.startApplication(new ServletContextEvent(this.servletContext));
        }
        catch (Exception e) {
            logger.error("ERROR_0018", ServletCompatibilityUtil.getServletInfo(this.servletContext));
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (this.firstInit(servletRequest)) {
                this.requestInitialized(servletRequest);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (this.lastDestroy(servletRequest)) {
                this.requestDestroyed(servletRequest);
            }
        }
    }

    private boolean firstInit(ServletRequest servletRequest) {
        Integer callCount = (Integer)servletRequest.getAttribute(CALL_COUNT_ATTRIBUTE_NAME);
        if (callCount == null) {
            callCount = 0;
        }
        Integer n = callCount;
        Integer n2 = callCount = Integer.valueOf(callCount + 1);
        servletRequest.setAttribute(CALL_COUNT_ATTRIBUTE_NAME, callCount);
        return callCount == 1;
    }

    private boolean lastDestroy(ServletRequest servletRequest) {
        Integer callCount;
        Integer n = callCount = (Integer)servletRequest.getAttribute(CALL_COUNT_ATTRIBUTE_NAME);
        Integer n2 = callCount = Integer.valueOf(callCount - 1);
        servletRequest.setAttribute(CALL_COUNT_ATTRIBUTE_NAME, callCount);
        return callCount == 0;
    }

    public void requestInitialized(ServletRequest servletRequest) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a new request : [{0}]", servletRequest.getRemoteAddr());
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, new ServletRequestEvent(this.servletContext, servletRequest));
        }
        catch (Exception e) {
            logger.error("ERROR_0019", servletRequest);
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    public void requestDestroyed(ServletRequest request) {
        ELContextStore elStore;
        HttpServletRequest httpRequest;
        HttpSession session;
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a request : [{0}]", request.getRemoteAddr());
        }
        if (this.failoverService != null && this.failoverService.isSupportFailOver() && request instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
            this.failoverService.sessionIsIdle(session);
        }
        if ((elStore = ELContextStore.getInstance(false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, new ServletRequestEvent(this.servletContext, request));
        this.cleanupRequestThreadLocals();
    }

    public void destroy() {
        this.lifeCycle.stopApplication(new ServletContextEvent(this.servletContext));
        this.lifeCycle = null;
        this.servletContext = null;
        this.cleanupRequestThreadLocals();
    }

    private void cleanupRequestThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        WebContextsService.removeThreadLocals();
    }
}

