/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.decorator.Decorator;
import javax.interceptor.Interceptor;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.creation.InjectionTargetProducer;
import org.apache.webbeans.portable.creation.ProducerBeansProducer;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagedBeanConfigurator {
    private final WebBeansContext webBeansContext;

    public ManagedBeanConfigurator(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void checkManagedBeanCondition(Class<?> clazz) throws WebBeansConfigurationException {
        int modifier = clazz.getModifiers();
        if (AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && !AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            this.webBeansContext.getInterceptorUtil().checkSimpleWebBeansInterceptorConditions(clazz);
        }
        if (ClassUtil.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not _defined as interface");
        }
    }

    public boolean isManagedBean(Class<?> clazz) throws WebBeansConfigurationException {
        try {
            this.webBeansContext.getWebBeansUtil().isManagedBeanClass(clazz);
        }
        catch (WebBeansConfigurationException e) {
            return false;
        }
        return true;
    }

    public <T> ManagedBean<T> define(Class<T> clazz, WebBeansType type) throws WebBeansConfigurationException {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        int modifier = clazz.getModifiers();
        if (AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && !AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            this.webBeansContext.getInterceptorUtil().checkSimpleWebBeansInterceptorConditions(clazz);
        }
        if (ClassUtil.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not _defined as interface");
        }
        ManagedBean<T> component = new ManagedBean<T>(clazz, type, this.webBeansContext);
        manager.putInjectionTargetWrapper(component, new InjectionTargetWrapper<T>(new InjectionTargetProducer<T>(component)));
        this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(component);
        definitionUtil.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, clazz.getDeclaredAnnotations());
        Annotation[] clazzAnns = clazz.getDeclaredAnnotations();
        DefinitionUtil.defineApiTypes(component, clazz);
        DefinitionUtil.defineScopeType(component, clazzAnns, "Simple WebBean Component implementation class : " + clazz.getName() + " stereotypes must declare same @Scope annotations", false);
        component.setFullInit(true);
        WebBeansUtil.checkGenericType(component);
        definitionUtil.defineQualifiers(component, clazzAnns);
        definitionUtil.defineName(component, clazzAnns, WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        Constructor<T> constructor = this.webBeansContext.getWebBeansUtil().defineConstructor(clazz);
        component.setConstructor(constructor);
        definitionUtil.addConstructorInjectionPointMetaData(component, constructor);
        Set<ProducerMethodBean<?>> producerMethods = definitionUtil.defineProducerMethods(component);
        for (ProducerMethodBean<?> producerMethod : producerMethods) {
            manager.addBean(producerMethod);
            manager.putInjectionTargetWrapper(producerMethod, new InjectionTargetWrapper(new ProducerBeansProducer((AbstractProducerBean<?>)producerMethod)));
        }
        Set<ProducerFieldBean<?>> producerFields = definitionUtil.defineProducerFields(component);
        for (ProducerFieldBean<?> producerField : producerFields) {
            manager.addBean(producerField);
            manager.putInjectionTargetWrapper(producerField, new InjectionTargetWrapper(new ProducerBeansProducer((AbstractProducerBean<?>)producerField)));
        }
        definitionUtil.defineDisposalMethods(component);
        definitionUtil.defineInjectedFields(component);
        definitionUtil.defineInjectedMethods(component);
        definitionUtil.defineObserverMethods(component, clazz);
        return component;
    }
}

