/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Scope;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionUtil {
    private final WebBeansContext webBeansContext;

    public DefinitionUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public static <T> void defineApiTypes(AbstractOwbBean<T> bean, Class<T> clazz) {
        Annotation[] annots = clazz.getDeclaredAnnotations();
        if (AnnotationUtil.hasAnnotation(annots, Typed.class)) {
            Typed beanTypes = AnnotationUtil.getAnnotation(annots, Typed.class);
            DefinitionUtil.defineUserDefinedBeanTypes(bean, null, beanTypes);
        } else {
            DefinitionUtil.defineNormalApiTypes(bean, clazz);
        }
        DefinitionUtil.removeIgnoredInterfaces(bean);
    }

    private static <T> void removeIgnoredInterfaces(AbstractOwbBean<T> bean) {
        Set<String> ignoredInterfaces = bean.getWebBeansContext().getOpenWebBeansConfiguration().getIgnoredInterfaces();
        Iterator<Type> i = bean.getTypes().iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (!(t instanceof Class) || !ignoredInterfaces.contains(((Class)t).getName())) continue;
            i.remove();
        }
    }

    private static <T> void defineNormalApiTypes(AbstractOwbBean<T> bean, Class<T> clazz) {
        bean.getTypes().add((Type)((Object)Object.class));
        ClassUtil.setTypeHierarchy(bean.getTypes(), clazz);
    }

    private static <T> void defineUserDefinedBeanTypes(AbstractOwbBean<T> bean, Type producerGenericReturnType, Typed beanTypes) {
        if (producerGenericReturnType != null) {
            DefinitionUtil.defineNormalProducerMethodApi((AbstractProducerBean)bean, producerGenericReturnType);
        } else {
            DefinitionUtil.defineNormalApiTypes(bean, bean.getReturnType());
        }
        Class<?>[] types = beanTypes.value();
        Set<Type> apiTypes = bean.getTypes();
        HashSet<Type> newTypes = new HashSet<Type>();
        for (Class<?> type : types) {
            Type foundType = null;
            for (Type apiType : apiTypes) {
                if (ClassUtil.getClazz(apiType) != type) continue;
                foundType = apiType;
                break;
            }
            if (foundType == null) {
                throw new WebBeansConfigurationException("@Type values must be in bean api types : " + bean.getTypes());
            }
            newTypes.add(foundType);
        }
        apiTypes.clear();
        apiTypes.addAll(newTypes);
        apiTypes.add((Type)((Object)Object.class));
    }

    public static <T> void defineProducerMethodApiTypes(AbstractProducerBean<T> producerBean, Type type, Annotation[] annots) {
        if (AnnotationUtil.hasAnnotation(annots, Typed.class)) {
            Typed beanTypes = AnnotationUtil.getAnnotation(annots, Typed.class);
            DefinitionUtil.defineUserDefinedBeanTypes(producerBean, type, beanTypes);
        } else {
            DefinitionUtil.defineNormalProducerMethodApi(producerBean, type);
        }
        DefinitionUtil.removeIgnoredInterfaces(producerBean);
    }

    private static <T> void defineNormalProducerMethodApi(AbstractProducerBean<T> producerBean, Type type) {
        Set<Type> types = producerBean.getTypes();
        types.add((Type)((Object)Object.class));
        Class<?> clazz = ClassUtil.getClazz(type);
        if (clazz != null && (clazz.isPrimitive() || clazz.isArray())) {
            types.add(clazz);
        } else {
            ClassUtil.setTypeHierarchy(producerBean.getTypes(), type);
        }
    }

    public <T> void defineQualifiers(AbstractOwbBean<T> component, Annotation[] annotations) {
        Annotation annot;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        for (Annotation annotation : annotations) {
            Method[] methods;
            Class<? extends Annotation> type = annotation.annotationType();
            if (!annotationManager.isQualifierAnnotation(type)) continue;
            for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(type)) {
                Class<?> clazz = method.getReturnType();
                if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
                throw new WebBeansConfigurationException("WebBeans definition class : " + component.getReturnType().getName() + " @Qualifier : " + annotation.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
            }
            component.addQualifier(annotation);
        }
        IBeanInheritedMetaData inheritedMetaData = null;
        if (component instanceof InjectionTargetBean) {
            inheritedMetaData = ((InjectionTargetBean)((Object)component)).getInheritedMetaData();
        }
        if (inheritedMetaData != null) {
            Set<Annotation> inheritedTypes = inheritedMetaData.getInheritedQualifiers();
            for (Annotation inherited : inheritedTypes) {
                Set<Annotation> qualifiers = component.getQualifiers();
                boolean found = false;
                for (Annotation existQualifier : qualifiers) {
                    if (!existQualifier.annotationType().equals(inherited.annotationType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                component.addQualifier(inherited);
            }
        }
        if (component.getQualifiers().size() == 0) {
            component.addQualifier(new DefaultLiteral());
        } else if (component.getQualifiers().size() == 1 && (annot = component.getQualifiers().iterator().next()).annotationType().equals(Named.class)) {
            component.addQualifier(new DefaultLiteral());
        }
        if (!AnnotationUtil.hasAnyQualifier(component)) {
            component.addQualifier(new AnyLiteral());
        }
    }

    public static <T> void defineScopeType(AbstractOwbBean<T> component, Annotation[] annotations, String exceptionMessage, boolean allowLazyInit) {
        boolean found = false;
        List<ExternalScope> additionalScopes = component.getWebBeansContext().getBeanManagerImpl().getAdditionalScopes();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation var = annotationType.getAnnotation(NormalScope.class);
            Annotation pseudo = annotationType.getAnnotation(Scope.class);
            if (var == null && pseudo == null) {
                for (ExternalScope additionalScope : additionalScopes) {
                    if (!annotationType.equals(additionalScope.getScope())) continue;
                    Annotation scopeAnnotation = additionalScope.getScopeAnnotation();
                    if (additionalScope.isNormal()) {
                        var = scopeAnnotation;
                        continue;
                    }
                    pseudo = scopeAnnotation;
                }
            }
            if (var != null) {
                if (pseudo != null) {
                    throw new WebBeansConfigurationException("Not to define both @Scope and @NormalScope on bean : " + component);
                }
                if (found) {
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                found = true;
                component.setImplScopeType(annotation);
                continue;
            }
            if (pseudo == null) continue;
            if (found) {
                throw new WebBeansConfigurationException(exceptionMessage);
            }
            found = true;
            component.setImplScopeType(annotation);
        }
        if (!found) {
            DefinitionUtil.defineDefaultScopeType(component, exceptionMessage, allowLazyInit);
        }
    }

    public static <T> void defineStereoTypes(OwbBean<?> component, Annotation[] anns) {
        AnnotationManager annotationManager = component.getWebBeansContext().getAnnotationManager();
        if (annotationManager.hasStereoTypeMetaAnnotation(anns)) {
            Annotation[] steroAnns;
            for (Annotation stereo : steroAnns = annotationManager.getStereotypeMetaAnnotations(anns)) {
                component.addStereoType(stereo);
            }
        }
        IBeanInheritedMetaData inheritedMetaData = null;
        if (component instanceof InjectionTargetBean) {
            inheritedMetaData = ((InjectionTargetBean)component).getInheritedMetaData();
        }
        if (inheritedMetaData != null) {
            Set<Annotation> inheritedTypes = inheritedMetaData.getInheritedStereoTypes();
            for (Annotation inherited : inheritedTypes) {
                Set<Class<Annotation>> qualifiers = component.getStereotypes();
                boolean found = false;
                for (Class<Annotation> existQualifier : qualifiers) {
                    if (!existQualifier.equals(inherited.annotationType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                component.addStereoType(inherited);
            }
        }
    }

    public static void defineDefaultScopeType(OwbBean<?> component, String exceptionMessage, boolean allowLazyInit) {
        Annotation inheritedScope;
        IBeanInheritedMetaData metaData = null;
        if (component instanceof InjectionTargetBean) {
            metaData = ((InjectionTargetBean)component).getInheritedMetaData();
        }
        boolean found = false;
        if (metaData != null && (inheritedScope = metaData.getInheritedScopeType()) != null) {
            found = true;
            component.setImplScopeType(inheritedScope);
        }
        if (!found) {
            Set<Class<Annotation>> stereos = component.getStereotypes();
            if (stereos.size() == 0) {
                component.setImplScopeType(new DependentScopeLiteral());
                if (allowLazyInit && component instanceof ManagedBean && DefinitionUtil.isPurePojoBean(component.getWebBeansContext(), component.getBeanClass())) {
                    ((ManagedBean)component).setFullInit(false);
                }
            } else {
                Annotation defined = null;
                Set<Class<Annotation>> anns = component.getStereotypes();
                for (Class<Annotation> stero : anns) {
                    boolean containsNormal = AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class);
                    if (!AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class) && !AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), Scope.class)) continue;
                    Annotation next = containsNormal ? AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), NormalScope.class)[0] : AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), Scope.class)[0];
                    if (defined == null) {
                        defined = next;
                        continue;
                    }
                    if (((Object)defined).equals(next)) continue;
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                if (defined != null) {
                    component.setImplScopeType(defined);
                } else {
                    component.setImplScopeType(new DependentScopeLiteral());
                    if (allowLazyInit && component instanceof ManagedBean && DefinitionUtil.isPurePojoBean(component.getWebBeansContext(), component.getBeanClass())) {
                        ((ManagedBean)component).setFullInit(false);
                    }
                }
            }
        }
    }

    private static boolean isPurePojoBean(WebBeansContext webBeansContext, Class<?> cls) {
        Class<?> superClass = cls.getSuperclass();
        if (superClass == Object.class || !DefinitionUtil.isPurePojoBean(webBeansContext, superClass)) {
            return false;
        }
        Set<String> annotations = webBeansContext.getScannerService().getAllAnnotations(cls.getSimpleName());
        if (annotations != null) {
            for (String ann : annotations) {
                if (!ann.startsWith("javax.inject") && !ann.startsWith("javax.enterprise") && !ann.startsWith("javax.interceptors")) continue;
                return false;
            }
        }
        return true;
    }

    public <T> void defineName(AbstractOwbBean<T> component, Annotation[] anns, String defaultName) {
        Named nameAnnot = null;
        boolean isDefault = false;
        for (Annotation ann : anns) {
            if (!ann.annotationType().equals(Named.class)) continue;
            nameAnnot = (Named)ann;
            break;
        }
        if (nameAnnot == null) {
            if (this.webBeansContext.getAnnotationManager().hasNamedOnStereoTypes(component)) {
                isDefault = true;
            }
        } else if (nameAnnot.value().equals("")) {
            isDefault = true;
        } else {
            component.setName(nameAnnot.value());
        }
        if (isDefault) {
            component.setName(defaultName);
        }
    }

    public Set<ProducerFieldBean<?>> defineProducerFields(InjectionTargetBean<?> component) {
        Class returnType = component.getReturnType();
        return this.defineProducerFields(component, returnType);
    }

    public Set<ProducerFieldBean<?>> defineProducerFields(InjectionTargetBean<?> component, Class<?> returnType) {
        Field[] fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(returnType);
        HashSet producerFields = new HashSet();
        for (Field field : fields) {
            Type genericType = field.getGenericType();
            if (!AnnotationUtil.hasAnnotation(field.getDeclaredAnnotations(), Produces.class)) continue;
            if (ClassUtil.isParametrizedType(genericType) && !ClassUtil.checkParametrizedType((ParameterizedType)genericType)) {
                throw new WebBeansConfigurationException("Producer field : " + field.getName() + " return type in class : " + field.getDeclaringClass().getName() + " can not be Wildcard type or Type variable");
            }
            ProducerFieldBean<?> newComponent = this.createProducerFieldComponent(field.getType(), field, component);
            if (newComponent == null) continue;
            producerFields.add(newComponent);
        }
        return producerFields;
    }

    public Set<ProducerMethodBean<?>> defineProducerMethods(AbstractInjectionTargetBean<?> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Class clazz = component.getReturnType();
        return this.defineProducerMethods(component, clazz);
    }

    public Set<ProducerMethodBean<?>> defineProducerMethods(AbstractInjectionTargetBean<?> component, Class<?> clazz) {
        Method[] declaredMethods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz);
        HashSet producerComponents = new HashSet();
        for (Method declaredMethod : declaredMethods) {
            this.createProducerComponents(component, producerComponents, declaredMethod, clazz);
        }
        return producerComponents;
    }

    private <T> void createProducerComponents(InjectionTargetBean<T> component, Set<ProducerMethodBean<?>> producerComponents, Method declaredMethod, Class<?> clazz) {
        boolean isSpecializes = false;
        if (AnnotationUtil.hasMethodAnnotation(declaredMethod, Produces.class)) {
            WebBeansUtil.checkProducerMethodForDeployment(declaredMethod, clazz.getName());
            if (AnnotationUtil.hasMethodAnnotation(declaredMethod, Specializes.class)) {
                if (Modifier.isStatic(declaredMethod.getModifiers())) {
                    throw new WebBeansConfigurationException("Specializing producer method : " + declaredMethod.getName() + " in class : " + clazz.getName() + " can not be static");
                }
                isSpecializes = true;
            }
            ProducerMethodBean<?> newComponent = this.createProducerComponent(declaredMethod.getReturnType(), declaredMethod, component, isSpecializes);
            if (component instanceof EnterpriseBeanMarker) {
                OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
                Method method = ejbPlugin.resolveViewMethod(component, declaredMethod);
                newComponent.setCreatorMethod(method);
            }
            if (newComponent != null) {
                producerComponents.add(newComponent);
                this.addMethodInjectionPointMetaData(newComponent, declaredMethod);
            }
        }
    }

    public <T> ProducerMethodBean<T> createProducerComponent(Class<T> returnType, Method method, InjectionTargetBean<?> parent, boolean isSpecializes) {
        ProducerMethodBean<T> component = new ProducerMethodBean<T>(parent, returnType);
        component.setCreatorMethod(method);
        if (isSpecializes) {
            WebBeansUtil.configureProducerSpecialization(component, method, parent.getReturnType().getSuperclass());
        }
        if (returnType.isPrimitive()) {
            component.setNullable(false);
        }
        this.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, method.getDeclaredAnnotations());
        Annotation[] methodAnns = method.getDeclaredAnnotations();
        WebBeansContext webBeansContext = parent.getWebBeansContext();
        webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(parent, component, methodAnns);
        DefinitionUtil.defineProducerMethodApiTypes(component, method.getGenericReturnType(), methodAnns);
        DefinitionUtil.defineScopeType(component, methodAnns, "WebBeans producer method : " + method.getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation", false);
        webBeansContext.getWebBeansUtil().checkUnproxiableApiType(component, component.getScope());
        WebBeansUtil.checkProducerGenericType(component, method);
        this.defineQualifiers(component, methodAnns);
        this.defineName(component, methodAnns, WebBeansUtil.getProducerDefaultName(method.getName()));
        return component;
    }

    private <T> ProducerFieldBean<T> createProducerFieldComponent(Class<T> returnType, Field field, InjectionTargetBean<?> parent) {
        ProducerFieldBean<T> component = new ProducerFieldBean<T>(parent, returnType);
        Annotation resourceAnnotation = AnnotationUtil.hasOwbInjectableResource(field.getDeclaredAnnotations());
        if (resourceAnnotation != null && !Modifier.isStatic(field.getModifiers())) {
            ResourceReference<T, Annotation> resourceRef = new ResourceReference<T, Annotation>(field.getDeclaringClass(), field.getName(), returnType, resourceAnnotation);
            if (field.isAnnotationPresent(Named.class)) {
                throw new WebBeansConfigurationException("Resource producer field : " + field + " can not define EL name");
            }
            ResourceBean<T, Annotation> resourceBean = new ResourceBean<T, Annotation>(returnType, parent, resourceRef);
            DefinitionUtil.defineProducerMethodApiTypes(resourceBean, field.getGenericType(), field.getDeclaredAnnotations());
            this.defineQualifiers(resourceBean, field.getDeclaredAnnotations());
            resourceBean.setImplScopeType(new DependentScopeLiteral());
            resourceBean.setProducerField(field);
            return resourceBean;
        }
        component.setProducerField(field);
        if (returnType.isPrimitive()) {
            component.setNullable(false);
        }
        this.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, field.getDeclaredAnnotations());
        Annotation[] fieldAnns = field.getDeclaredAnnotations();
        this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(parent, component, fieldAnns);
        DefinitionUtil.defineProducerMethodApiTypes(component, field.getGenericType(), fieldAnns);
        DefinitionUtil.defineScopeType(component, fieldAnns, "WebBeans producer method : " + field.getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation", false);
        this.webBeansContext.getWebBeansUtil().checkUnproxiableApiType(component, component.getScope());
        WebBeansUtil.checkProducerGenericType(component, field);
        this.defineQualifiers(component, fieldAnns);
        this.defineName(component, fieldAnns, field.getName());
        return component;
    }

    public <T> void defineDisposalMethods(AbstractOwbBean<T> component) {
        Class<T> clazz = component.getReturnType();
        this.defineDisposalMethods(component, clazz);
    }

    public <T> void defineDisposalMethods(AbstractOwbBean<T> component, Class<?> clazz) {
        Method[] methods = AnnotationUtil.getMethodsWithParameterAnnotation(clazz, Disposes.class);
        this.createDisposalMethods(component, methods, clazz);
    }

    private <T> void createDisposalMethods(AbstractOwbBean<T> component, Method[] methods, Class<?> clazz) {
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        ProducerMethodBean previous = null;
        for (Method declaredMethod : methods) {
            WebBeansUtil.checkProducerMethodDisposal(declaredMethod, clazz.getName());
            Type type = AnnotationUtil.getMethodFirstParameterWithAnnotation(declaredMethod, Disposes.class);
            Annotation[] annot = annotationManager.getMethodFirstParameterQualifierWithGivenAnnotation(declaredMethod, Disposes.class);
            InjectionResolver instance = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
            Set<Bean<?>> set = instance.implResolveByType(type, annot);
            if (set.isEmpty()) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, declaredMethod, annot);
            }
            Bean<?> bean = set.iterator().next();
            ProducerMethodBean pr = null;
            if (bean == null || !(bean instanceof ProducerMethodBean)) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, declaredMethod, new Annotation[0]);
            } else {
                pr = (ProducerMethodBean)bean;
            }
            if (previous == null) {
                previous = pr;
            } else if (previous.equals(pr)) {
                throw new WebBeansConfigurationException("There are multiple disposal method for the producer method : " + pr.getCreatorMethod().getName() + " in class : " + clazz.getName());
            }
            this.addMethodInjectionPointMetaData(component, declaredMethod);
            if (component instanceof EnterpriseBeanMarker) {
                OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
                declaredMethod = ejbPlugin.resolveViewMethod(component, declaredMethod);
            }
            pr.setDisposalMethod(declaredMethod);
            Method producerMethod = pr.getCreatorMethod();
            if (producerMethod.getDeclaringClass().getName().equals(declaredMethod.getDeclaringClass().getName())) continue;
            throw new WebBeansConfigurationException("Producer method component of the disposal method : " + declaredMethod.getName() + " in class : " + clazz.getName() + " must be in the same class!");
        }
    }

    public <T> void defineInjectedFields(AbstractInjectionTargetBean<T> component) {
        Class clazz = component.getReturnType();
        this.defineInternalInjectedFields(component, clazz, false);
        this.defineInternalInjectedFieldsRecursively(component, clazz);
    }

    public <T> void defineInternalInjectedFieldsRecursively(AbstractInjectionTargetBean<T> component, Class<T> clazz) {
        Class<T> superClazz = clazz.getSuperclass();
        if (!superClazz.equals(Object.class)) {
            this.defineInternalInjectedFields(component, superClazz, true);
            this.defineInternalInjectedFieldsRecursively(component, superClazz);
        }
    }

    public <T> void defineInternalInjectedFields(AbstractInjectionTargetBean<T> component, Class<T> clazz, boolean fromSuperClazz) {
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Field[] fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz);
        if (fields.length != 0) {
            for (Field field : fields) {
                int mod;
                if (Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && this.webBeansContext.getBeanManagerImpl().isNormalScope(component.getScope())) {
                    throw new WebBeansConfigurationException("If bean has a public field, bean scope must be defined as @Scope. Bean is : " + component.toString());
                }
                if (!field.isAnnotationPresent(Inject.class)) continue;
                Annotation[] anns = field.getDeclaredAnnotations();
                if (AnnotationUtil.hasAnnotation(anns, Produces.class)) {
                    throw new WebBeansConfigurationException("Injection fields can not be annotated with @Produces");
                }
                Annotation[] qualifierAnns = annotationManager.getQualifierAnnotations(anns);
                if (qualifierAnns.length <= 0) continue;
                if (qualifierAnns.length > 0) {
                    annotationManager.checkForNewQualifierForDeployment(field.getGenericType(), clazz, field.getName(), anns);
                }
                if (Modifier.isStatic(mod = field.getModifiers()) || Modifier.isFinal(mod)) continue;
                if (fromSuperClazz) {
                    component.addInjectedFieldToSuper(field);
                } else {
                    component.addInjectedField(field);
                }
                this.addFieldInjectionPointMetaData(component, field);
            }
        }
    }

    public <T> void defineInjectedMethods(AbstractInjectionTargetBean<T> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Class clazz = bean.getReturnType();
        this.defineInternalInjectedMethods(bean, clazz, false);
        this.defineInternalInjectedMethodsRecursively(bean, clazz);
    }

    public <T> void defineInternalInjectedMethodsRecursively(AbstractInjectionTargetBean<T> component, Class<T> clazz) {
        Class<T> superClazz = clazz.getSuperclass();
        if (!superClazz.equals(Object.class)) {
            this.defineInternalInjectedMethods(component, superClazz, true);
            this.defineInternalInjectedMethodsRecursively(component, superClazz);
        }
    }

    private <T> void defineInternalInjectedMethods(AbstractInjectionTargetBean<T> component, Class<T> clazz, boolean fromInherited) {
        Method[] methods;
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz)) {
            boolean isInitializer = AnnotationUtil.hasMethodAnnotation(method, Inject.class);
            if (!isInitializer || Modifier.isStatic(method.getModifiers())) continue;
            DefinitionUtil.checkForInjectedInitializerMethod(clazz, method, this.webBeansContext);
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (!fromInherited) {
                component.addInjectedMethod(method);
                this.addMethodInjectionPointMetaData(component, method);
                continue;
            }
            Method[] beanMethods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(component.getReturnType());
            boolean defined = false;
            for (Method beanMethod : beanMethods) {
                if (!ClassUtil.isOverridden(beanMethod, method)) continue;
                defined = true;
                break;
            }
            if (defined) continue;
            component.addInjectedMethodToSuper(method);
            this.addMethodInjectionPointMetaData(component, method);
        }
    }

    private static <T> void checkForInjectedInitializerMethod(Class<T> clazz, Method method, WebBeansContext webBeansContext) {
        TypeVariable<Method>[] args = method.getTypeParameters();
        if (args.length > 0) {
            throw new WebBeansConfigurationException("Initializer methods must not be generic but method : " + method.getName() + " in bean class : " + clazz + " is defined as generic");
        }
        Annotation[][] anns = method.getParameterAnnotations();
        Type[] type = method.getGenericParameterTypes();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] a = anns[i];
            Type t = type[i];
            webBeansContext.getAnnotationManager().checkForNewQualifierForDeployment(t, clazz, method.getName(), a);
        }
        if (method.getAnnotation(Produces.class) != null) {
            throw new WebBeansConfigurationException("Initializer method : " + method.getName() + " in class : " + clazz.getName() + " can not be annotated with @Produces");
        }
        WebBeansUtil.checkInjectedMethodParameterConditions(method, clazz);
    }

    public void defineBeanInterceptorStack(AbstractInjectionTargetBean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can no be null");
        if (!bean.getInterceptorStack().isEmpty()) {
            return;
        }
        if (!(bean instanceof EnterpriseBeanMarker)) {
            bean.getWebBeansContext().getEJBInterceptorConfig().configure(bean.getReturnType(), bean.getInterceptorStack());
        } else {
            ArrayList<InterceptorData> stack = new ArrayList<InterceptorData>();
            bean.getWebBeansContext().getEJBInterceptorConfig().configure(bean.getBeanClass(), stack);
            OpenWebBeansEjbPlugin ejbPlugin = bean.getWebBeansContext().getPluginLoader().getEjbPlugin();
            boolean isStateful = ejbPlugin.isStatefulBean(bean.getBeanClass());
            if (isStateful) {
                for (InterceptorData data : stack) {
                    AnnotationManager annotationManager;
                    if (!data.isDefinedInInterceptorClass() || (annotationManager = bean.getWebBeansContext().getAnnotationManager()).checkInjectionPointForInterceptorPassivation(data.getInterceptorClass())) continue;
                    throw new WebBeansConfigurationException("Enterprise bean : " + bean.toString() + " interceptors must have serializable injection points");
                }
            }
        }
        bean.getWebBeansContext().getWebBeansInterceptorConfig().configure(bean, bean.getInterceptorStack());
    }

    public void defineDecoratorStack(AbstractInjectionTargetBean<?> bean) {
        WebBeansDecoratorConfig.configureDecorators(bean);
    }

    public <T> Set<ObserverMethod<?>> defineObserverMethods(InjectionTargetBean<T> component, Class<T> clazz) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        NotificationManager manager = this.webBeansContext.getBeanManagerImpl().getNotificationManager();
        Method[] candidateMethods = AnnotationUtil.getMethodsWithParameterAnnotation(clazz, Observes.class);
        this.createObserverMethods(component, clazz, candidateMethods);
        return manager.addObservableComponentMethods(component);
    }

    private <T> void createObserverMethods(InjectionTargetBean<T> component, Class<?> clazz, Method[] candidateMethods) {
        for (Method candidateMethod : candidateMethods) {
            EventUtil.checkObserverMethodConditions(candidateMethod, clazz);
            AbstractOwbBean bean = (AbstractOwbBean)((Object)component);
            if (bean.getScope().equals(Dependent.class) && EventUtil.isReceptionIfExist(candidateMethod)) {
                throw new WebBeansConfigurationException("Dependent Bean : " + bean + " can not define observer method with @Receiver = IF_EXIST");
            }
            component.addObservableMethod(candidateMethod);
            this.addMethodInjectionPointMetaData((AbstractOwbBean)((Object)component), candidateMethod);
        }
    }

    public <T> void defineSerializable(AbstractOwbBean<T> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        if (ClassUtil.isClassAssignable(Serializable.class, component.getReturnType())) {
            component.setSerializable(true);
        }
    }

    public <T> void addFieldInjectionPointMetaData(AbstractOwbBean<T> owner, Field field) {
        InjectionPoint injectionPoint = owner.getWebBeansContext().getInjectionPointFactory().getFieldInjectionPointData(owner, field);
        if (injectionPoint != null) {
            this.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public <T> void addMethodInjectionPointMetaData(AbstractOwbBean<T> owner, Method method) {
        List<InjectionPoint> injectionPoints = owner.getWebBeansContext().getInjectionPointFactory().getMethodInjectionPointData(owner, method);
        for (InjectionPoint injectionPoint : injectionPoints) {
            this.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public <T> void addConstructorInjectionPointMetaData(AbstractOwbBean<T> owner, Constructor<T> constructor) {
        List<InjectionPoint> injectionPoints = owner.getWebBeansContext().getInjectionPointFactory().getConstructorInjectionPointData(owner, constructor);
        for (InjectionPoint injectionPoint : injectionPoints) {
            this.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public void addImplicitComponentForInjectionPoint(InjectionPoint injectionPoint) {
        if (!WebBeansUtil.checkObtainsInjectionPointConditions(injectionPoint)) {
            EventUtil.checkObservableInjectionPointConditions(injectionPoint);
        }
    }

    public <X> Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        HashSet producerComponents = new HashSet();
        Set<AnnotatedMethod<X>> annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod<X> annotatedMethod : annotatedMethods) {
            this.createProducerBeansFromAnnotatedType(bean, producerComponents, annotatedMethod, bean.getReturnType(), false);
        }
        return producerComponents;
    }

    private <X> void createProducerBeansFromAnnotatedType(InjectionTargetBean<X> bean, Set<ProducerMethodBean<?>> producerComponents, AnnotatedMethod<X> annotatedMethod, Class<?> clazz, boolean isSpecializes) {
        Set<Annotation> annSet = annotatedMethod.getAnnotations();
        Annotation[] anns = annSet.toArray(new Annotation[annSet.size()]);
        List parameters = annotatedMethod.getParameters();
        if (AnnotationUtil.hasAnnotation(anns, Produces.class)) {
            ProducerMethodBean<?> newComponent;
            for (AnnotatedParameter parameter : parameters) {
                Set<Annotation> paramAnnSet = parameter.getAnnotations();
                Annotation[] parameterAnns = paramAnnSet.toArray(new Annotation[parameter.getAnnotations().size()]);
                if (!AnnotationUtil.hasAnnotation(anns, Inject.class) && !AnnotationUtil.hasAnnotation(parameterAnns, Disposes.class) && !AnnotationUtil.hasAnnotation(parameterAnns, Observes.class)) continue;
                throw new WebBeansConfigurationException("Producer Method Bean with name : " + annotatedMethod.getJavaMember().getName() + " in bean class : " + clazz + " can not be annotated with @Initializer/@Destructor annotation " + "or has a parameter annotated with @Disposes/@Observes");
            }
            if (AnnotationUtil.hasAnnotation(anns, Specializes.class)) {
                if (Modifier.isStatic(annotatedMethod.getJavaMember().getModifiers())) {
                    throw new WebBeansConfigurationException("Specializing producer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + clazz.getName() + " can not be static");
                }
                isSpecializes = true;
            }
            if ((newComponent = this.createProducerBeanFromAnnotatedType(annotatedMethod.getJavaMember().getReturnType(), annotatedMethod, bean, isSpecializes)) != null) {
                producerComponents.add(newComponent);
                this.addMethodInjectionPointMetaData(newComponent, annotatedMethod.getJavaMember());
            }
        }
    }

    public <X> ProducerMethodBean<X> createProducerBeanFromAnnotatedType(Class<X> returnType, AnnotatedMethod<X> method, InjectionTargetBean<?> parent, boolean isSpecializes) {
        ProducerMethodBean<X> bean = new ProducerMethodBean<X>(parent, returnType);
        bean.setCreatorMethod(method.getJavaMember());
        if (isSpecializes) {
            WebBeansUtil.configureProducerSpecialization(bean, method.getJavaMember(), parent.getReturnType().getSuperclass());
        }
        if (returnType.isPrimitive()) {
            bean.setNullable(false);
        }
        Set<Annotation> annSet = method.getAnnotations();
        Annotation[] anns = annSet.toArray(new Annotation[annSet.size()]);
        this.defineSerializable(bean);
        DefinitionUtil.defineStereoTypes(bean, anns);
        DefinitionUtil.defineProducerMethodApiTypes(bean, method.getBaseType(), anns);
        DefinitionUtil.defineScopeType(bean, anns, "Bean producer method : " + method.getJavaMember().getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation", false);
        WebBeansUtil.checkProducerGenericType(bean, method.getJavaMember());
        this.defineQualifiers(bean, anns);
        this.defineName(bean, anns, WebBeansUtil.getProducerDefaultName(method.getJavaMember().getName()));
        return bean;
    }
}

