/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanCreator<T>
implements BeanCreator<T> {
    private final AbstractOwbBean<T> bean;
    private BeanCreator.MetaDataProvider metadataProvider = BeanCreator.MetaDataProvider.DEFAULT;
    private final Annotation[] beanAnnotations;
    private AnnotatedType<T> annotatedType;
    private final DefinitionUtil definitionUtil;

    public AbstractBeanCreator(AbstractOwbBean<T> bean, Annotation[] beanAnnotations) {
        this.bean = bean;
        this.beanAnnotations = beanAnnotations;
        this.definitionUtil = bean.getWebBeansContext().getDefinitionUtil();
    }

    @Override
    public void checkCreateConditions() {
    }

    @Override
    public void defineApiType() {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineApiTypes(this.bean, this.bean.getReturnType());
        } else {
            Set<Type> types = this.annotatedType.getTypeClosure();
            this.bean.getTypes().addAll(types);
        }
        Set<String> ignored = this.bean.getWebBeansContext().getOpenWebBeansConfiguration().getIgnoredInterfaces();
        Iterator<Type> i = this.bean.getTypes().iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (!(t instanceof Class) || !ignored.contains(((Class)t).getName())) continue;
            i.remove();
        }
    }

    @Override
    public void defineQualifier() {
        if (this.isDefaultMetaDataProvider()) {
            this.definitionUtil.defineQualifiers(this.bean, this.beanAnnotations);
        } else {
            this.definitionUtil.defineQualifiers(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()));
        }
    }

    @Override
    public void defineName(String defaultName) {
        if (this.isDefaultMetaDataProvider()) {
            this.definitionUtil.defineName(this.bean, this.beanAnnotations, defaultName);
        } else {
            this.definitionUtil.defineName(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()), WebBeansUtil.getManagedBeanDefaultName(this.annotatedType.getJavaClass().getSimpleName()));
        }
    }

    @Override
    public void defineScopeType(String errorMessage, boolean allowLazyInit) {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineScopeType(this.bean, this.beanAnnotations, errorMessage, allowLazyInit);
        } else {
            DefinitionUtil.defineScopeType(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()), errorMessage, false);
        }
    }

    @Override
    public void defineSerializable() {
        this.definitionUtil.defineSerializable(this.bean);
    }

    @Override
    public void defineStereoTypes() {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineStereoTypes(this.bean, this.beanAnnotations);
        } else {
            DefinitionUtil.defineStereoTypes(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()));
        }
    }

    @Override
    public BeanCreator.MetaDataProvider getMetaDataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetaDataProvider(BeanCreator.MetaDataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected boolean isDefaultMetaDataProvider() {
        return this.metadataProvider.equals((Object)BeanCreator.MetaDataProvider.DEFAULT);
    }

    @Override
    public AbstractOwbBean<T> getBean() {
        return this.bean;
    }

    protected AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    public void setAnnotatedType(AnnotatedType<T> annotatedType) {
        this.annotatedType = annotatedType;
    }
}

