/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import org.apache.webbeans.exception.inject.ExecutionException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansAnnotation
implements Annotation,
MethodHandler {
    private Class<? extends Annotation> annotationType = null;
    private Map<String, Object> annotationMembersValueMap = new HashMap<String, Object>();
    private Method[] members = null;

    public WebBeansAnnotation(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        this.members = SecurityUtil.doPrivilegedGetDeclaredMethods(annotationType);
        this.setDefaultValues();
    }

    @Override
    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws InvocationTargetException, IllegalAccessException {
        WebBeansAnnotation anno = (WebBeansAnnotation)self;
        if (this.hasMethod(m) && proceed == null) {
            return anno.getAnnotationMembersValueMap().get(m.getName());
        }
        return proceed.invoke(self, args);
    }

    public Map<String, Object> getAnnotationMembersValueMap() {
        return Collections.unmodifiableMap(this.annotationMembersValueMap);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public void setMemberValue(String memberName, Object memberValue) {
        Asserts.assertNotNull(memberName, "memberName parameter can not be null");
        Asserts.assertNotNull(memberValue, "memberValue parameter can not be null");
        this.annotationMembersValueMap.put(memberName, memberValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        for (int i = 0; i < this.members.length; ++i) {
            sb.append(this.members[i].getName()).append("=");
            sb.append(this.invoke(this.members[i]));
            if (i >= this.members.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Annotation) {
            Annotation that = (Annotation)other;
            if (this.annotationType().equals(that.annotationType())) {
                for (Method member : this.members) {
                    Object thatValue;
                    Object thisValue = this.invoke(member);
                    if (thisValue.equals(thatValue = WebBeansAnnotation.callMethod(member, that))) continue;
                    return false;
                }
                return true;
            }
        } else if (other instanceof WebBeansAnnotation) {
            WebBeansAnnotation that = (WebBeansAnnotation)other;
            if (this.annotationType().equals(that.annotationType())) {
                for (Method member : this.members) {
                    Object thatValue;
                    Object thisValue = this.invoke(member);
                    if (thisValue.equals(thatValue = that.invoke(member))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.members) {
            int hashCodeName = 127 * member.getName().hashCode();
            int hashCodeValue = this.invoke(member).hashCode();
            hashCode += hashCodeName ^ hashCodeValue;
        }
        return hashCode;
    }

    private Object invoke(Method method) {
        String memberName = method.getName();
        return this.annotationMembersValueMap.get(memberName);
    }

    private static Object callMethod(Method method, Object instance) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private boolean hasMethod(Method method) {
        for (Method m : this.members) {
            if (!m.equals(method)) continue;
            return true;
        }
        return false;
    }

    private void setDefaultValues() {
        for (Method m : this.members) {
            Object defValue = m.getDefaultValue();
            if (defValue == null) continue;
            this.annotationMembersValueMap.put(m.getName(), defValue);
        }
    }
}

