/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.AfterBegin;
import javax.ejb.AfterCompletion;
import javax.ejb.BeforeCompletion;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.interceptor.InvocationContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AroundTimeout;
import org.apache.openejb.jee.CallbackMethod;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.Invokable;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.Timer;
import org.apache.openejb.util.Join;
import org.apache.xbean.finder.ClassFinder;

public class CheckCallbacks
extends ValidationBase {
    @Override
    public void validate(EjbModule module) {
        for (EnterpriseBean enterpriseBean : module.getEjbJar().getEnterpriseBeans()) {
            Class ejbClass = null;
            try {
                ejbClass = this.loadClass(enterpriseBean.getEjbClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            if (enterpriseBean instanceof Invokable) {
                Invokable invokable = (Invokable)((Object)enterpriseBean);
                for (AroundInvoke aroundInvoke : invokable.getAroundInvoke()) {
                    this.checkAroundInvoke(ejbClass, aroundInvoke, enterpriseBean.getEjbName());
                }
                for (AroundTimeout aroundTimeout : invokable.getAroundTimeout()) {
                    this.checkAroundTimeout(ejbClass, aroundTimeout, enterpriseBean.getEjbName());
                }
            }
            for (LifecycleCallback callback : enterpriseBean.getPostConstruct()) {
                this.checkCallback(ejbClass, "PostConstruct", callback, enterpriseBean, new Class[0]);
            }
            for (LifecycleCallback callback : enterpriseBean.getPreDestroy()) {
                this.checkCallback(ejbClass, "PreDestroy", callback, enterpriseBean, new Class[0]);
            }
            ClassFinder finder = new ClassFinder(ejbClass);
            if (enterpriseBean instanceof Session) {
                org.apache.openejb.jee.SessionBean session = (org.apache.openejb.jee.SessionBean)enterpriseBean;
                if (session.getSessionType() == SessionType.STATEFUL) {
                    for (LifecycleCallback lifecycleCallback : session.getPrePassivate()) {
                        this.checkCallback(ejbClass, "PrePassivate", lifecycleCallback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback lifecycleCallback : session.getPostActivate()) {
                        this.checkCallback(ejbClass, "PostActivate", lifecycleCallback, enterpriseBean, new Class[0]);
                    }
                    this.checkSessionSynchronization(ejbClass, session);
                    for (LifecycleCallback lifecycleCallback : session.getAfterBegin()) {
                        this.checkCallback(ejbClass, "AfterBegin", lifecycleCallback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback lifecycleCallback : session.getBeforeCompletion()) {
                        this.checkCallback(ejbClass, "BeforeCompletion", lifecycleCallback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback lifecycleCallback : session.getAfterCompletion()) {
                        this.checkCallback(ejbClass, "AfterCompletion", lifecycleCallback, enterpriseBean, Boolean.TYPE);
                    }
                    for (AroundTimeout aroundTimeout : session.getAroundTimeout()) {
                        this.ignoredMethodAnnotation("AroundTimeout", enterpriseBean, enterpriseBean.getEjbClass(), aroundTimeout.getMethodName(), SessionType.STATEFUL.getName());
                    }
                    for (Timer timer : session.getTimer()) {
                        this.ignoredMethodAnnotation("Schedule/Schedules", enterpriseBean, enterpriseBean.getEjbClass(), timer.getTimeoutMethod().getMethodName(), SessionType.STATEFUL.getName());
                    }
                    continue;
                }
                for (LifecycleCallback lifecycleCallback : session.getAfterBegin()) {
                    this.ignoredMethodAnnotation("AfterBegin", enterpriseBean, enterpriseBean.getEjbClass(), lifecycleCallback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback lifecycleCallback : session.getBeforeCompletion()) {
                    this.ignoredMethodAnnotation("BeforeCompletion", enterpriseBean, enterpriseBean.getEjbClass(), lifecycleCallback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback lifecycleCallback : session.getAfterCompletion()) {
                    this.ignoredMethodAnnotation("AfterCompletion", enterpriseBean, enterpriseBean.getEjbClass(), lifecycleCallback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback lifecycleCallback : session.getPrePassivate()) {
                    this.ignoredMethodAnnotation("PrePassivate", enterpriseBean, enterpriseBean.getEjbClass(), lifecycleCallback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback lifecycleCallback : session.getPostActivate()) {
                    this.ignoredMethodAnnotation("PostActivate", enterpriseBean, enterpriseBean.getEjbClass(), lifecycleCallback.getMethodName(), session.getSessionType().getName());
                }
                for (RemoveMethod removeMethod : session.getRemoveMethod()) {
                    this.ignoredMethodAnnotation("Remove", enterpriseBean, enterpriseBean.getEjbClass(), removeMethod.getBeanMethod().getMethodName(), session.getSessionType().getName());
                }
                for (InitMethod initMethod : session.getInitMethod()) {
                    this.ignoredMethodAnnotation("Init", enterpriseBean, enterpriseBean.getEjbClass(), initMethod.getBeanMethod().getMethodName(), session.getSessionType().getName());
                }
                continue;
            }
            for (Method method : finder.findAnnotatedMethods(PrePassivate.class)) {
                this.ignoredMethodAnnotation("PrePassivate", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(PostActivate.class)) {
                this.ignoredMethodAnnotation("PostActivate", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(Remove.class)) {
                this.ignoredMethodAnnotation("Remove", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(Init.class)) {
                this.ignoredMethodAnnotation("Init", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(AfterBegin.class)) {
                this.ignoredMethodAnnotation("AfterBegin", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(BeforeCompletion.class)) {
                this.ignoredMethodAnnotation("BeforeCompletion", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(AfterCompletion.class)) {
                this.ignoredMethodAnnotation("AfterCompletion", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
        }
        for (JndiConsumer jndiConsumer : module.getEjbJar().getInterceptors()) {
            Class interceptorClass = null;
            try {
                interceptorClass = this.loadClass(((Interceptor)jndiConsumer).getInterceptorClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            for (AroundInvoke aroundInvoke : ((Interceptor)jndiConsumer).getAroundInvoke()) {
                this.checkAroundInvoke(interceptorClass, aroundInvoke, "Interceptor");
            }
            for (AroundTimeout aroundTimeout : ((Interceptor)jndiConsumer).getAroundTimeout()) {
                this.checkAroundTimeout(interceptorClass, aroundTimeout, "Interceptor");
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getPostConstruct()) {
                this.checkCallback(interceptorClass, "PostConstruct", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getPreDestroy()) {
                this.checkCallback(interceptorClass, "PreDestroy", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getPrePassivate()) {
                this.checkCallback(interceptorClass, "PrePassivate", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getPostActivate()) {
                this.checkCallback(interceptorClass, "PostActivate", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getAfterBegin()) {
                this.checkCallback(interceptorClass, "AfterBegin", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getBeforeCompletion()) {
                this.checkCallback(interceptorClass, "BeforeCompletion", callback, (Interceptor)jndiConsumer);
            }
            for (LifecycleCallback callback : ((Interceptor)jndiConsumer).getAfterCompletion()) {
                this.checkCallback(interceptorClass, "AfterCompletion", callback, (Interceptor)jndiConsumer);
            }
        }
    }

    private void checkAroundTypeInvoke(String aroundType, Class ejbClass, String declaringClassName, String declaringMethodName, String componentName) {
        try {
            Class declaringClass = null;
            try {
                declaringClass = declaringClassName == null ? ejbClass : this.loadClass(declaringClassName);
            }
            catch (OpenEJBException e) {
                this.fail(componentName, "missing.class", declaringClassName, aroundType, ejbClass.getName());
                return;
            }
            Method method = this.getMethod(declaringClass, declaringMethodName, InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Object.class)) {
                this.fail(componentName, "aroundInvoke.badReturnType", aroundType, declaringMethodName, returnType.getName(), declaringClassName);
            }
            boolean throwsException = false;
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (!exceptionType.getName().equals(Exception.class.getName())) continue;
                throwsException = true;
            }
            if (!throwsException) {
                this.fail(componentName, "aroundInvoke.mustThrowException", aroundType, declaringMethodName, declaringClassName);
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, declaringMethodName);
            if (possibleMethods.size() == 0) {
                this.fail(componentName, "aroundInvoke.missing", aroundType, declaringMethodName, declaringClassName);
            }
            if (possibleMethods.size() == 1) {
                this.fail(componentName, "aroundInvoke.invalidArguments", aroundType, declaringMethodName, this.getParameters(possibleMethods.get(0)), declaringClassName);
                Class<?> returnType = possibleMethods.get(0).getReturnType();
                if (!returnType.equals(Object.class)) {
                    this.fail(componentName, "aroundInvoke.badReturnType", aroundType, declaringMethodName, returnType.getName(), declaringClassName);
                }
            }
            this.fail(componentName, "aroundInvoke.missing.possibleTypo", aroundType, declaringMethodName, possibleMethods.size(), declaringClassName);
        }
    }

    private void checkAroundInvoke(Class<?> ejbClass, AroundInvoke aroundInvoke, String componentName) {
        this.checkAroundTypeInvoke("AroundInvoke", ejbClass, aroundInvoke.getClassName(), aroundInvoke.getMethodName(), componentName);
    }

    private void checkAroundTimeout(Class<?> ejbClass, AroundTimeout aroundTimeout, String componentName) {
        this.checkAroundTypeInvoke("AroundTimeout", ejbClass, aroundTimeout.getClassName(), aroundTimeout.getMethodName(), componentName);
    }

    private void checkCallback(Class<?> ejbClass, String type, CallbackMethod callback, EnterpriseBean bean, Class ... parameterTypes) {
        try {
            int methodModifiers;
            Class<?> returnType;
            Class delcaringClass = null;
            try {
                delcaringClass = callback.getClassName() == null ? ejbClass : this.loadClass(callback.getClassName());
            }
            catch (OpenEJBException e) {
                this.fail(type, "missing.class", callback.getClassName(), type, bean.getEjbName());
                return;
            }
            Method method = this.getMethod(delcaringClass, callback.getMethodName(), parameterTypes);
            if (this.implementsSessionBean(delcaringClass)) {
                org.apache.openejb.jee.SessionBean sb = (org.apache.openejb.jee.SessionBean)bean;
                if ("PreDestroy".equals(type)) {
                    if (!callback.getMethodName().equals("ejbRemove")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PostActivate".equals(type)) {
                    if (!callback.getMethodName().equals("ejbActivate")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PrePassivate".equals(type)) {
                    if (!callback.getMethodName().equals("ejbPassivate")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PostConstruct".equals(type) && !callback.getMethodName().equals("ejbCreate")) {
                    this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                }
            }
            if (!(returnType = method.getReturnType()).equals(Void.TYPE)) {
                this.fail(bean, "callback.badReturnType", type, callback.getMethodName(), returnType.getName(), callback.getClassName());
            }
            if (Modifier.isFinal(methodModifiers = method.getModifiers()) || Modifier.isStatic(methodModifiers)) {
                this.fail(bean, "callback.badModifier", type, callback.getMethodName(), callback.getClassName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(bean, "callback.missing", type, callback.getMethodName(), callback.getClassName());
            }
            if (possibleMethods.size() == 1) {
                this.fail(bean, "callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), callback.getClassName(), this.getParameters(parameterTypes));
            }
            this.fail(bean, "callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), callback.getClassName(), this.getParameters(parameterTypes));
        }
    }

    private boolean implementsSessionBean(Class<?> ejbClass) {
        Class<?>[] interfaces;
        for (Class<?> interfce : interfaces = ejbClass.getInterfaces()) {
            if (!interfce.equals(SessionBean.class)) continue;
            return true;
        }
        return false;
    }

    private void checkCallback(Class interceptorClass, String type, CallbackMethod callback, Interceptor interceptor) {
        try {
            Class delcaringClass = null;
            try {
                delcaringClass = callback.getClassName() == null ? interceptorClass : this.loadClass(callback.getClassName());
            }
            catch (OpenEJBException e) {
                this.fail(type, "missing.class", callback.getClassName(), type, interceptor.getInterceptorClass());
                return;
            }
            Method method = this.getMethod(delcaringClass, callback.getMethodName(), InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                this.fail("Interceptor", "interceptor.callback.badReturnType", interceptorClass, type, callback.getMethodName(), returnType.getName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(interceptorClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail("Interceptor", "interceptor.callback.missing", type, callback.getMethodName(), interceptorClass.getName());
            }
            if (possibleMethods.size() == 1) {
                this.fail("Interceptor", "interceptor.callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), interceptorClass.getName());
                Class<?> returnType = possibleMethods.get(0).getReturnType();
                if (!returnType.equals(Void.TYPE)) {
                    this.fail("Interceptor", "interceptor.callback.badReturnType", interceptorClass, type, callback.getMethodName(), returnType.getName());
                }
            }
            this.fail("Interceptor", "interceptor.callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), interceptorClass.getName());
        }
    }

    private void checkSessionSynchronization(Class ejbClass, org.apache.openejb.jee.SessionBean bean) {
        if (SessionSynchronization.class.isAssignableFrom(ejbClass)) {
            if (bean.getAfterBeginMethod() != null || bean.getBeforeCompletionMethod() != null || bean.getAfterCompletionMethod() != null) {
                this.fail(bean, "callback.sessionSynchronization.invalidUse", ejbClass.getName());
            } else {
                ClassFinder classFinder = new ClassFinder(ejbClass);
                if (classFinder.findAnnotatedMethods(AfterBegin.class).size() > 0 || classFinder.findAnnotatedMethods(BeforeCompletion.class).size() > 0 || classFinder.findAnnotatedMethods(AfterCompletion.class).size() > 0) {
                    this.fail(bean, "callback.sessionSynchronization.invalidUse", ejbClass.getName());
                }
            }
        }
    }

    private void checkTimeOut(Class<?> ejbClass, NamedMethod timeout, EnterpriseBean bean) {
        if (timeout == null) {
            return;
        }
        try {
            Class<?> returnType;
            Class[] parameterClasses;
            if (timeout.getMethodParams() == null) {
                parameterClasses = new Class[]{};
            } else {
                List<String> methodParams = timeout.getMethodParams().getMethodParam();
                parameterClasses = new Class[methodParams.size()];
                for (int i = 0; i < methodParams.size(); ++i) {
                    parameterClasses[i] = this.loadClass(methodParams.get(i));
                }
            }
            Method method = this.getMethod(ejbClass, timeout.getMethodName(), parameterClasses);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 0 && (parameterTypes.length != 1 || parameterTypes[0] != javax.ejb.Timer.class)) {
                this.fail(bean, "timeout.invalidArguments", timeout.getMethodName(), Join.join(",", Join.CLASS_CALLBACK, parameterClasses));
            }
            if (!(returnType = method.getReturnType()).equals(Void.TYPE)) {
                this.fail(bean, "timeout.badReturnType", timeout.getMethodName(), returnType.getName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, timeout.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(bean, "timeout.missing", timeout.getMethodName());
            } else {
                this.fail(bean, "timeout.missing.possibleTypo", timeout.getMethodName(), possibleMethods.size());
            }
        }
        catch (OpenEJBException e) {
            // empty catch block
        }
    }

    private Method getMethod(Class clazz, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }

    private List<Method> getMethods(Class clazz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }
}

