/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.ServiceRef;

public class GeronimoMappedName
implements DynamicDeployer {
    private static final String MAPPED_NAME_PREFIX = "jndi:java:comp/geronimo/env/";

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        this.mapReferences(appModule);
        return appModule;
    }

    private void mapReferences(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.mapReferences(ejbModule.getEjbJar());
        }
    }

    private void mapReferences(EjbJar ejbJar) {
        if (ejbJar == null) {
            return;
        }
        for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            String refName;
            for (EjbRef ejbRef : enterpriseBean.getEjbRef()) {
                String mappedName = ejbRef.getMappedName();
                if (mappedName != null && (mappedName.startsWith("jndi:corbaloc") || mappedName.startsWith("jndi:corbaname"))) {
                    String refName2 = ejbRef.getEjbRefName();
                    ejbRef.setMappedName(MAPPED_NAME_PREFIX + refName2);
                }
                if (null != mappedName || !ejbRef.getEjbRefName().equals("ejb/MEJB")) continue;
                ejbRef.setMappedName("mejb/ejb/mgmt/MEJB");
            }
            for (MessageDestinationRef messageDestinationRef : enterpriseBean.getMessageDestinationRef()) {
                refName = messageDestinationRef.getMessageDestinationRefName();
                messageDestinationRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (PersistenceContextRef persistenceContextRef : enterpriseBean.getPersistenceContextRef()) {
                refName = persistenceContextRef.getPersistenceContextRefName();
                persistenceContextRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (PersistenceUnitRef persistenceUnitRef : enterpriseBean.getPersistenceUnitRef()) {
                refName = persistenceUnitRef.getPersistenceUnitRefName();
                persistenceUnitRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (ResourceRef resourceRef : enterpriseBean.getResourceRef()) {
                refName = resourceRef.getResRefName();
                resourceRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (ResourceEnvRef resourceEnvRef : enterpriseBean.getResourceEnvRef()) {
                refName = resourceEnvRef.getResourceEnvRefName();
                resourceEnvRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (ServiceRef serviceRef : enterpriseBean.getServiceRef()) {
                refName = serviceRef.getServiceRefName();
                serviceRef.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
        }
    }
}

