/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.config.AggregatedArchive;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.Module;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AnnotationFinder;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.UrlCache;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.JarArchive;
import org.xml.sax.SAXException;

public class DeploymentLoader
implements DeploymentFilterable {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OPENEJB_READ_ALL_PERSISTENCE_XML = "openejb.read-all.persistence.xml";
    private static final String OPENEJB_ALTDD_PREFIX = "openejb.altdd.prefix";
    private static final String ddDir = "META-INF/";
    private boolean scanManagedBeans = true;

    public AppModule load(File jarFile) throws OpenEJBException {
        Class<? extends DeploymentModule> moduleClass;
        block41: {
            AppModule appModule;
            File tmpFile;
            block42: {
                String jarLocation;
                URLClassLoader doNotUseClassLoader;
                URL baseUrl;
                String jarPath;
                block39: {
                    AppModule appModule2;
                    block40: {
                        Map<String, URL> otherDD;
                        block37: {
                            AppModule o22;
                            block38: {
                                block35: {
                                    AppModule o22;
                                    block36: {
                                        block33: {
                                            AppModule appModule3;
                                            block34: {
                                                block31: {
                                                    AppModule e4;
                                                    block32: {
                                                        try {
                                                            jarPath = jarFile.getCanonicalPath();
                                                        }
                                                        catch (IOException e2) {
                                                            throw new OpenEJBException("Invalid application file path " + jarFile, e2);
                                                        }
                                                        baseUrl = DeploymentLoader.getFileUrl(jarFile);
                                                        doNotUseClassLoader = null;
                                                        tmpFile = null;
                                                        try {
                                                            try {
                                                                URL tempURL = baseUrl;
                                                                if (jarFile.isFile() && UrlCache.cacheDir != null && !jarFile.getName().endsWith(".ear") && !jarFile.getName().endsWith(".war") && !jarFile.getName().endsWith(".rar")) {
                                                                    try {
                                                                        tmpFile = File.createTempFile("AppModule-", "", UrlCache.cacheDir);
                                                                        JarExtractor.copy(URLs.toFile(baseUrl), tmpFile);
                                                                        tempURL = tmpFile.toURI().toURL();
                                                                        doNotUseClassLoader = ClassLoaderUtil.createClassLoader(tmpFile.getCanonicalPath(), new URL[]{baseUrl}, this.getOpenEJBClassLoader(baseUrl));
                                                                    }
                                                                    catch (Exception e3) {
                                                                        throw new OpenEJBException(e3);
                                                                    }
                                                                } else {
                                                                    doNotUseClassLoader = ClassLoaderUtil.createClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader(baseUrl));
                                                                }
                                                                moduleClass = this.discoverModuleType(tempURL, (ClassLoader)ClassLoaderUtil.createTempClassLoader(doNotUseClassLoader), true);
                                                            }
                                                            catch (Exception e4) {
                                                                throw new UnknownModuleTypeException("Unable to determine module type for jar: " + baseUrl.toExternalForm(), e4);
                                                            }
                                                            finally {
                                                                if (tmpFile != null && !tmpFile.delete()) {
                                                                    tmpFile.deleteOnExit();
                                                                }
                                                            }
                                                            if (!AppModule.class.equals(moduleClass)) break block31;
                                                            e4 = this.createAppModule(jarFile, jarPath);
                                                            if (null == doNotUseClassLoader) break block32;
                                                        }
                                                        catch (Throwable throwable) {
                                                            if (null != doNotUseClassLoader) {
                                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                                doNotUseClassLoader = null;
                                                                System.gc();
                                                            }
                                                            if (tmpFile != null && !tmpFile.delete()) {
                                                                tmpFile.deleteOnExit();
                                                            }
                                                            throw throwable;
                                                        }
                                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                        doNotUseClassLoader = null;
                                                        System.gc();
                                                    }
                                                    if (tmpFile != null && !tmpFile.delete()) {
                                                        tmpFile.deleteOnExit();
                                                    }
                                                    return e4;
                                                }
                                                if (!EjbModule.class.equals(moduleClass)) break block33;
                                                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader(baseUrl));
                                                Class<EjbModule> o22 = EjbModule.class;
                                                EjbModule ejbModule = this.createEjbModule(baseUrl, jarPath, classLoader, this.getModuleId(jarFile));
                                                AppModule appModule4 = new AppModule(ejbModule);
                                                DeploymentLoader.addPersistenceUnits(appModule4, baseUrl);
                                                appModule3 = appModule4;
                                                if (null == doNotUseClassLoader) break block34;
                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                doNotUseClassLoader = null;
                                                System.gc();
                                            }
                                            if (tmpFile != null && !tmpFile.delete()) {
                                                tmpFile.deleteOnExit();
                                            }
                                            return appModule3;
                                        }
                                        if (!ClientModule.class.equals(moduleClass)) break block35;
                                        jarLocation = URLs.toFilePath(baseUrl);
                                        ClientModule clientModule = this.createClientModule(baseUrl, jarLocation, this.getOpenEJBClassLoader(baseUrl), this.getModuleId(jarFile));
                                        o22 = new AppModule(clientModule);
                                        if (null == doNotUseClassLoader) break block36;
                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                        doNotUseClassLoader = null;
                                        System.gc();
                                    }
                                    if (tmpFile != null && !tmpFile.delete()) {
                                        tmpFile.deleteOnExit();
                                    }
                                    return o22;
                                }
                                if (!ConnectorModule.class.equals(moduleClass)) break block37;
                                jarLocation = URLs.toFilePath(baseUrl);
                                ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, this.getOpenEJBClassLoader(baseUrl), this.getModuleId(jarFile));
                                o22 = new AppModule(connectorModule);
                                if (null == doNotUseClassLoader) break block38;
                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                doNotUseClassLoader = null;
                                System.gc();
                            }
                            if (tmpFile != null && !tmpFile.delete()) {
                                tmpFile.deleteOnExit();
                            }
                            return o22;
                        }
                        if (!WebModule.class.equals(moduleClass)) break block39;
                        File file = URLs.toFile(baseUrl);
                        AppModule appModule5 = new AppModule(this.getOpenEJBClassLoader(baseUrl), file.getAbsolutePath(), new Application(), true);
                        this.addWebModule(appModule5, baseUrl, this.getOpenEJBClassLoader(baseUrl), this.getContextRoot(), this.getModuleName());
                        if (Boolean.getBoolean(OPENEJB_READ_ALL_PERSISTENCE_XML)) {
                            WebModule webModule = appModule5.getWebModules().iterator().next();
                            List<URL> urls = webModule.getScannableUrls();
                            ResourceFinder finder = new ResourceFinder("", urls.toArray(new URL[urls.size()]));
                            otherDD = DeploymentLoader.getDescriptors(finder, false);
                        } else {
                            otherDD = new HashMap<String, URL>();
                        }
                        this.addWebPersistenceDD("persistence.xml", file, baseUrl, otherDD, appModule5);
                        this.addWebPersistenceDD("persistence-fragment.xml", file, baseUrl, otherDD, appModule5);
                        DeploymentLoader.addPersistenceUnits(appModule5, baseUrl);
                        appModule2 = appModule5;
                        if (null == doNotUseClassLoader) break block40;
                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                        doNotUseClassLoader = null;
                        System.gc();
                    }
                    if (tmpFile != null && !tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                    return appModule2;
                }
                if (!PersistenceModule.class.equals(moduleClass)) break block41;
                jarLocation = URLs.toFilePath(baseUrl);
                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader(baseUrl));
                AppModule appModule6 = new AppModule(classLoader, jarLocation);
                DeploymentLoader.addPersistenceUnits(appModule6, baseUrl);
                appModule = appModule6;
                if (null == doNotUseClassLoader) break block42;
                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                doNotUseClassLoader = null;
                System.gc();
            }
            if (tmpFile != null && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            return appModule;
        }
        throw new UnsupportedModuleTypeException("Unsupported module type: " + moduleClass.getSimpleName());
    }

    private void addWebPersistenceDD(String name, File file, URL baseUrl, Map<String, URL> otherDD, AppModule appModule) {
        URL persistenceUrl;
        block18: {
            persistenceUrl = null;
            if (file.isDirectory()) {
                File persistenceXml = new File(file, "WEB-INF/classes/META-INF/" + name);
                if (persistenceXml.exists() && persistenceXml.isFile()) {
                    try {
                        persistenceUrl = persistenceXml.toURI().toURL();
                    }
                    catch (MalformedURLException e) {}
                }
            } else {
                try {
                    JarFile jf = new JarFile(file);
                    ZipEntry entry = jf.getEntry("WEB-INF/classes/META-INF/" + name);
                    if (entry == null) break block18;
                    String base = baseUrl.toString();
                    if (!base.startsWith("jar:")) {
                        base = "jar:" + base;
                        try {
                            baseUrl = new URL(base + "!/WEB-INF/classes");
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    try {
                        persistenceUrl = new URL(base + "!/WEB-INF/classes/META-INF/" + name);
                    }
                    catch (MalformedURLException e) {}
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (persistenceUrl != null || otherDD.containsKey(name)) {
            URL otherUrl;
            ArrayList<URL> persistenceUrls = (ArrayList<URL>)appModule.getAltDDs().get(name);
            if (persistenceUrls == null) {
                persistenceUrls = new ArrayList<URL>();
                appModule.getAltDDs().put(name, persistenceUrls);
            }
            if (persistenceUrl != null) {
                try {
                    persistenceUrls.add(persistenceUrl);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (otherDD.containsKey(name) && !persistenceUrls.contains(otherUrl = otherDD.get(name))) {
                persistenceUrls.add(otherDD.get(name));
            }
        }
    }

    protected ClassLoader getOpenEJBClassLoader(URL url) {
        return OpenEJB.class.getClassLoader();
    }

    private String getModuleId(File file) {
        String filename = file.getName();
        return System.getProperty(filename + ".moduleId");
    }

    protected AppModule createAppModule(File jarFile, String jarPath) throws OpenEJBException {
        File appDir = DeploymentLoader.unpack(jarFile);
        try {
            appDir = appDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new OpenEJBException("Invalid application directory " + appDir.getAbsolutePath());
        }
        URL appUrl = DeploymentLoader.getFileUrl(appDir);
        String appId = appDir.getAbsolutePath();
        URLClassLoader tmpClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{appUrl}, this.getOpenEJBClassLoader(appUrl));
        ResourceFinder finder = new ResourceFinder("", tmpClassLoader, appUrl);
        Map<String, URL> appDescriptors = DeploymentLoader.getDescriptors(finder);
        try {
            String absolutePath;
            Map<String, URL> libs;
            Application application;
            HashMap<String, URL> ejbModules = new HashMap<String, URL>();
            HashMap<String, URL> clientModules = new HashMap<String, URL>();
            HashMap<String, URL> resouceModules = new HashMap<String, URL>();
            HashMap<String, URL> webModules = new HashMap<String, URL>();
            HashMap<String, String> webContextRoots = new HashMap<String, String>();
            URL applicationXmlUrl = appDescriptors.get("application.xml");
            if (applicationXmlUrl != null) {
                application = DeploymentLoader.unmarshal(Application.class, "application.xml", applicationXmlUrl);
                for (Module module : application.getModule()) {
                    try {
                        URL url;
                        if (module.getEjb() != null) {
                            url = finder.find(module.getEjb().trim());
                            ejbModules.put(module.getEjb(), url);
                            continue;
                        }
                        if (module.getJava() != null) {
                            url = finder.find(module.getJava().trim());
                            clientModules.put(module.getConnector(), url);
                            continue;
                        }
                        if (module.getConnector() != null) {
                            url = finder.find(module.getConnector().trim());
                            resouceModules.put(module.getConnector(), url);
                            continue;
                        }
                        if (module.getWeb() == null) continue;
                        url = finder.find(module.getWeb().getWebUri().trim());
                        webModules.put(module.getWeb().getWebUri(), url);
                        webContextRoots.put(module.getWeb().getWebUri(), module.getWeb().getContextRoot());
                    }
                    catch (IOException e) {
                        throw new OpenEJBException("Invalid path to module " + e.getMessage(), e);
                    }
                }
            } else {
                application = new Application();
                HashMap<String, URL> files = new HashMap<String, URL>();
                DeploymentLoader.scanDir(appDir, files, "");
                files.remove("META-INF/MANIFEST.MF");
                for (Map.Entry<String, URL> entry : files.entrySet()) {
                    if (entry.getKey().startsWith("lib/") || !entry.getKey().matches(".*\\.(jar|war|rar|ear)")) continue;
                    try {
                        URLClassLoader uRLClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{entry.getValue()}, tmpClassLoader);
                        Class<? extends DeploymentModule> moduleType = this.discoverModuleType(entry.getValue(), (ClassLoader)uRLClassLoader, true);
                        if (EjbModule.class.equals(moduleType)) {
                            ejbModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ClientModule.class.equals(moduleType)) {
                            clientModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ConnectorModule.class.equals(moduleType)) {
                            resouceModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!WebModule.class.equals(moduleType)) continue;
                        webModules.put(entry.getKey(), entry.getValue());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (Exception exception) {
                        throw new OpenEJBException("Unable to determine the module type of " + entry.getKey() + ": Exception: " + exception.getMessage(), exception);
                    }
                }
            }
            if (application.getLibraryDirectory() == null) {
                application.setLibraryDirectory("lib/");
            } else {
                String dir = application.getLibraryDirectory();
                if (!dir.endsWith("/")) {
                    application.setLibraryDirectory(dir + "/");
                }
            }
            ArrayList<URL> extraLibs = new ArrayList<URL>();
            try {
                libs = finder.getResourcesMap(application.getLibraryDirectory());
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from '" + application.getLibraryDirectory() + "' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("APP-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'APP-INF/lib/' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("META-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'META-INF/lib/' : " + e.getMessage(), e);
            }
            HashMap<String, URL> rarLibs = new HashMap<String, URL>();
            for (Map.Entry entry : resouceModules.entrySet()) {
                try {
                    File rarFile = URLs.toFile((URL)entry.getValue());
                    rarFile = DeploymentLoader.unpack(rarFile);
                    entry.setValue(rarFile.toURI().toURL());
                    DeploymentLoader.scanDir(appDir, rarLibs, "");
                }
                catch (MalformedURLException e) {
                    throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
                }
            }
            Iterator iterator = rarLibs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).endsWith(".jar")) continue;
                iterator.remove();
            }
            ArrayList<Object> classPath = new ArrayList<Object>();
            classPath.addAll(ejbModules.values());
            classPath.addAll(clientModules.values());
            classPath.addAll(rarLibs.values());
            classPath.addAll(extraLibs);
            URL[] uRLArray = classPath.toArray(new URL[classPath.size()]);
            URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, uRLArray, this.getOpenEJBClassLoader(appUrl));
            AppModule appModule = new AppModule(appClassLoader, appId, application, false);
            appModule.getAdditionalLibraries().addAll(extraLibs);
            appModule.getAltDDs().putAll(appDescriptors);
            appModule.getWatchedResources().add(appId);
            if (applicationXmlUrl != null) {
                appModule.getWatchedResources().add(URLs.toFilePath(applicationXmlUrl));
            }
            for (String moduleName : ejbModules.keySet()) {
                try {
                    URL ejbUrl = (URL)ejbModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), ejbUrl)) {
                        try {
                            ejbUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), ejbUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File ejbFile = URLs.toFile(ejbUrl);
                    absolutePath = ejbFile.getAbsolutePath();
                    EjbModule ejbModule = this.createEjbModule(ejbUrl, absolutePath, appClassLoader, moduleName);
                    appModule.getEjbModules().add(ejbModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load EJBs from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : clientModules.keySet()) {
                try {
                    URL clientUrl = (URL)clientModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), clientUrl)) {
                        try {
                            clientUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), clientUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File clientFile = URLs.toFile(clientUrl);
                    absolutePath = clientFile.getAbsolutePath();
                    ClientModule clientModule = this.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName);
                    appModule.getClientModules().add(clientModule);
                }
                catch (Exception e) {
                    logger.error("Unable to load App Client from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : resouceModules.keySet()) {
                try {
                    URL rarUrl = (URL)resouceModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), rarUrl)) {
                        try {
                            rarUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), rarUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(appId, URLs.toFilePath(rarUrl), appClassLoader, moduleName);
                    appModule.getConnectorModules().add(connectorModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load RAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : webModules.keySet()) {
                try {
                    URL warUrl = (URL)webModules.get(moduleName);
                    this.addWebModule(appModule, warUrl, appClassLoader, (String)webContextRoots.get(moduleName), moduleName);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load WAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            this.addBeansXmls(appModule);
            Properties p = new Properties();
            p.put(appModule.getModuleId(), appModule.getJarLocation());
            FileUtils base = new FileUtils(appModule.getModuleId(), appModule.getModuleId(), p);
            ArrayList<URL> filteredUrls = new ArrayList<URL>();
            DeploymentsResolver.loadFromClasspath(base, filteredUrls, appModule.getClassLoader());
            DeploymentLoader.addPersistenceUnits(appModule, filteredUrls.toArray(new URL[filteredUrls.size()]));
            return appModule;
        }
        catch (OpenEJBException e) {
            logger.error("Unable to load EAR: " + jarPath, e);
            throw e;
        }
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName) throws OpenEJBException {
        return this.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName, true);
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName, boolean log) throws OpenEJBException {
        ResourceFinder clientFinder = new ResourceFinder(clientUrl);
        URL manifestUrl = null;
        try {
            manifestUrl = clientFinder.find("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            // empty catch block
        }
        String mainClass = null;
        if (manifestUrl != null) {
            try {
                InputStream is = manifestUrl.openStream();
                Manifest manifest = new Manifest(is);
                mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            catch (IOException e) {
                throw new OpenEJBException("Unable to determine Main-Class defined in META-INF/MANIFEST.MF file", e);
            }
        }
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(clientFinder, log);
        ApplicationClient applicationClient = null;
        URL clientXmlUrl = descriptors.get("application-client.xml");
        if (clientXmlUrl != null) {
            applicationClient = ReadDescriptors.readApplicationClient(clientXmlUrl);
        }
        ClientModule clientModule = new ClientModule(applicationClient, appClassLoader, absolutePath, mainClass, moduleName);
        clientModule.getAltDDs().putAll(descriptors);
        if (absolutePath != null) {
            clientModule.getWatchedResources().add(absolutePath);
        }
        if (clientXmlUrl != null && "file".equals(clientXmlUrl.getProtocol())) {
            clientModule.getWatchedResources().add(URLs.toFilePath(clientXmlUrl));
        }
        return clientModule;
    }

    protected EjbModule createEjbModule(URL baseUrl, String jarPath, ClassLoader classLoader, String moduleId) throws OpenEJBException {
        Map<String, URL> descriptors;
        if (baseUrl != null) {
            descriptors = DeploymentLoader.getDescriptors(baseUrl);
        } else {
            try {
                descriptors = this.getDescriptors(classLoader, null);
            }
            catch (IOException e) {
                descriptors = new HashMap<String, URL>();
            }
        }
        EjbJar ejbJar = null;
        URL ejbJarXmlUrl = descriptors.get("ejb-jar.xml");
        if (ejbJarXmlUrl != null) {
            ejbJar = ReadDescriptors.readEjbJar(ejbJarXmlUrl);
        }
        EjbModule ejbModule = new EjbModule(classLoader, moduleId, jarPath, ejbJar, null);
        ejbModule.getAltDDs().putAll(descriptors);
        if (jarPath != null) {
            ejbModule.getWatchedResources().add(jarPath);
        }
        if (ejbJarXmlUrl != null && "file".equals(ejbJarXmlUrl.getProtocol())) {
            ejbModule.getWatchedResources().add(URLs.toFilePath(ejbJarXmlUrl));
        }
        ejbModule.setClientModule(this.createClientModule(baseUrl, jarPath, classLoader, null, false));
        this.addWebservices(ejbModule);
        return ejbModule;
    }

    protected void addWebModule(AppModule appModule, URL warUrl, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        Object o;
        ArrayList<URL> persistenceXmls;
        String warPath = URLs.toFilePath(warUrl);
        WebModule webModule = this.createWebModule(appModule.getJarLocation(), warPath, parentClassLoader, contextRoot, moduleName);
        appModule.getWebModules().add(webModule);
        if (appModule.isStandaloneModule()) {
            appModule.getAdditionalLibraries().addAll(webModule.getUrls());
        }
        if ((persistenceXmls = (ArrayList<URL>)appModule.getAltDDs().get("persistence.xml")) == null) {
            persistenceXmls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence.xml", persistenceXmls);
        }
        if ((o = webModule.getAltDDs().get("persistence.xml")) instanceof URL) {
            URL url = (URL)o;
            persistenceXmls.add(url);
        }
        if (o instanceof List) {
            List urls = (List)o;
            persistenceXmls.addAll(urls);
        }
        EjbModule webEjbModule = new EjbModule(webModule.getClassLoader(), webModule.getModuleId(), webModule.getJarLocation(), null, null);
        webEjbModule.getAltDDs().putAll(webModule.getAltDDs());
        appModule.getEjbModules().add(webEjbModule);
        try {
            IAnnotationFinder finder = FinderFactory.createFinder(webModule);
            webModule.setFinder(finder);
            webEjbModule.setFinder(finder);
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create annotation scanner for web module " + webModule.getModuleId(), e);
        }
        this.addWebservices(webEjbModule);
    }

    private Properties getContextParams(List<ParamValue> contextParam) {
        Properties properties = new Properties();
        for (ParamValue paramValue : contextParam) {
            properties.put(paramValue.getParamName(), paramValue.getParamValue());
        }
        return properties;
    }

    protected WebModule createWebModule(String appId, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        Map<String, URL> descriptors;
        File warFile = new File(warPath);
        warFile = DeploymentLoader.unpack(warFile);
        try {
            descriptors = this.getWebDescriptors(warFile);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to collect descriptors in web module: " + contextRoot, e);
        }
        URL webXmlUrl = descriptors.get("web.xml");
        WebApp webApp = webXmlUrl != null ? ReadDescriptors.readWebApp(webXmlUrl) : new WebApp();
        URL[] webUrls = DeploymentLoader.getWebappUrls(warFile);
        URLClassLoader warClassLoader = ClassLoaderUtil.createTempClassLoader(appId, webUrls, parentClassLoader);
        WebModule webModule = new WebModule(webApp, contextRoot, warClassLoader, warFile.getAbsolutePath(), moduleName);
        webModule.setUrls(Arrays.asList(webUrls));
        webModule.setScannableUrls(DeploymentLoader.filterWebappUrls(webUrls));
        webModule.getAltDDs().putAll(descriptors);
        webModule.getWatchedResources().add(warPath);
        webModule.getWatchedResources().add(warFile.getAbsolutePath());
        if (webXmlUrl != null && "file".equals(webXmlUrl.getProtocol())) {
            webModule.getWatchedResources().add(URLs.toFilePath(webXmlUrl));
        }
        this.addTagLibraries(webModule);
        this.addWebservices(webModule);
        this.addFacesConfigs(webModule);
        this.addBeansXmls(webModule);
        return webModule;
    }

    private static List<URL> filterWebappUrls(URL[] webUrls) {
        UrlSet urls = new UrlSet(webUrls);
        try {
            urls = NewLoaderLogic.applyBuiltinExcludes(urls);
        }
        catch (MalformedURLException e) {
            return Arrays.asList(webUrls);
        }
        return urls.getUrls();
    }

    private void addBeansXmls(WebModule webModule) {
        ArrayList<URL> xmls;
        List<URL> urls = webModule.getScannableUrls();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
            xmls.add((URL)webModule.getAltDDs().get("beans.xml"));
        }
        catch (IOException e) {
            return;
        }
        Beans complete = null;
        for (URL url : xmls) {
            if (url == null) continue;
            try {
                Beans beans = ReadDescriptors.readBeans(url);
                if (complete == null) {
                    complete = beans;
                    continue;
                }
                complete.getAlternativeClasses().addAll(beans.getAlternativeClasses());
                complete.getAlternativeStereotypes().addAll(beans.getAlternativeStereotypes());
                complete.getDecorators().addAll(beans.getDecorators());
                complete.getInterceptors().addAll(beans.getInterceptors());
            }
            catch (OpenEJBException e) {
                logger.error("Unable to read beans.xml from :" + url.toExternalForm());
            }
        }
        webModule.getAltDDs().put("beans.xml", complete);
    }

    private void addBeansXmls(AppModule appModule) {
        ArrayList<URL> xmls;
        List<URL> urls = appModule.getAdditionalLibraries();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
        }
        catch (IOException e) {
            return;
        }
        ArrayList<JarArchive> jars = new ArrayList<JarArchive>();
        Beans complete = null;
        for (URL url : xmls) {
            if (url == null) continue;
            try {
                Beans beans = ReadDescriptors.readBeans(url);
                if (complete == null) {
                    complete = beans;
                } else {
                    complete.getAlternativeClasses().addAll(beans.getAlternativeClasses());
                    complete.getAlternativeStereotypes().addAll(beans.getAlternativeStereotypes());
                    complete.getDecorators().addAll(beans.getDecorators());
                    complete.getInterceptors().addAll(beans.getInterceptors());
                }
                File file = URLs.toFile(url);
                jars.add(new JarArchive(appModule.getClassLoader(), url));
            }
            catch (OpenEJBException e) {
                logger.error("Unable to read beans.xml from :" + url.toExternalForm(), e);
            }
        }
        if (complete == null) {
            return;
        }
        EjbModule ejbModule = new EjbModule(appModule.getClassLoader(), "ear-scoped-cdi-beans", new EjbJar(), new OpenejbJar());
        ejbModule.setBeans(complete);
        ejbModule.setFinder(new AnnotationFinder(new AggregatedArchive(appModule.getClassLoader(), xmls)));
        appModule.getEjbModules().add(ejbModule);
    }

    protected String getContextRoot() {
        return null;
    }

    protected String getModuleName() {
        return null;
    }

    public static URL[] getWebappUrls(File warFile) {
        ArrayList<URL> webClassPath = new ArrayList<URL>();
        File webInfDir = new File(warFile, "WEB-INF");
        try {
            webClassPath.add(new File(webInfDir, "classes").toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.warning("War path bad: " + new File(webInfDir, "classes"), e);
        }
        File libDir = new File(webInfDir, "lib");
        if (libDir.exists()) {
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                try {
                    webClassPath.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + file, e);
                }
            }
        }
        URL[] webUrls = webClassPath.toArray(new URL[webClassPath.size()]);
        return webUrls;
    }

    private void addWebservices(WsModule wsModule) throws OpenEJBException {
        URL moduleUrl;
        String webservicesEnabled = SystemInstance.get().getProperty("openejb.webservices.enabled", "true");
        if (!Boolean.parseBoolean(webservicesEnabled)) {
            wsModule.getAltDDs().remove("webservices.xml");
            wsModule.setWebservices(null);
            return;
        }
        Object webservicesObject = wsModule.getAltDDs().get("webservices.xml");
        if (webservicesObject == null || !(webservicesObject instanceof URL)) {
            return;
        }
        URL webservicesUrl = (URL)webservicesObject;
        try {
            File jarFile = new File(wsModule.getJarLocation());
            moduleUrl = jarFile.toURI().toURL();
            if (jarFile.isFile()) {
                moduleUrl = new URL("jar", "", -1, moduleUrl + "!/");
            }
        }
        catch (MalformedURLException e) {
            logger.warning("Invalid module location " + wsModule.getJarLocation());
            return;
        }
        HashMap<URL, JavaWsdlMapping> jaxrpcMappingCache = new HashMap<URL, JavaWsdlMapping>();
        Webservices webservices = ReadDescriptors.readWebservices(webservicesUrl);
        wsModule.setWebservices(webservices);
        if ("file".equals(webservicesUrl.getProtocol())) {
            wsModule.getWatchedResources().add(URLs.toFilePath(webservicesUrl));
        }
        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile();
            if (jaxrpcMappingFile == null) continue;
            try {
                URL jaxrpcMappingUrl = new URL(moduleUrl, jaxrpcMappingFile);
                JavaWsdlMapping jaxrpcMapping = (JavaWsdlMapping)jaxrpcMappingCache.get(jaxrpcMappingUrl);
                if (jaxrpcMapping == null) {
                    jaxrpcMapping = ReadDescriptors.readJaxrpcMapping(jaxrpcMappingUrl);
                    jaxrpcMappingCache.put(jaxrpcMappingUrl, jaxrpcMapping);
                }
                webserviceDescription.setJaxrpcMapping(jaxrpcMapping);
                if (!"file".equals(jaxrpcMappingUrl.getProtocol())) continue;
                wsModule.getWatchedResources().add(URLs.toFilePath(jaxrpcMappingUrl));
            }
            catch (MalformedURLException e) {
                logger.warning("Invalid jaxrpc-mapping-file location " + jaxrpcMappingFile);
            }
        }
    }

    private void addTagLibraries(WebModule webModule) throws OpenEJBException {
        HashSet<URL> tldLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            for (JspConfig jspConfig : webApp.getJspConfig()) {
                for (Taglib taglib : jspConfig.getTaglib()) {
                    String location = taglib.getTaglibLocation();
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        tldLocations.addAll(DeploymentLoader.scanForTagLibs(file));
                    }
                    catch (IOException e) {
                        logger.warning("JSP tag library location bad: " + location, e);
                    }
                }
            }
        }
        Set<URL> urls = DeploymentLoader.scanWarForTagLibs(warFile);
        tldLocations.addAll(urls);
        ClassLoader parentClassLoader = webModule.getClassLoader().getParent();
        urls = DeploymentLoader.scanClassLoaderForTagLibs(parentClassLoader);
        tldLocations.addAll(urls);
        for (URL location : tldLocations) {
            TldTaglib taglib = ReadDescriptors.readTldTaglib(location);
            webModule.getTaglibs().add(taglib);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    private void addFacesConfigs(WebModule webModule) throws OpenEJBException {
        File facesConfigFile;
        File webInf;
        HashSet<URL> facesConfigLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            String foundContextParam = webApp.contextParamsAsMap().get("javax.faces.CONFIG_FILES");
            if (foundContextParam != null && foundContextParam != null) {
                String commaDelimitedListOfFiles = foundContextParam.trim();
                String[] configFiles = commaDelimitedListOfFiles.split(",");
                String[] trimmedConfigFiles = new String[configFiles.length];
                for (int i = 0; i < configFiles.length; ++i) {
                    trimmedConfigFiles[i] = configFiles[i].trim();
                }
                for (String location : trimmedConfigFiles) {
                    if (!location.startsWith("/")) {
                        logger.error("A faces configuration file should be context relative when specified in web.xml. Please fix the value of context parameter javax.faces.CONFIG_FILES for the file " + location);
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        URL url = file.toURI().toURL();
                        facesConfigLocations.add(url);
                    }
                    catch (IOException e) {
                        logger.error("Faces configuration file location bad: " + location, e);
                    }
                }
            } else if (foundContextParam == null) {
                logger.info("faces config file is null");
            }
        }
        if ((webInf = new File(warFile, "WEB-INF")).isDirectory() && (facesConfigFile = new File(webInf, "faces-config.xml")).exists()) {
            try {
                facesConfigFile = facesConfigFile.getCanonicalFile().getAbsoluteFile();
                URL url = facesConfigFile.toURI().toURL();
                facesConfigLocations.add(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL location : facesConfigLocations) {
            FacesConfig facesConfig = ReadDescriptors.readFacesConfig(location);
            webModule.getFacesConfigs().add(facesConfig);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    private static Set<URL> scanClassLoaderForTagLibs(ClassLoader parentClassLoader) throws OpenEJBException {
        UrlSet urlSet;
        HashSet<URL> urls = new HashSet<URL>();
        if (parentClassLoader == null) {
            return urls;
        }
        try {
            urlSet = new UrlSet(parentClassLoader);
            urlSet = urlSet.excludeJavaEndorsedDirs();
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaHome();
            urlSet = urlSet.exclude(ClassLoader.getSystemClassLoader());
        }
        catch (IOException e) {
            logger.warning("Error scanning class loader for JSP tag libraries", e);
            return urls;
        }
        for (URL url : urlSet.getUrls()) {
            if (url.getProtocol().equals("jar")) {
                try {
                    String path = url.getPath();
                    if (path.endsWith("!/")) {
                        path = path.substring(0, path.length() - 2);
                    }
                    url = new URL(path);
                }
                catch (MalformedURLException e) {
                    logger.warning("JSP tag library location bad: " + url.toExternalForm(), e);
                    continue;
                }
            }
            if (!url.getProtocol().equals("file")) continue;
            File file = URLs.toFile(url);
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
                continue;
            }
            urls.addAll(DeploymentLoader.scanForTagLibs(file));
        }
        return urls;
    }

    private static Set<URL> scanWarForTagLibs(File war) {
        HashSet<URL> urls = new HashSet<URL>();
        File webInfDir = new File(war, "WEB-INF");
        if (!webInfDir.isDirectory()) {
            return urls;
        }
        LinkedList<File> files = new LinkedList<File>();
        for (File file : webInfDir.listFiles()) {
            if ("lib".equals(file.getName()) || "classes".equals(file.getName())) continue;
            files.add(file);
        }
        if (files.isEmpty()) {
            return urls;
        }
        while (!files.isEmpty()) {
            File file = (File)files.removeFirst();
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (!file.getName().endsWith(".tld")) continue;
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
                urls.add(file.toURI().toURL());
            }
            catch (IOException e) {
                logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
            }
        }
        return urls;
    }

    private static Set<URL> scanForTagLibs(File file) {
        HashSet<URL> tldLocations = new HashSet<URL>();
        String location = null;
        try {
            location = file.toURI().toURL().toExternalForm();
            if (location.endsWith(".jar")) {
                Set<URL> urls = DeploymentLoader.scanJarForTagLibs(file);
                tldLocations.addAll(urls);
            } else if (file.getName().endsWith(".tld")) {
                URL url = file.toURI().toURL();
                tldLocations.add(url);
            }
        }
        catch (IOException e) {
            logger.warning("Error scanning for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        return tldLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<URL> scanJarForTagLibs(File file) {
        HashSet<URL> urls = new HashSet<URL>();
        if (!file.isFile()) {
            return urls;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            URL jarFileUrl = new URL("jar", "", -1, file.toURI().toURL().toExternalForm() + "!/");
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                String name = entry.getName();
                if (!name.startsWith(ddDir) || !name.endsWith(".tld")) continue;
                URL url = new URL(jarFileUrl, name);
                urls.add(url);
            }
        }
        catch (IOException e) {
            logger.warning("Error scanning jar for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urls;
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId) throws OpenEJBException {
        File rarFile = new File(rarPath);
        rarFile = DeploymentLoader.unpack(rarFile);
        URL baseUrl = DeploymentLoader.getFileUrl(rarFile);
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(baseUrl);
        Connector connector = null;
        URL rarXmlUrl = descriptors.get("ra.xml");
        if (rarXmlUrl != null) {
            connector = ReadDescriptors.readConnector(rarXmlUrl);
        }
        HashMap<String, URL> rarLibs = new HashMap<String, URL>();
        DeploymentLoader.scanDir(rarFile, rarLibs, "");
        Iterator<Map.Entry<String, URL>> iterator = rarLibs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, URL> fileEntry = iterator.next();
            if (fileEntry.getKey().endsWith(".jar")) continue;
            iterator.remove();
        }
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.addAll(rarLibs.values());
        URL[] urls = classPath.toArray(new URL[classPath.size()]);
        URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, urls, parentClassLoader);
        ConnectorModule connectorModule = new ConnectorModule(connector, appClassLoader, rarPath, moduleId);
        connectorModule.getAltDDs().putAll(descriptors);
        connectorModule.getLibraries().addAll(classPath);
        connectorModule.getWatchedResources().add(rarPath);
        connectorModule.getWatchedResources().add(rarFile.getAbsolutePath());
        if (rarXmlUrl != null && "file".equals(rarXmlUrl.getProtocol())) {
            connectorModule.getWatchedResources().add(URLs.toFilePath(rarXmlUrl));
        }
        return connectorModule;
    }

    protected static void addPersistenceUnits(AppModule appModule, URL ... urls) throws OpenEJBException {
        String urlString;
        URL descriptor;
        Map<String, URL> descriptors;
        ResourceFinder finder;
        ArrayList<URL> persistenceFragmentsUrls;
        ArrayList<Object> persistenceUrls = null;
        try {
            persistenceUrls = (ArrayList<Object>)appModule.getAltDDs().get("persistence.xml");
        }
        catch (ClassCastException e) {
            Object value = appModule.getAltDDs().get("persistence.xml");
            persistenceUrls = new ArrayList<Object>();
            persistenceUrls.add(URL.class.cast(value));
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if (persistenceUrls == null) {
            persistenceUrls = new ArrayList();
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if ((persistenceFragmentsUrls = (ArrayList<URL>)appModule.getAltDDs().get("persistence-fragment.xml")) == null) {
            persistenceFragmentsUrls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence-fragment.xml", persistenceFragmentsUrls);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), url);
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence.xml") || persistenceUrls.contains(descriptor = descriptors.get("persistence.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence.xml")) {
                logger.info("AltDD persistence.xml -> " + urlString);
            }
            persistenceUrls.add(descriptor);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), url);
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence-fragment.xml") || persistenceFragmentsUrls.contains(descriptor = descriptors.get("persistence-fragment.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence-fragment.xml")) {
                logger.info("AltDD persistence-fragment.xml -> " + urlString);
            }
            persistenceFragmentsUrls.add(descriptor);
        }
    }

    public static Map<String, URL> getDescriptors(URL moduleUrl) throws OpenEJBException {
        ResourceFinder finder = new ResourceFinder(moduleUrl);
        return DeploymentLoader.getDescriptors(finder);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder) throws OpenEJBException {
        return DeploymentLoader.getDescriptors(finder, true);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder, boolean log) throws OpenEJBException {
        try {
            return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), log);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", e);
        }
    }

    private static Map<String, URL> mapDescriptors(ResourceFinder finder) throws IOException {
        Map<String, URL> map = finder.getResourcesMap(ddDir);
        if (map.size() == 0) {
            String[] known;
            for (String descriptor : known = new String[]{"web.xml", "ejb-jar.xml", "openejb-jar.xml", "env-entries.properties", "beans.xml", "ra.xml", "application.xml", "application-client.xml", "persistence-fragment.xml", "persistence.xml", "validation.xml"}) {
                URL url = finder.getResource(ddDir + descriptor);
                if (url == null) continue;
                map.put(descriptor, url);
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, URL> altDDSources(Map<String, URL> map, boolean log) {
        String prefixes = SystemInstance.get().getProperty(OPENEJB_ALTDD_PREFIX);
        if (prefixes == null || prefixes.length() <= 0) {
            return map;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(prefixes.split(",")));
        Collections.reverse(list);
        HashMap<String, URL> alts = new HashMap<String, URL>();
        for (String string : list) {
            String string2 = string.trim();
            if (!string2.matches(".*[.-]$")) {
                String string3 = string2 + ".";
            }
            for (Map.Entry<String, URL> entry : new HashMap<String, URL>(map).entrySet()) {
                void var6_6;
                String key = entry.getKey();
                URL value = entry.getValue();
                if (!key.startsWith((String)var6_6)) continue;
                key = key.substring(var6_6.length());
                alts.put(key, value);
            }
        }
        for (Map.Entry entry : alts.entrySet()) {
            String key = (String)entry.getKey();
            URL value = (URL)entry.getValue();
            if (value.equals(map.get(key))) continue;
            if (log) {
                logger.info("AltDD " + key + " -> " + value.toExternalForm());
            }
            map.put(key, value);
        }
        return map;
    }

    protected Map<String, URL> getWebDescriptors(File warFile) throws IOException {
        File webInfDir;
        TreeMap<String, URL> descriptors = new TreeMap<String, URL>();
        if (warFile.isFile()) {
            URL jarURL = new URL("jar", "", -1, warFile.toURI().toURL() + "!/");
            try {
                JarFile jarFile = new JarFile(warFile);
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith("WEB-INF/") || entryName.indexOf(47, "WEB-INF/".length()) <= 0) continue;
                    descriptors.put(entryName, new URL(jarURL, entry.getName()));
                }
            }
            catch (IOException e) {}
        } else if (warFile.isDirectory() && (webInfDir = new File(warFile, "WEB-INF")).isDirectory()) {
            for (File file : webInfDir.listFiles()) {
                if (file.isDirectory()) continue;
                descriptors.put(file.getName(), file.toURI().toURL());
            }
        }
        return descriptors;
    }

    protected File getFile(URL warUrl) {
        if ("jar".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            if (!pathname.startsWith("file:")) {
                return null;
            }
            pathname = pathname.substring("file:".length());
            pathname = pathname.substring(0, pathname.lastIndexOf(33));
            pathname = URLDecoder.decode(pathname);
            return new File(pathname);
        }
        if ("file".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            return new File(URLDecoder.decode(pathname));
        }
        return null;
    }

    public static <T> T unmarshal(Class<T> type, String descriptor, URL url) throws OpenEJBException {
        try {
            return (T)JaxbJavaee.unmarshalJavaee(type, url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the " + descriptor + " file: " + url.toExternalForm(), e);
        }
    }

    public static void scanDir(File dir, Map<String, URL> files, String path) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DeploymentLoader.scanDir(file, files, path + file.getName() + "/");
                continue;
            }
            String name = file.getName();
            try {
                files.put(path + name, file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.warning("EAR path bad: " + path + name, e);
            }
        }
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, boolean searchForDescriptorlessApplications) throws IOException, UnknownModuleTypeException {
        HashSet<RequireDescriptors> search = new HashSet<RequireDescriptors>();
        if (!searchForDescriptorlessApplications) {
            search.addAll(Arrays.asList(RequireDescriptors.values()));
        }
        return this.discoverModuleType(baseUrl, classLoader, search);
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptor) throws IOException, UnknownModuleTypeException {
        InputStream is;
        Manifest manifest;
        String mainClass;
        Map<String, URL> webDescriptors;
        boolean scanPotentialEjbModules = !requireDescriptor.contains((Object)RequireDescriptors.EJB);
        boolean scanPotentialClientModules = !requireDescriptor.contains((Object)RequireDescriptors.CLIENT);
        URL pathToScanDescriptors = baseUrl;
        if (baseUrl != null) {
            String baseURLString = baseUrl.toString();
            if (baseUrl.getProtocol().equals("file") && baseURLString.endsWith("WEB-INF/classes/")) {
                pathToScanDescriptors = new URL(baseURLString.substring(0, baseURLString.lastIndexOf("WEB-INF/classes/")));
            }
        }
        Map<String, URL> descriptors = this.getDescriptors(classLoader, pathToScanDescriptors);
        String path = baseUrl != null ? baseUrl.getPath() : "";
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (descriptors.containsKey("application.xml") || path.endsWith(".ear")) {
            return AppModule.class;
        }
        if (descriptors.containsKey("application-client.xml")) {
            return ClientModule.class;
        }
        if (descriptors.containsKey("ra.xml") || path.endsWith(".rar")) {
            return ConnectorModule.class;
        }
        if (baseUrl != null && ((webDescriptors = this.getWebDescriptors(this.getFile(baseUrl))).containsKey("web.xml") || webDescriptors.containsKey("web-fragment.xml") || path.endsWith(".war") || new File(path, "WEB-INF").exists())) {
            return WebModule.class;
        }
        if (descriptors.containsKey("ejb-jar.xml") || descriptors.containsKey("beans.xml")) {
            return EjbModule.class;
        }
        URL manifestUrl = descriptors.get("MANIFEST.MF");
        if (scanPotentialClientModules && manifestUrl != null && (mainClass = (manifest = new Manifest(is = manifestUrl.openStream())).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
            return ClientModule.class;
        }
        Class<? extends DeploymentModule> cls = this.checkAnnotations(baseUrl, classLoader, scanPotentialEjbModules, scanPotentialClientModules);
        if (cls != null) {
            return cls;
        }
        if (descriptors.containsKey("persistence.xml") || descriptors.containsKey("persistence-fragment.xml")) {
            return PersistenceModule.class;
        }
        throw new UnknownModuleTypeException("Unknown module type: url=" + path);
    }

    private Map<String, URL> getDescriptors(ClassLoader classLoader, URL pathToScanDescriptors) throws IOException {
        ResourceFinder finder = new ResourceFinder("", classLoader, pathToScanDescriptors);
        return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false);
    }

    private Class<? extends DeploymentModule> checkAnnotations(URL urls, ClassLoader classLoader, final boolean scanPotentialEjbModules, final boolean scanPotentialClientModules) {
        Class cls = null;
        if (scanPotentialEjbModules || scanPotentialClientModules) {
            org.apache.openejb.util.AnnotationFinder classFinder = new org.apache.openejb.util.AnnotationFinder(classLoader, urls);
            final LinkedHashSet otherTypes = new LinkedHashSet();
            AnnotationFinder.Filter filter = new AnnotationFinder.Filter(){
                final String packageName = LocalClient.class.getName().replace("LocalClient", "");

                @Override
                public boolean accept(String annotationName) {
                    if (scanPotentialEjbModules) {
                        if (annotationName.startsWith("javax.ejb.")) {
                            if ("javax.ejb.Stateful".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Stateless".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Singleton".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.MessageDriven".equals(annotationName)) {
                                return true;
                            }
                        } else if (DeploymentLoader.this.scanManagedBeans && "javax.annotation.ManagedBean".equals(annotationName)) {
                            return true;
                        }
                    } else if (scanPotentialClientModules && annotationName.startsWith(this.packageName)) {
                        if (LocalClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                        if (RemoteClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                    }
                    return false;
                }
            };
            if (classFinder.find(filter)) {
                cls = EjbModule.class;
            }
            if (otherTypes.size() > 0) {
                cls = (Class)otherTypes.iterator().next();
            }
        }
        return cls;
    }

    protected static File unpack(File jarFile) throws OpenEJBException {
        if (jarFile.isDirectory()) {
            return jarFile;
        }
        String name = jarFile.getName();
        name = name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".rar") ? name.replaceFirst("....$", "") : name + ".unpacked";
        try {
            return JarExtractor.extract(jarFile, name);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to extract jar. " + e.getMessage(), e);
        }
    }

    protected static URL getFileUrl(File jarFile) throws OpenEJBException {
        URL baseUrl;
        try {
            baseUrl = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
        }
        return baseUrl;
    }
}

