/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.el.ELResolver;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.BeansDeployer;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiInterceptor;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.cdi.NewCdiEjbBean;
import org.apache.openejb.cdi.StartupObject;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.component.EjbBeanCreatorImpl;
import org.apache.webbeans.ejb.common.util.EjbUtility;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class OpenEJBLifecycle
implements ContainerLifecycle {
    protected static WebBeansLogger logger = WebBeansLogger.getLogger(OpenEJBLifecycle.class);
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    private final WebBeansContext webBeansContext;
    private ScheduledExecutorService service = null;

    public OpenEJBLifecycle() {
        this(WebBeansContext.currentInstance());
    }

    public OpenEJBLifecycle(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beforeInitApplication(null);
        this.beanManager = webBeansContext.getBeanManagerImpl();
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer, webBeansContext);
        this.jndiService = webBeansContext.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = webBeansContext.getScannerService();
        this.contextsService = webBeansContext.getContextsService();
        this.initApplication(null);
    }

    @Override
    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContents(URL resource) throws IOException {
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedInputStream(in);
            int b = reader.read();
            while (b != -1) {
                sb.append((char)b);
                b = reader.read();
            }
            String string = sb.toString().trim();
            return string;
        }
        finally {
            try {
                in.close();
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void startApplication(Object startupObject) {
        if (startupObject instanceof ServletContextEvent) {
            this.startServletContext((ServletContext)this.getServletContext(startupObject));
            return;
        }
        if (!(startupObject instanceof StartupObject)) {
            logger.debug("startupObject is not of StartupObject type; ignored");
            return;
        }
        StartupObject stuff = (StartupObject)startupObject;
        logger.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.beforeStartApplication(startupObject);
        this.webBeansContext.getPluginLoader().startUp();
        CdiPlugin cdiPlugin = (CdiPlugin)this.webBeansContext.getPluginLoader().getEjbPlugin();
        AppContext appContext = stuff.getAppContext();
        cdiPlugin.setAppContext(appContext);
        appContext.setWebBeansContext(this.webBeansContext);
        cdiPlugin.startup();
        cdiPlugin.configureDeployments(stuff.getBeanContexts());
        CdiResourceInjectionService injectionService = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
        injectionService.setAppContext(stuff.getAppContext());
        try {
            CdiEjbBean bean;
            this.loadExtensions(appContext);
            this.contextsService.init(startupObject);
            this.deployer.configureDefaultBeans();
            this.deployer.fireBeforeBeanDiscoveryEvent();
            logger.debug("Scanning classpaths for beans artifacts.");
            if (this.scannerService instanceof CdiScanner) {
                CdiScanner service = (CdiScanner)this.scannerService;
                service.init(startupObject);
            } else {
                new CdiScanner().init(startupObject);
            }
            this.scannerService.scan();
            this.deployer.deployFromXML(this.scannerService);
            this.deployer.checkStereoTypes(this.scannerService);
            this.deployManagedBeans(this.scannerService.getBeanClasses(), stuff.getBeanContexts());
            for (BeanContext beanContext : stuff.getBeanContexts()) {
                if (!beanContext.getComponentType().isCdiCompatible() || beanContext.isDynamicallyImplemented()) continue;
                Class implClass = beanContext.getBeanClass();
                AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(implClass);
                GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
                if (processAnnotatedEvent.isVeto()) continue;
                CdiEjbBean<Object> bean2 = new CdiEjbBean<Object>(beanContext, this.webBeansContext);
                beanContext.set(CdiEjbBean.class, bean2);
                beanContext.set(CurrentCreationalContext.class, new CurrentCreationalContext());
                beanContext.addSystemInterceptor(new CdiInterceptor(bean2, this.beanManager, cdiPlugin.getContexsServices()));
                OpenEJBLifecycle.fireEvents(implClass, bean2, processAnnotatedEvent);
                this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(bean2);
                Class clazz = beanContext.getBeanClass();
                while (clazz.isAnnotationPresent(Specializes.class) && (clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz)) {
                    CdiEjbBean superBean = new CdiEjbBean(beanContext, this.webBeansContext, clazz);
                    EjbBeanCreatorImpl ejbBeanCreator = new EjbBeanCreatorImpl(superBean);
                    ejbBeanCreator.defineSerializable();
                    ejbBeanCreator.defineStereoTypes();
                    ejbBeanCreator.defineScopeType("Session Bean implementation class : " + clazz.getName() + " stereotypes must declare same @ScopeType annotations", false);
                    ejbBeanCreator.defineQualifier();
                    ejbBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
                    bean2.specialize(superBean);
                    EjbUtility.defineSpecializedData(clazz, bean2);
                }
            }
            this.deployer.checkSpecializations(this.scannerService);
            this.deployer.fireAfterBeanDiscoveryEvent();
            this.deployer.validateInjectionPoints();
            for (BeanContext beanContext : stuff.getBeanContexts()) {
                if (!beanContext.getComponentType().isSession() || beanContext.isDynamicallyImplemented()) continue;
                bean = beanContext.get(CdiEjbBean.class);
                List<InterceptorData> datas = bean.getInterceptorStack();
                ArrayList<org.apache.openejb.core.interceptor.InterceptorData> converted = new ArrayList<org.apache.openejb.core.interceptor.InterceptorData>();
                for (InterceptorData data : datas) {
                    converted.add(org.apache.openejb.core.interceptor.InterceptorData.scan(data.getInterceptorClass()));
                }
                beanContext.setCdiInterceptors(converted);
            }
            this.deployer.fireAfterDeploymentValidationEvent();
            for (BeanContext beanContext : stuff.getBeanContexts()) {
                bean = beanContext.get(CdiEjbBean.class);
                if (bean == null) continue;
                BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
                manager.addBean(new NewCdiEjbBean(bean));
            }
        }
        catch (Exception e1) {
            Assembler.logger.error("CDI Beans module deployment failed", e1);
            throw new RuntimeException(e1);
        }
        this.afterStartApplication(startupObject);
        logger.info("INFO_0001", Long.toString(System.currentTimeMillis() - begin));
    }

    public static <T> void fireEvents(Class<T> clazz, BaseEjbBean<T> ejbBean, ProcessAnnotatedType<T> event) {
        WebBeansContext webBeansContext = ejbBean.getWebBeansContext();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        AnnotatedElementFactory annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
        AnnotatedType<T> annotatedType = annotatedElementFactory.newAnnotatedType(clazz);
        ProcessAnnotatedTypeImpl processAnnotatedEvent = (ProcessAnnotatedTypeImpl)event;
        EjbBeanCreatorImpl<T> ejbBeanCreator = new EjbBeanCreatorImpl<T>(ejbBean);
        ejbBeanCreator.checkCreateConditions();
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        if (processAnnotatedEvent.isModifiedAnnotatedType()) {
            ejbBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
            ejbBeanCreator.setAnnotatedType(annotatedType);
        }
        ejbBeanCreator.defineSerializable();
        ejbBeanCreator.defineStereoTypes();
        ejbBeanCreator.defineApiType();
        ejbBeanCreator.defineScopeType("Session Bean implementation class : " + clazz.getName() + " stereotypes must declare same @ScopeType annotations", false);
        ejbBeanCreator.defineQualifier();
        ejbBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        Set<ProducerMethodBean<?>> producerMethodBeans = ejbBeanCreator.defineProducerMethods();
        for (ProducerMethodBean<?> producerMethodBean : producerMethodBeans) {
            Method producerMethod = producerMethodBean.getCreatorMethod();
            if (Modifier.isStatic(producerMethod.getModifiers()) || EjbUtility.isBusinessMethod(producerMethod, ejbBean)) continue;
            throw new WebBeansConfigurationException("Producer Method Bean must be business method of session bean : " + ejbBean);
        }
        Set<ProducerFieldBean<?>> producerFieldBeans = ejbBeanCreator.defineProducerFields();
        ejbBeanCreator.defineInjectedFields();
        ejbBeanCreator.defineInjectedMethods();
        Set<ObserverMethod<?>> observerMethods = ejbBeanCreator.defineObserverMethods();
        GProcessInjectionTarget processInjectionTargetEvent = webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(ejbBean);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
        manager.putInjectionTargetWrapper(ejbBean, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
        HashMap annotatedMethods = new HashMap();
        for (ProducerMethodBean<?> producerMethod : producerMethodBeans) {
            AnnotatedMethod<T> method = annotatedElementFactory.newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForMethod(producerMethod, method);
            webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
            manager.putInjectionTargetWrapper(producerMethod, new InjectionTargetWrapper(producerEvent.getProducer()));
            producerEvent.setProducerSet(false);
        }
        HashMap annotatedFields = new HashMap();
        for (ProducerFieldBean<?> producerField : producerFieldBeans) {
            AnnotatedField<T> field = annotatedElementFactory.newAnnotatedField(producerField.getCreatorField(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForField(producerField, field);
            webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, field);
            manager.putInjectionTargetWrapper(producerField, new InjectionTargetWrapper(producerEvent.getProducer()));
            producerEvent.setProducerSet(false);
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod<?> observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod<T> method = annotatedElementFactory.newAnnotatedMethod(impl.getObserverMethod(), annotatedType);
            observerMethodsMap.put(observerMethod, method);
        }
        GProcessSessionBean processBeanEvent = new GProcessSessionBean((Bean<Object>)ejbBean, annotatedType, ejbBean.getEjbName(), ejbBean.getEjbType());
        webBeansContext.getBeanManagerImpl().fireEvent(processBeanEvent, new Annotation[0]);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessSessionBean event observers for managed beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessProducerFieldBeanEvent(annotatedFields);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessObservableMethodBeanEvent(observerMethodsMap);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        manager.addBean(ejbBean);
        manager.getBeans().addAll(producerMethodBeans);
        ejbBeanCreator.defineDisposalMethods();
        manager.getBeans().addAll(producerFieldBeans);
    }

    private void loadExtensions(AppContext appContext) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExtensionLoader extensionLoader = this.webBeansContext.getExtensionLoader();
        extensionLoader.loadExtensionServices(appContext.getClassLoader());
    }

    private void deployManagedBeans(Set<Class<?>> beanClasses, List<BeanContext> ejbs) {
        HashSet managedBeans = new HashSet(beanClasses);
        for (BeanContext beanContext : ejbs) {
            if (!beanContext.getComponentType().isSession()) continue;
            managedBeans.remove(beanContext.getBeanClass());
        }
        for (Class clazz : managedBeans) {
            AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
            GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
            if (processAnnotatedEvent.isVeto()) continue;
            this.deployer.defineManagedBean(clazz, processAnnotatedEvent);
        }
    }

    @Override
    public void stopApplication(Object endObject) {
        logger.debug("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(endObject);
            this.beanManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
            this.contextsService.destroy(endObject);
            this.jndiService.unbind("java:comp/BeanManager");
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            InjectionResolver.getInstance().clearCaches();
            this.webBeansContext.getJavassistProxyFactory().clear();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            this.webBeansContext.getjMSManager().clear();
            this.afterStopApplication(endObject);
            this.beanManager.clear();
            WebBeansFinder.clearInstances(WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            logger.error("ERROR_0021", e);
        }
    }

    protected WebBeansLogger getLogger() {
        return logger;
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    @Override
    public ContextsService getContextService() {
        return this.contextsService;
    }

    protected BeansDeployer getDeployer() {
        return this.deployer;
    }

    protected WebBeansXMLConfigurator getXmlDeployer() {
        return this.xmlDeployer;
    }

    protected JNDIService getJndiService() {
        return this.jndiService;
    }

    @Override
    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
    }

    public void startServletContext(ServletContext servletContext) {
        this.service = OpenEJBLifecycle.initializeServletContext(servletContext, this.webBeansContext);
    }

    public static ScheduledExecutorService initializeServletContext(final ServletContext servletContext, WebBeansContext context) {
        String strDelay = context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "OwbConversationCleaner-" + servletContext.getContextPath());
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new ConversationCleaner(context), delay, delay, TimeUnit.MILLISECONDS);
        ELAdaptor elAdaptor = context.getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        if (context.getOpenWebBeansConfiguration().isJspApplication()) {
            logger.debug("Application is configured as JSP. Adding EL Resolver.");
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext(servletContext);
                applicationCtx.addELResolver(resolver);
            } else {
                logger.debug("Default JspFactory instance was not found");
            }
        }
        servletContext.setAttribute(BeanManager.class.getName(), context.getBeanManagerImpl());
        return executorService;
    }

    protected void afterStopApplication(Object stopObject) throws Exception {
        ResourceInjectionService injectionServices = this.webBeansContext.getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
        if (logger.wblWillLogInfo()) {
            stopObject = this.getServletContext(stopObject);
            logger.info("INFO_0002", stopObject instanceof ServletContext ? ((ServletContext)stopObject).getContextPath() : stopObject);
        }
    }

    private void cleanupShutdownThreadLocals() {
        InjectionPointBean.removeThreadLocal();
    }

    private Object getServletContext(Object object) {
        if (object instanceof ServletContextEvent) {
            object = ((ServletContextEvent)object).getServletContext();
            return object;
        }
        return object;
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    private static class ConversationCleaner
    implements Runnable {
        private final WebBeansContext webBeansContext;

        private ConversationCleaner(WebBeansContext webBeansContext) {
            this.webBeansContext = webBeansContext;
        }

        @Override
        public void run() {
            this.webBeansContext.getConversationManager().destroyWithRespectToTimout();
        }
    }

    public static class NewEjbBean<T>
    extends CdiEjbBean<T>
    implements NewBean<T> {
        public NewEjbBean(BeanContext beanContext, WebBeansContext webBeansContext) {
            super(beanContext, webBeansContext);
        }
    }
}

