/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionStrategy;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.FailoverConnectionFactory;
import org.apache.openejb.client.HttpConnectionFactory;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.MulticastPulseClient;
import org.apache.openejb.client.RandomConnectionStrategy;
import org.apache.openejb.client.Registry;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.RoundRobinConnectionStrategy;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SocketConnectionFactory;
import org.apache.openejb.client.StickyConnectionStrategy;
import org.apache.openejb.client.event.ConnectionFactoryAdded;
import org.apache.openejb.client.event.ConnectionFactoryRemoved;
import org.apache.openejb.client.event.ConnectionFailed;
import org.apache.openejb.client.event.ConnectionStrategyAdded;
import org.apache.openejb.client.event.ConnectionStrategyFailed;
import org.apache.openejb.client.event.Log;

public class ConnectionManager {
    private static final Registry<ConnectionFactory> factories = Registry.create(ConnectionFactory.class);
    private static final Registry<ConnectionStrategy> strategies = Registry.create(ConnectionStrategy.class);

    public static Connection getConnection(ClusterMetaData cluster, ServerMetaData server, Request req) throws IOException {
        ConnectionStrategy strategy;
        if (cluster == null) {
            throw new IllegalArgumentException("cluster cannot be null");
        }
        if (server == null) {
            throw new IllegalArgumentException("server cannot be null");
        }
        String name = cluster.getConnectionStrategy();
        if (req instanceof EJBRequest) {
            EJBRequest ejbRequest = (EJBRequest)req;
            Properties p = ejbRequest.getEjbMetaData().getProperties();
            name = p.getProperty("openejb.client.connection.strategy", name);
        }
        if (name == null) {
            name = "default";
        }
        if ((strategy = strategies.get(name)) == null) {
            throw new UnsupportedConnectionStrategyException(name);
        }
        try {
            return strategy.connect(cluster, server);
        }
        catch (Throwable e) {
            Client.fireEvent(new ConnectionStrategyFailed(strategy, cluster, server, e));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public static Connection getConnection(URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        String scheme = uri.getScheme();
        ConnectionFactory factory = factories.get(scheme);
        if (factory == null) {
            throw new UnsupportedConnectionFactoryException(scheme);
        }
        try {
            return factory.getConnection(uri);
        }
        catch (Throwable e) {
            Client.fireEvent(new ConnectionFailed(uri, e));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public static void registerFactory(String scheme, ConnectionFactory factory) {
        factories.register(scheme, factory);
        Client.fireEvent(new ConnectionFactoryAdded(scheme, factory));
    }

    public static ConnectionFactory unregisterFactory(String scheme) {
        ConnectionFactory factory = factories.unregister(scheme);
        if (factory != null) {
            Client.fireEvent(new ConnectionFactoryRemoved(scheme, factory));
        }
        return factory;
    }

    public static void registerStrategy(String scheme, ConnectionStrategy factory) {
        strategies.register(scheme, factory);
        Client.fireEvent(new ConnectionStrategyAdded(scheme, factory));
    }

    public static ConnectionStrategy unregisterStrategy(String scheme) {
        ConnectionStrategy strategy = strategies.unregister(scheme);
        if (strategy != null) {
            Client.fireEvent(new ConnectionStrategyAdded(scheme, strategy));
        }
        return strategy;
    }

    @Deprecated
    public static void setFactory(ConnectionFactory factory) throws IOException {
        ConnectionManager.registerFactory("default", factory);
    }

    static {
        SocketConnectionFactory ejbdFactory = new SocketConnectionFactory();
        ConnectionManager.registerFactory("default", ejbdFactory);
        ConnectionManager.registerFactory("ejbd", ejbdFactory);
        ConnectionManager.registerFactory("ejbds", ejbdFactory);
        ConnectionManager.registerFactory("zejbd", ejbdFactory);
        ConnectionManager.registerFactory("zejbds", ejbdFactory);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory();
        ConnectionManager.registerFactory("http", httpFactory);
        ConnectionManager.registerFactory("https", httpFactory);
        ConnectionManager.registerFactory("multicast", new MulticastConnectionFactory());
        ConnectionManager.registerFactory("multipulse", new MulticastPulseClient());
        ConnectionManager.registerFactory("failover", new FailoverConnectionFactory());
        ConnectionManager.registerStrategy("sticky", new StickyConnectionStrategy());
        ConnectionManager.registerStrategy("sticky+random", new StickyConnectionStrategy(new RandomConnectionStrategy()));
        ConnectionManager.registerStrategy("sticky+round", new StickyConnectionStrategy(new RoundRobinConnectionStrategy()));
        ConnectionManager.registerStrategy("random", new RandomConnectionStrategy());
        ConnectionManager.registerStrategy("roundrobin", new RoundRobinConnectionStrategy());
        ConnectionManager.registerStrategy("round-robin", strategies.get("roundrobin"));
        ConnectionManager.registerStrategy("default", strategies.get("sticky"));
    }

    @Log(value=Log.Level.SEVERE)
    public static class UnsupportedConnectionFactoryException
    extends IOException {
        public UnsupportedConnectionFactoryException(String message) {
            super(message);
        }
    }

    @Log(value=Log.Level.SEVERE)
    public static class UnsupportedConnectionStrategyException
    extends IOException {
        public UnsupportedConnectionStrategyException(String message) {
            super(message);
        }
    }
}

