/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.openejb.client.ClientHandlerResolverImpl;
import org.apache.openejb.client.ClientInstance;
import org.apache.openejb.client.HandlerChainMetaData;
import org.apache.openejb.client.Injection;
import org.apache.openejb.client.InjectionMetaData;
import org.apache.openejb.client.JaxWsProviderWrapper;
import org.apache.openejb.client.PortRefMetaData;

public class WsMetaData
implements Serializable {
    private static final long serialVersionUID = -895152184216070327L;
    private String serviceClassName;
    private String referenceClassName;
    private String wsdlUrl;
    private String serviceQName;
    private final List<HandlerChainMetaData> handlerChains = new ArrayList<HandlerChainMetaData>();
    private final List<PortRefMetaData> portRefs = new ArrayList<PortRefMetaData>();

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getReferenceClassName() {
        return this.referenceClassName;
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getServiceQName() {
        return this.serviceQName;
    }

    public void setServiceQName(String serviceQName) {
        this.serviceQName = serviceQName;
    }

    public List<HandlerChainMetaData> getHandlerChains() {
        return this.handlerChains;
    }

    public List<PortRefMetaData> getPortRefs() {
        return this.portRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createWebservice() throws Exception {
        Service instance;
        Class<?> referenceClass;
        block9: {
            Class<Service> serviceClass = WsMetaData.loadClass(this.serviceClassName).asSubclass(Service.class);
            if (serviceClass == null) {
                throw new NamingException("Could not load service type class " + this.serviceClassName);
            }
            referenceClass = WsMetaData.loadClass(this.referenceClassName);
            if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
                serviceClass = referenceClass.asSubclass(Service.class);
            }
            QName serviceQName = QName.valueOf(this.serviceQName);
            URL wsdlLocation = new URL(this.wsdlUrl);
            JaxWsProviderWrapper.beforeCreate(this.portRefs);
            try {
                instance = null;
                if (Service.class.equals(serviceClass)) {
                    instance = Service.create((URL)wsdlLocation, (QName)serviceQName);
                    break block9;
                }
                try {
                    instance = serviceClass.getConstructor(URL.class, QName.class).newInstance(wsdlLocation, serviceQName);
                }
                catch (Throwable e) {
                    throw (NamingException)new NamingException("Could not instantiate jax-ws service class " + serviceClass.getName()).initCause(e);
                }
            }
            finally {
                JaxWsProviderWrapper.afterCreate();
            }
        }
        if (this.handlerChains != null && !this.handlerChains.isEmpty()) {
            InjectionMetaData injectionMetaData = ClientInstance.get().getComponent(InjectionMetaData.class);
            List<Injection> injections = injectionMetaData.getInjections();
            ClientHandlerResolverImpl handlerResolver = new ClientHandlerResolverImpl(this.handlerChains, injections, new InitialContext());
            instance.setHandlerResolver((HandlerResolver)handlerResolver);
        }
        Object port = referenceClass != null && !Service.class.isAssignableFrom(referenceClass) ? instance.getPort(referenceClass) : instance;
        return port;
    }

    public static Class<?> loadClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

