/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;

public class EJBResponse
implements ClusterableResponse {
    private transient int responseCode = -1;
    private transient Object result;
    private transient ServerMetaData server;
    private transient URI responseServerURI;

    public EJBResponse() {
    }

    public EJBResponse(int code, Object obj) {
        this.responseCode = code;
        this.result = obj;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResponse(int code, Object result) {
        this.responseCode = code;
        this.result = result;
    }

    @Override
    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public String toString() {
        StringBuffer s = null;
        switch (this.responseCode) {
            case 9: {
                s = new StringBuffer("EJB_APP_EXCEPTION");
                break;
            }
            case 11: {
                s = new StringBuffer("EJB_ERROR");
                break;
            }
            case 4: {
                s = new StringBuffer("EJB_OK");
                break;
            }
            case 5: {
                s = new StringBuffer("EJB_OK_CREATE");
                break;
            }
            case 6: {
                s = new StringBuffer("EJB_OK_FOUND");
                break;
            }
            case 7: {
                s = new StringBuffer("EJB_OK_FOUND_COLLECTION");
                break;
            }
            case 20: {
                s = new StringBuffer("EJB_OK_FOUND_ENUMERATION");
                break;
            }
            case 8: {
                s = new StringBuffer("EJB_OK_NOT_FOUND");
                break;
            }
            case 10: {
                s = new StringBuffer("EJB_SYS_EXCEPTION");
                break;
            }
            default: {
                s = new StringBuffer("UNKNOWN_RESPONSE");
            }
        }
        s.append(':').append(this.result);
        return s.toString();
    }

    public URI getResponseServerURI() {
        return this.responseServerURI;
    }

    public void setResponseServerURI(URI responseServerURI) {
        this.responseServerURI = responseServerURI;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        boolean readServer = in.readBoolean();
        if (readServer) {
            this.server = new ServerMetaData();
            this.server.readExternal(in);
        }
        this.responseCode = in.readByte();
        this.result = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        if (null != this.server) {
            out.writeBoolean(true);
            this.server.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeByte(this.responseCode);
        switch (this.responseCode) {
            case 9: 
            case 10: 
            case 11: {
                if (!(this.result instanceof Throwable) || this.result instanceof ThrowableArtifact) break;
                Throwable throwable = (Throwable)this.result;
                this.result = new ThrowableArtifact(throwable);
            }
        }
        out.writeObject(this.result);
    }
}

