/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.extensions.util;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Scanner;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;

public final class LineConsumerThread
extends CloseableDaemonThread {
    private final Charset encoding;
    private final ReadableByteChannel channel;
    private final EventHandler<String> eventHandler;
    private final CountdownCloseable countdownCloseable;
    private volatile boolean disabled;

    public LineConsumerThread(@Nonnull String threadName, @Nonnull ReadableByteChannel channel, @Nonnull EventHandler<String> eventHandler, @Nonnull CountdownCloseable countdownCloseable) {
        this(threadName, channel, eventHandler, countdownCloseable, Charset.defaultCharset());
    }

    public LineConsumerThread(@Nonnull String threadName, @Nonnull ReadableByteChannel channel, @Nonnull EventHandler<String> eventHandler, @Nonnull CountdownCloseable countdownCloseable, @Nonnull Charset encoding) {
        super(threadName);
        this.channel = channel;
        this.eventHandler = eventHandler;
        this.countdownCloseable = countdownCloseable;
        this.encoding = encoding;
    }

    @Override
    public void run() {
        try (Scanner stream = new Scanner(this.channel, this.encoding.name());
             CountdownCloseable c = this.countdownCloseable;){
            boolean isError = false;
            while (stream.hasNextLine()) {
                try {
                    String line = stream.nextLine();
                    if ((isError |= stream.ioException() != null) || this.disabled) continue;
                    this.eventHandler.handleEvent(line);
                }
                catch (IllegalStateException e) {
                    isError = true;
                }
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }

    @Override
    public void disable() {
        this.disabled = true;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

