/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.plugin.surefire.booterclient.output.OutputConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.OutputConsumerProxy;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class FileOutputConsumerProxy
extends OutputConsumerProxy {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final File reportsDirectory;
    private final StringBuffer outputBuffer = new StringBuffer();
    private volatile PrintWriter printWriter;

    public FileOutputConsumerProxy(OutputConsumer outputConsumer, File reportsDirectory) {
        super(outputConsumer);
        this.reportsDirectory = reportsDirectory;
    }

    public void testSetStarting(ReportEntry reportEntry) {
        if (this.printWriter != null) {
            throw new IllegalStateException("testSetStarting called twice");
        }
        if (!this.reportsDirectory.exists()) {
            this.reportsDirectory.mkdirs();
        }
        File file = new File(this.reportsDirectory, reportEntry.getName() + "-output.txt");
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        super.testSetStarting(reportEntry);
    }

    public void testSetCompleted() {
        if (this.printWriter == null) {
            throw new IllegalStateException("testSetCompleted called before testSetStarting");
        }
        if (this.outputBuffer.length() > 0) {
            this.printWriter.write(this.outputBuffer.toString());
            this.printWriter.write(LINE_SEPARATOR);
            this.outputBuffer.setLength(0);
        }
        this.printWriter.close();
        this.printWriter = null;
        super.testSetCompleted();
    }

    public void consumeOutputLine(String line) {
        if (this.printWriter == null) {
            this.outputBuffer.append(line);
            this.outputBuffer.append(LINE_SEPARATOR);
            return;
        }
        if (this.outputBuffer.length() > 0) {
            this.printWriter.write(this.outputBuffer.toString());
            this.printWriter.write(LINE_SEPARATOR);
            this.outputBuffer.setLength(0);
        }
        this.printWriter.write(line);
        this.printWriter.write(LINE_SEPARATOR);
    }
}

