/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.internal.ClassMethod;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.ClassMethodIndexer;
import org.apache.maven.surefire.report.RunModeSetter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener
implements TestOutputReceiver<OutputReportEntry>,
RunModeSetter {
    protected final ClassMethodIndexer classMethodIndexer = new ClassMethodIndexer();
    protected final TestReportListener<TestOutputReportEntry> reporter;
    private volatile RunMode runMode;
    private final ThreadLocal<Boolean> failureFlag = new InheritableThreadLocal<Boolean>();

    public JUnit4RunListener(TestReportListener<TestOutputReportEntry> reporter) {
        this.reporter = reporter;
    }

    public final ConsoleLogger getConsoleLogger() {
        return this.reporter;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    protected final RunMode getRunMode() {
        return this.runMode;
    }

    public void testIgnored(Description description) throws Exception {
        String reason = JUnit4Reflector.getAnnotatedIgnoreValue(description);
        ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(description);
        long testRunId = this.classMethodIndexer.indexClassMethod(classMethod.getClazz(), classMethod.getMethod());
        this.reporter.testSkipped((ReportEntry)SimpleReportEntry.ignored((RunMode)this.runMode, (Long)testRunId, (String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (String)reason));
    }

    public void testStarted(Description description) throws Exception {
        try {
            this.reporter.testStarting((ReportEntry)this.createReportEntry(description));
        }
        finally {
            this.failureFlag.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        try {
            StackTraceWriter stackTrace = this.createStackTraceWriter(failure);
            ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(failure.getDescription());
            long testRunId = this.classMethodIndexer.indexClassMethod(classMethod.getClazz(), classMethod.getMethod());
            SimpleReportEntry report = SimpleReportEntry.withException((RunMode)this.runMode, (Long)testRunId, (String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (StackTraceWriter)stackTrace);
            if (failure.getException() instanceof AssertionError) {
                this.reporter.testFailed((ReportEntry)report);
            } else {
                this.reporter.testError((ReportEntry)report);
            }
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        try {
            Description desc = failure.getDescription();
            ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(desc);
            long testRunId = this.classMethodIndexer.indexClassMethod(classMethod.getClazz(), classMethod.getMethod());
            SimpleReportEntry report = SimpleReportEntry.assumption((RunMode)this.runMode, (Long)testRunId, (String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (String)failure.getMessage());
            this.reporter.testAssumptionFailure((ReportEntry)report);
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    public void testFinished(Description description) throws Exception {
        Boolean failure = this.failureFlag.get();
        if (failure == null) {
            this.reporter.testSucceeded((ReportEntry)this.createReportEntry(description));
        }
    }

    public void testExecutionSkippedByUser() {
        this.reporter.testExecutionSkippedByUser();
    }

    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(description);
        long testRunId = this.classMethodIndexer.indexClassMethod(classMethod.getClazz(), classMethod.getMethod());
        return new SimpleReportEntry(this.runMode, Long.valueOf(testRunId), classMethod.getClazz(), null, classMethod.getMethod(), null);
    }

    public static void rethrowAnyTestMechanismFailures(Result run) throws TestSetFailedException {
        for (Failure failure : run.getFailures()) {
            if (!JUnit4ProviderUtil.isFailureInsideJUnitItself(failure.getDescription())) continue;
            throw new TestSetFailedException(failure.getTestHeader() + " :: " + failure.getMessage(), failure.getException());
        }
    }

    public void writeTestOutput(OutputReportEntry reportEntry) {
        Long testRunId = this.classMethodIndexer.getLocalIndex();
        this.reporter.writeTestOutput((OutputReportEntry)new TestOutputReportEntry(reportEntry, this.runMode, testRunId));
    }
}

