/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.codehaus.plexus.util.StringUtils;

public final class JarData {
    private final File file;
    private final boolean sealed;
    private String fileHash;
    private String bytecodeHash;
    private final Manifest manifest;
    private JarClasses jarClasses;
    private final List entries;
    private JarIdentification jarIdentification;

    public JarData(File file, Manifest manifest, List entries) {
        String sval;
        this.file = file;
        this.manifest = manifest;
        this.entries = Collections.unmodifiableList(entries);
        boolean sealed = false;
        if (this.manifest != null && StringUtils.isNotEmpty((String)(sval = this.manifest.getMainAttributes().getValue(Attributes.Name.SEALED)))) {
            sealed = "true".equalsIgnoreCase(sval.trim());
        }
        this.sealed = sealed;
    }

    public List getEntries() {
        return this.entries;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setFileHash(String fileHash) {
        this.fileHash = fileHash;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public void setBytecodeHash(String bytecodeHash) {
        this.bytecodeHash = bytecodeHash;
    }

    public String getBytecodeHash() {
        return this.bytecodeHash;
    }

    public boolean isDebugPresent() {
        return this.jarClasses.isDebugPresent();
    }

    public void setJarClasses(JarClasses jarClasses) {
        this.jarClasses = jarClasses;
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public int getNumClasses() {
        return this.jarClasses.getClassNames().size();
    }

    public int getNumPackages() {
        return this.jarClasses.getPackages().size();
    }

    public String getJdkRevision() {
        return this.jarClasses.getJdkRevision();
    }

    public void setJarIdentification(JarIdentification jarIdentification) {
        this.jarIdentification = jarIdentification;
    }

    public JarIdentification getJarIdentification() {
        return this.jarIdentification;
    }

    public JarClasses getJarClasses() {
        return this.jarClasses;
    }
}

