/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.download;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.shared.io.download.DownloadFailedException;
import org.apache.maven.shared.io.download.DownloadManager;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;

public class DefaultDownloadManager
implements DownloadManager {
    public static final String ROLE_HINT = "default";
    private WagonManager wagonManager;
    private Map<String, File> cache = new HashMap<String, File>();

    public DefaultDownloadManager() {
    }

    public DefaultDownloadManager(WagonManager wagonManager) {
        this.wagonManager = wagonManager;
    }

    @Override
    public File download(String url, MessageHolder messageHolder) throws DownloadFailedException {
        return this.download(url, Collections.<TransferListener>emptyList(), messageHolder);
    }

    @Override
    public File download(String url, List<TransferListener> transferListeners, MessageHolder messageHolder) throws DownloadFailedException {
        URL sourceUrl;
        File downloaded = this.cache.get(url);
        if (downloaded != null && downloaded.exists()) {
            messageHolder.addMessage("Using cached download: " + downloaded.getAbsolutePath());
            return downloaded;
        }
        try {
            sourceUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new DownloadFailedException(url, "Download failed due to invalid URL. Reason: " + e.getMessage(), e);
        }
        Wagon wagon = null;
        try {
            wagon = this.wagonManager.getWagon(sourceUrl.getProtocol());
        }
        catch (UnsupportedProtocolException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        messageHolder.addMessage("Using wagon: " + wagon + " to download: " + url);
        try {
            downloaded = File.createTempFile("download-", null);
            downloaded.deleteOnExit();
        }
        catch (IOException e) {
            throw new DownloadFailedException(url, "Failed to create temporary file target for download. Reason: " + e.getMessage(), e);
        }
        messageHolder.addMessage("Download target is: " + downloaded.getAbsolutePath());
        String remotePath = sourceUrl.getPath();
        String baseUrl = url.substring(0, url.length() - remotePath.length());
        Iterator<TransferListener> it = transferListeners.iterator();
        while (it.hasNext()) {
            wagon.addTransferListener(it.next());
        }
        Repository repo = new Repository(sourceUrl.getHost(), baseUrl);
        messageHolder.addMessage("Connecting to: " + repo.getHost() + "(baseUrl: " + repo.getUrl() + ")");
        try {
            wagon.connect(repo, this.wagonManager.getAuthenticationInfo(repo.getId()), this.wagonManager.getProxy(sourceUrl.getProtocol()));
        }
        catch (ConnectionException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        catch (AuthenticationException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        messageHolder.addMessage("Getting: " + remotePath);
        try {
            wagon.get(remotePath, downloaded);
            this.cache.put(url, downloaded);
            File e = downloaded;
            return e;
        }
        catch (TransferFailedException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new DownloadFailedException(url, "Download failed. Reason: " + e.getMessage(), e);
        }
        finally {
            if (wagon != null) {
                try {
                    messageHolder.addMessage("Disconnecting.");
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    messageHolder.addMessage("Failed to disconnect wagon for: " + url, e);
                }
                Iterator<TransferListener> it2 = transferListeners.iterator();
                while (it2.hasNext()) {
                    wagon.removeTransferListener(it2.next());
                }
            }
        }
    }
}

