/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.File;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationResult;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;

@Named
@Singleton
public class DefaultInvoker
implements Invoker {
    public static final String ROLE_HINT = "default";
    private static final InvokerLogger DEFAULT_LOGGER = new SystemOutLogger();
    private static final InvocationOutputHandler DEFAULT_OUTPUT_HANDLER = new SystemOutHandler();
    private File localRepositoryDirectory;
    private InvokerLogger logger = DEFAULT_LOGGER;
    private File workingDirectory;
    private File mavenHome;
    private File mavenExecutable;
    private InvocationOutputHandler outputHandler = DEFAULT_OUTPUT_HANDLER;
    private InputStream inputStream;
    private InvocationOutputHandler errorHandler = DEFAULT_OUTPUT_HANDLER;

    @Override
    public InvocationResult execute(InvocationRequest request) throws MavenInvocationException {
        Commandline cli;
        MavenCommandLineBuilder cliBuilder = new MavenCommandLineBuilder();
        if (this.logger != null) {
            cliBuilder.setLogger(this.logger);
        }
        if (this.localRepositoryDirectory != null) {
            cliBuilder.setLocalRepositoryDirectory(this.localRepositoryDirectory);
        }
        if (this.mavenHome != null) {
            cliBuilder.setMavenHome(this.mavenHome);
        }
        if (this.mavenExecutable != null) {
            cliBuilder.setMavenExecutable(this.mavenExecutable);
        }
        if (this.workingDirectory != null) {
            cliBuilder.setBaseDirectory(this.workingDirectory);
        }
        try {
            cli = cliBuilder.build(request);
        }
        catch (CommandLineConfigurationException e) {
            throw new MavenInvocationException("Error configuring command-line. Reason: " + e.getMessage(), e);
        }
        DefaultInvocationResult result = new DefaultInvocationResult();
        try {
            int exitCode = this.executeCommandLine(cli, request, request.getTimeoutInSeconds());
            result.setExitCode(exitCode);
        }
        catch (CommandLineException e) {
            result.setExecutionException(e);
        }
        return result;
    }

    private int executeCommandLine(Commandline cli, InvocationRequest request, int timeoutInSeconds) throws CommandLineException {
        int result;
        InputStream inputStream = request.getInputStream(this.inputStream);
        InvocationOutputHandler outputHandler = request.getOutputHandler(this.outputHandler);
        InvocationOutputHandler errorHandler = request.getErrorHandler(this.errorHandler);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli);
        }
        if (request.isBatchMode()) {
            if (inputStream != null) {
                this.getLogger().info("Executing in batch mode. The configured input stream will be ignored.");
            }
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler, (int)timeoutInSeconds);
        } else if (inputStream == null) {
            this.getLogger().warn("Maven will be executed in interactive mode, but no input stream has been configured for this MavenInvoker instance.");
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler, (int)timeoutInSeconds);
        } else {
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (InputStream)inputStream, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler, (int)timeoutInSeconds);
        }
        return result;
    }

    @Override
    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    @Override
    public InvokerLogger getLogger() {
        return this.logger;
    }

    @Override
    public Invoker setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
        return this;
    }

    @Override
    public Invoker setLogger(InvokerLogger logger) {
        this.logger = logger != null ? logger : DEFAULT_LOGGER;
        return this;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public Invoker setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    @Override
    public File getMavenHome() {
        return this.mavenHome;
    }

    @Override
    public Invoker setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
        return this;
    }

    @Override
    public File getMavenExecutable() {
        return this.mavenExecutable;
    }

    @Override
    public Invoker setMavenExecutable(File mavenExecutable) {
        this.mavenExecutable = mavenExecutable;
        return this;
    }

    @Override
    public Invoker setErrorHandler(InvocationOutputHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public Invoker setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    @Override
    public Invoker setOutputHandler(InvocationOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
        return this;
    }
}

