/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.command.info.GitInfoScmResult;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public abstract class AbstractGitScmProvider
extends AbstractScmProvider {
    public String getScmSpecificFilename() {
        return ".git";
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null) {
            throw new NullPointerException("Path argument is null");
        }
        if (!path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        if (!new File(path, ".git").exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a git checkout directory.");
        }
        try {
            return this.makeProviderScmRepository(this.getRepositoryURL(path), ':');
        }
        catch (ScmException e) {
            throw new ScmRepositoryException("Error executing info command", (Throwable)e);
        }
    }

    protected abstract String getRepositoryURL(File var1) throws ScmException;

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        List messages = new ArrayList();
        try {
            this.makeProviderScmRepository(scmSpecificUrl, delimiter);
        }
        catch (ScmRepositoryException e) {
            messages = e.getValidationMessages();
        }
        return messages;
    }

    public String getScmType() {
        return "git";
    }

    private ScmUrlParserResult parseScmUrl(String scmSpecificUrl) {
        ScmUrlParserResult result = new ScmUrlParserResult();
        String url = scmSpecificUrl;
        if (url.startsWith("file")) {
            if (!url.startsWith("file://")) {
                result.messages.add("A git 'file' url must be on the form 'file://[hostname]/'.");
                return result;
            }
        } else if (url.startsWith("https")) {
            if (!url.startsWith("https://")) {
                result.messages.add("A git 'http' url must be on the form 'https://'.");
                return result;
            }
        } else if (url.startsWith("http")) {
            if (!url.startsWith("http://")) {
                result.messages.add("A git 'http' url must be on the form 'http://'.");
                return result;
            }
        } else if (url.startsWith("ssh")) {
            if (!url.startsWith("ssh://")) {
                result.messages.add("A git 'ssh' url must be on the form 'ssh://'.");
                return result;
            }
        } else if (url.startsWith("git")) {
            if (!url.startsWith("git://") && !url.startsWith("git@")) {
                result.messages.add("A git 'git' url must be on the form 'git://'.");
                return result;
            }
        } else {
            result.messages.add(url + " url isn't a valid git URL.");
            return result;
        }
        result.repository = (ScmProviderRepository)new GitScmProviderRepository(url);
        return result;
    }

    protected abstract GitCommand getAddCommand();

    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (AddScmResult)this.executeCommand(this.getAddCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getBranchCommand();

    protected BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (BranchScmResult)this.executeCommand(this.getBranchCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getChangeLogCommand();

    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ChangeLogScmResult)this.executeCommand(this.getChangeLogCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getCheckInCommand();

    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckInScmResult)this.executeCommand(this.getCheckInCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getCheckOutCommand();

    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckOutScmResult)this.executeCommand(this.getCheckOutCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getDiffCommand();

    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (DiffScmResult)this.executeCommand(this.getDiffCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getExportCommand();

    protected ExportScmResult export(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ExportScmResult)this.executeCommand(this.getExportCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getRemoveCommand();

    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (RemoveScmResult)this.executeCommand(this.getRemoveCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getStatusCommand();

    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (StatusScmResult)this.executeCommand(this.getStatusCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getTagCommand();

    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (TagScmResult)this.executeCommand(this.getTagCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getUpdateCommand();

    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (UpdateScmResult)this.executeCommand(this.getUpdateCommand(), repository, fileSet, parameters);
    }

    protected ScmResult executeCommand(GitCommand command, ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        command.setLogger(this.getLogger());
        return command.execute(repository, fileSet, parameters);
    }

    protected abstract GitCommand getListCommand();

    public ListScmResult list(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getListCommand();
        return (ListScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    protected abstract GitCommand getInfoCommand();

    public GitInfoScmResult info(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getInfoCommand();
        return (GitInfoScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    private static class ScmUrlParserResult {
        private List messages = new ArrayList();
        private ScmProviderRepository repository;

        private ScmUrlParserResult() {
        }
    }
}

