/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.Locale;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

public class ReportDocumentRenderer
implements DocumentRenderer {
    private MavenReport report;
    private RenderingContext renderingContext;
    private Log log;

    public ReportDocumentRenderer(MavenReport report, RenderingContext renderingContext, Log log) {
        this.report = report;
        this.renderingContext = renderingContext;
        this.log = log;
    }

    public void renderDocument(Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext) throws RendererException, FileNotFoundException {
        Locale locale = siteRenderingContext.getLocale();
        String localReportName = this.report.getName(locale);
        this.log.info((CharSequence)("Generate \"" + localReportName + "\" report."));
        SiteRendererSink sink = new SiteRendererSink(this.renderingContext);
        try {
            this.report.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            throw new RendererException("Error rendering Maven report: " + e.getMessage(), (Throwable)e);
        }
        if (!this.report.isExternalReport()) {
            renderer.generateDocument(writer, sink, siteRenderingContext);
        }
    }

    public String getOutputName() {
        return this.renderingContext.getOutputName();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }
}

