/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.MappingJsonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmPublishInventory {
    public static List<File> listInventoryFiles(File basedir, String ignoreFile) {
        ArrayList<File> inventory = new ArrayList<File>();
        inventory.addAll(FileUtils.listFiles((File)basedir, (IOFileFilter)new IgnoreFilter(ignoreFile), (IOFileFilter)new IgnoreFilter(ignoreFile)));
        Collections.sort(inventory);
        return inventory;
    }

    public static List<File> writeInventory(List<File> inventory, File inventoryFile) throws MojoFailureException {
        HashSet<String> paths = new HashSet<String>();
        for (File f : inventory) {
            if (!f.isFile()) continue;
            paths.add(f.getAbsolutePath());
        }
        try {
            MappingJsonFactory factory = new MappingJsonFactory();
            JsonGenerator gen = factory.createJsonGenerator(inventoryFile, JsonEncoding.UTF8);
            gen.writeObject(paths);
            gen.close();
            return inventory;
        }
        catch (JsonProcessingException e) {
            throw new MojoFailureException("Failed to write inventory to " + inventoryFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write inventory to " + inventoryFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public static List<File> readInventory(File inventoryFile) throws MojoFailureException {
        try {
            MappingJsonFactory factory = new MappingJsonFactory();
            JsonParser parser = factory.createJsonParser(inventoryFile);
            Set storedInventory = (Set)parser.readValueAs(HashSet.class);
            ArrayList<File> inventory = new ArrayList<File>();
            for (String p : storedInventory) {
                inventory.add(new File(p));
            }
            parser.close();
            return inventory;
        }
        catch (JsonProcessingException e) {
            throw new MojoFailureException("Failed to write inventory to " + inventoryFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write inventory to " + inventoryFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static class IgnoreFilter
    implements IOFileFilter {
        private final String ignoreFile;

        public IgnoreFilter(String ignoreFile) {
            this.ignoreFile = ignoreFile;
        }

        public boolean accept(File file) {
            return !file.getName().equals(this.ignoreFile);
        }

        public boolean accept(File dir, String name) {
            return !name.equals(this.ignoreFile);
        }
    }
}

